/*
 * Decompiled with CFR 0.152.
 */
package am2.proxy;

import am2.ArsMagica2;
import am2.api.blocks.IKeystoneLockable;
import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.api.spell.SpellComponent;
import am2.armor.ArmorHelper;
import am2.blocks.render.TileArcaneReconstructorRenderer;
import am2.blocks.render.TileAstralBarrierRenderer;
import am2.blocks.render.TileBlackAuremRenderer;
import am2.blocks.render.TileCalefactorRenderer;
import am2.blocks.render.TileCelestialPrismRenderer;
import am2.blocks.render.TileCraftingAltarRenderer;
import am2.blocks.render.TileCrystalMarkerRenderer;
import am2.blocks.render.TileEssenceConduitRenderer;
import am2.blocks.render.TileEverstoneRenderer;
import am2.blocks.render.TileFlickerHabitatRenderer;
import am2.blocks.render.TileIllusionBlockRenderer;
import am2.blocks.render.TileKeystoneChestRenderer;
import am2.blocks.render.TileKeystoneReceptacleRenderer;
import am2.blocks.render.TileLecternRenderer;
import am2.blocks.render.TileMagiciansWorkbenchRenderer;
import am2.blocks.render.TileObeliskRenderer;
import am2.blocks.render.TileOtherworldAuraRenderer;
import am2.blocks.render.TileRuneRenderer;
import am2.blocks.render.TileSeerStoneRenderer;
import am2.blocks.render.TileSummonerRenderer;
import am2.blocks.tileentity.TileEntityArcaneDeconstructor;
import am2.blocks.tileentity.TileEntityArcaneReconstructor;
import am2.blocks.tileentity.TileEntityArmorImbuer;
import am2.blocks.tileentity.TileEntityAstralBarrier;
import am2.blocks.tileentity.TileEntityBlackAurem;
import am2.blocks.tileentity.TileEntityCalefactor;
import am2.blocks.tileentity.TileEntityCelestialPrism;
import am2.blocks.tileentity.TileEntityCraftingAltar;
import am2.blocks.tileentity.TileEntityCrystalMarker;
import am2.blocks.tileentity.TileEntityEssenceConduit;
import am2.blocks.tileentity.TileEntityEssenceRefiner;
import am2.blocks.tileentity.TileEntityEverstone;
import am2.blocks.tileentity.TileEntityFlickerHabitat;
import am2.blocks.tileentity.TileEntityGroundRuneSpell;
import am2.blocks.tileentity.TileEntityIllusionBlock;
import am2.blocks.tileentity.TileEntityInertSpawner;
import am2.blocks.tileentity.TileEntityInscriptionTable;
import am2.blocks.tileentity.TileEntityKeystoneChest;
import am2.blocks.tileentity.TileEntityKeystoneRecepticle;
import am2.blocks.tileentity.TileEntityLectern;
import am2.blocks.tileentity.TileEntityMagiciansWorkbench;
import am2.blocks.tileentity.TileEntityObelisk;
import am2.blocks.tileentity.TileEntityOtherworldAura;
import am2.blocks.tileentity.TileEntityParticleEmitter;
import am2.blocks.tileentity.TileEntitySeerStone;
import am2.blocks.tileentity.TileEntitySpellSealedDoor;
import am2.blocks.tileentity.TileEntitySummoner;
import am2.commands.ConfigureAMUICommand;
import am2.defs.AMSounds;
import am2.defs.BindingsDefs;
import am2.defs.BlockDefs;
import am2.defs.EntityManager;
import am2.defs.ItemDefs;
import am2.extensions.RiftStorage;
import am2.gui.AMGuiHelper;
import am2.gui.AMIngameGUI;
import am2.gui.GuiArcaneDeconstructor;
import am2.gui.GuiArcaneReconstructor;
import am2.gui.GuiArmorImbuer;
import am2.gui.GuiAstralBarrier;
import am2.gui.GuiCalefactor;
import am2.gui.GuiCrystalMarker;
import am2.gui.GuiEssenceBag;
import am2.gui.GuiEssenceRefiner;
import am2.gui.GuiFlickerHabitat;
import am2.gui.GuiInertSpawner;
import am2.gui.GuiInscriptionTable;
import am2.gui.GuiKeystone;
import am2.gui.GuiKeystoneChest;
import am2.gui.GuiKeystoneLockable;
import am2.gui.GuiMagiciansWorkbench;
import am2.gui.GuiObelisk;
import am2.gui.GuiOcculus;
import am2.gui.GuiParticleEmitter;
import am2.gui.GuiRiftStorage;
import am2.gui.GuiRuneBag;
import am2.gui.GuiSeerStone;
import am2.gui.GuiSpellBook;
import am2.gui.GuiSpellCustomization;
import am2.gui.GuiSpellSealedDoor;
import am2.gui.GuiSummoner;
import am2.handler.BakingHandler;
import am2.items.ItemEssenceBag;
import am2.items.ItemKeystone;
import am2.items.ItemRuneBag;
import am2.items.ItemSpellBase;
import am2.items.ItemSpellBook;
import am2.models.ArsMagicaModelLoader;
import am2.models.CullfaceModelLoader;
import am2.models.SpecialRenderModelLoader;
import am2.packet.AMNetHandler;
import am2.packet.AMPacketProcessorClient;
import am2.particles.AMParticleIcons;
import am2.particles.ParticleManagerClient;
import am2.power.PowerNodeEntry;
import am2.power.PowerTypes;
import am2.proxy.CommonProxy;
import am2.proxy.gui.ItemRenderer;
import am2.proxy.tick.ClientTickHandler;
import am2.spell.component.Telekinesis;
import am2.texture.SpellIconManager;
import am2.utils.InventoryUtilities;
import am2.utils.RenderUtils;
import am2.utils.SpellUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientProxy
extends CommonProxy {
    public ClientTickHandler clientTickHandler;

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        switch (ID) {
            case 0: {
                return new GuiOcculus(player);
            }
            case 1: {
                return new GuiSpellCustomization(player);
            }
            case 2: {
                return new GuiRiftStorage(player, RiftStorage.For((EntityLivingBase)player));
            }
            case 3: {
                ItemStack bookStack = player.func_184614_ca();
                if (bookStack.func_77973_b() == null || !(bookStack.func_77973_b() instanceof ItemSpellBook)) {
                    return null;
                }
                ItemSpellBook item = (ItemSpellBook)bookStack.func_77973_b();
                return new GuiSpellBook(player.field_71071_by, bookStack, item.ConvertToInventory(bookStack));
            }
            case 4: {
                return new GuiObelisk((TileEntityObelisk)world.func_175625_s(new BlockPos(x, y, z)), player);
            }
            case 5: {
                return new GuiCrystalMarker(player, (TileEntityCrystalMarker)te);
            }
            case 6: {
                return new GuiInscriptionTable(player.field_71071_by, (TileEntityInscriptionTable)world.func_175625_s(new BlockPos(x, y, z)));
            }
            case 7: {
                return new GuiArmorImbuer(player, (TileEntityArmorImbuer)world.func_175625_s(new BlockPos(x, y, z)));
            }
            case 8: {
                ItemStack keystoneStack = player.func_184614_ca();
                if (keystoneStack.func_77973_b() == null || !(keystoneStack.func_77973_b() instanceof ItemKeystone)) {
                    return null;
                }
                ItemKeystone keystone = (ItemKeystone)keystoneStack.func_77973_b();
                int runeBagSlot = InventoryUtilities.getInventorySlotIndexFor((IInventory)player.field_71071_by, ItemDefs.runeBag);
                ItemStack runeBag = null;
                if (runeBagSlot > -1) {
                    runeBag = player.field_71071_by.func_70301_a(runeBagSlot);
                }
                return new GuiKeystone(player.field_71071_by, player.func_184614_ca(), runeBag, keystone.ConvertToInventory(keystoneStack), runeBag == null ? null : ItemDefs.runeBag.ConvertToInventory(runeBag), runeBagSlot);
            }
            case 9: {
                if (!(te instanceof IKeystoneLockable)) {
                    return null;
                }
                return new GuiKeystoneLockable(player.field_71071_by, (IKeystoneLockable)te);
            }
            case 10: {
                return new GuiSpellSealedDoor(player.field_71071_by, (TileEntitySpellSealedDoor)te);
            }
            case 11: {
                return new GuiKeystoneChest(player.field_71071_by, (TileEntityKeystoneChest)te);
            }
            case 12: {
                ItemStack bagStack = player.func_184614_ca();
                if (bagStack.func_77973_b() == null || !(bagStack.func_77973_b() instanceof ItemRuneBag)) {
                    return null;
                }
                ItemRuneBag runebag = (ItemRuneBag)bagStack.func_77973_b();
                return new GuiRuneBag(player.field_71071_by, player.func_184614_ca(), runebag.ConvertToInventory(bagStack));
            }
            case 13: {
                return new GuiFlickerHabitat(player, (TileEntityFlickerHabitat)te);
            }
            case 14: {
                return new GuiArcaneDeconstructor(player.field_71071_by, (TileEntityArcaneDeconstructor)te);
            }
            case 15: {
                return new GuiArcaneReconstructor(player.field_71071_by, (TileEntityArcaneReconstructor)te);
            }
            case 16: {
                return new GuiAstralBarrier(player.field_71071_by, (TileEntityAstralBarrier)te);
            }
            case 17: {
                return new GuiEssenceRefiner(player.field_71071_by, (TileEntityEssenceRefiner)te);
            }
            case 18: {
                return new GuiMagiciansWorkbench(player.field_71071_by, (TileEntityMagiciansWorkbench)te);
            }
            case 19: {
                return new GuiCalefactor(player, (TileEntityCalefactor)te);
            }
            case 20: {
                return new GuiSeerStone(player.field_71071_by, (TileEntitySeerStone)te);
            }
            case 21: {
                return new GuiInertSpawner(player, (TileEntityInertSpawner)te);
            }
            case 22: {
                return new GuiSummoner(player.field_71071_by, (TileEntitySummoner)te);
            }
            case 23: {
                ItemStack bagStack = player.func_184614_ca();
                if (bagStack.func_77973_b() == null || !(bagStack.func_77973_b() instanceof ItemEssenceBag)) {
                    return null;
                }
                ItemEssenceBag essenceBag = (ItemEssenceBag)bagStack.func_77973_b();
                return new GuiEssenceBag(player.field_71071_by, player.func_184614_ca(), essenceBag.ConvertToInventory(bagStack));
            }
        }
        return super.getClientGuiElement(ID, player, world, x, y, z);
    }

    @Override
    public void preInit() {
        super.preInit();
        OBJLoader.INSTANCE.addDomain("arsmagica2");
        AMParticleIcons.instance.toString();
        SpellIconManager.INSTANCE.toString();
        ClientRegistry.registerKeyBinding((KeyBinding)BindingsDefs.ICE_BRIDGE);
        ClientRegistry.registerKeyBinding((KeyBinding)BindingsDefs.ENDER_TP);
        ClientRegistry.registerKeyBinding((KeyBinding)BindingsDefs.AURA_CUSTOMIZATION);
        ClientRegistry.registerKeyBinding((KeyBinding)BindingsDefs.SHAPE_GROUP);
        ClientRegistry.registerKeyBinding((KeyBinding)BindingsDefs.NIGHT_VISION);
        ClientRegistry.registerKeyBinding((KeyBinding)BindingsDefs.SPELL_BOOK_NEXT);
        ClientRegistry.registerKeyBinding((KeyBinding)BindingsDefs.SPELL_BOOK_PREV);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCraftingAltar.class, (TileEntitySpecialRenderer)new TileCraftingAltarRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityObelisk.class, (TileEntitySpecialRenderer)new TileObeliskRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCelestialPrism.class, (TileEntitySpecialRenderer)new TileCelestialPrismRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlackAurem.class, (TileEntitySpecialRenderer)new TileBlackAuremRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLectern.class, (TileEntitySpecialRenderer)new TileLecternRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityKeystoneRecepticle.class, (TileEntitySpecialRenderer)new TileKeystoneReceptacleRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCrystalMarker.class, (TileEntitySpecialRenderer)new TileCrystalMarkerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFlickerHabitat.class, (TileEntitySpecialRenderer)new TileFlickerHabitatRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityKeystoneChest.class, (TileEntitySpecialRenderer)new TileKeystoneChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEssenceConduit.class, (TileEntitySpecialRenderer)new TileEssenceConduitRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGroundRuneSpell.class, (TileEntitySpecialRenderer)new TileRuneRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEverstone.class, (TileEntitySpecialRenderer)new TileEverstoneRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityArcaneReconstructor.class, (TileEntitySpecialRenderer)new TileArcaneReconstructorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityIllusionBlock.class, (TileEntitySpecialRenderer)new TileIllusionBlockRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySeerStone.class, (TileEntitySpecialRenderer)new TileSeerStoneRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMagiciansWorkbench.class, (TileEntitySpecialRenderer)new TileMagiciansWorkbenchRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCalefactor.class, (TileEntitySpecialRenderer)new TileCalefactorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySummoner.class, (TileEntitySpecialRenderer)new TileSummonerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAstralBarrier.class, (TileEntitySpecialRenderer)new TileAstralBarrierRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityOtherworldAura.class, (TileEntitySpecialRenderer)new TileOtherworldAuraRenderer());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ArsMagicaModelLoader());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new CullfaceModelLoader());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new SpecialRenderModelLoader());
        MinecraftForge.EVENT_BUS.register((Object)new ArsMagicaModelLoader());
        MinecraftForge.EVENT_BUS.register((Object)this.clientTickHandler);
        MinecraftForge.EVENT_BUS.register((Object)ItemRenderer.instance);
        MinecraftForge.EVENT_BUS.register((Object)new BakingHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BindingsDefs());
        MinecraftForge.EVENT_BUS.register((Object)new AMIngameGUI());
        ArsMagica2.config.clientInit();
        new AMSounds();
        EntityManager.instance.registerRenderers();
        this.blocks.preInitClient();
        ClientCommandHandler.instance.func_71560_a((ICommand)new ConfigureAMUICommand());
    }

    @Override
    public void initHandlers() {
        this.particleManager = new ParticleManagerClient();
        this.packetProcessor = new AMPacketProcessorClient();
        this.clientTickHandler = new ClientTickHandler();
    }

    @Override
    public void init() {
        super.init();
        BlockDefs.initClient();
        ItemDefs.initClient();
    }

    @Override
    public void setTrackedLocation(AMVector3 location) {
        this.clientTickHandler.setTrackLocation(location.toVec3D());
    }

    @Override
    public void setTrackedPowerCompound(NBTTagCompound compound) {
        this.clientTickHandler.setTrackData(compound);
    }

    @Override
    public boolean hasTrackedLocationSynced() {
        return this.clientTickHandler.getHasSynced();
    }

    @Override
    public PowerNodeEntry getTrackedData() {
        return this.clientTickHandler.getTrackData();
    }

    @Override
    public boolean setMouseDWheel(int dwheel) {
        if (dwheel == 0) {
            return false;
        }
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (stack == null) {
            return false;
        }
        boolean store = this.checkForTKMove(stack);
        if (!store && stack.func_77973_b() instanceof ItemSpellBook) {
            store = Minecraft.func_71410_x().field_71439_g.func_70093_af();
        }
        if (store) {
            this.clientTickHandler.setDWheel(dwheel / 120, Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c, Minecraft.func_71410_x().field_71439_g.func_184587_cr());
            return true;
        }
        this.clientTickHandler.setDWheel(0, -1, false);
        return false;
    }

    private boolean checkForTKMove(ItemStack stack) {
        ItemStack activeStack;
        if (stack.func_77973_b() instanceof ItemSpellBook && (activeStack = ((ItemSpellBook)stack.func_77973_b()).GetActiveItemStack(stack)) != null) {
            stack = activeStack;
        }
        if (stack.func_77973_b() instanceof ItemSpellBase && stack.func_77942_o() && Minecraft.func_71410_x().field_71439_g.func_184587_cr()) {
            for (SpellComponent component : SpellUtils.getComponentsForStage(stack, -1)) {
                if (!(component instanceof Telekinesis)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void drawPowerOnBlockHighlight(EntityPlayer player, RayTraceResult target, float partialTicks) {
        if (Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD) != null && Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == ItemDefs.magitechGoggles || ArmorHelper.isInfusionPreset(Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD), "mg_gog")) {
            if (target.func_178782_a() == null) {
                return;
            }
            TileEntity te = player.field_70170_p.func_175625_s(target.func_178782_a());
            if (te != null && te instanceof IPowerNode) {
                ArsMagica2.proxy.setTrackedLocation(new AMVector3(target.func_178782_a()));
            } else {
                ArsMagica2.proxy.setTrackedLocation(AMVector3.zero());
            }
            if (ArsMagica2.proxy.hasTrackedLocationSynced()) {
                PowerNodeEntry data = ArsMagica2.proxy.getTrackedData();
                Block block = player.field_70170_p.func_180495_p(target.func_178782_a()).func_177230_c();
                float yOff = 0.5f;
                if (data != null) {
                    GlStateManager.func_179123_a();
                    for (PowerTypes type : ((IPowerNode)te).getValidPowerTypes()) {
                        float pwr = data.getPower(type);
                        float pct = pwr / ((IPowerNode)te).getCapacity() * 100.0f;
                        AMVector3 offset = new AMVector3((double)target.func_178782_a().func_177958_n() + 0.5, (double)target.func_178782_a().func_177958_n() + 0.5, (double)target.func_178782_a().func_177952_p() + 0.5).sub(new AMVector3(player.field_70169_q - (player.field_70169_q - player.field_70165_t) * (double)partialTicks, player.field_70167_r - (player.field_70167_r - player.field_70163_u) * (double)partialTicks + (double)player.func_70047_e(), player.field_70166_s - (player.field_70166_s - player.field_70161_v) * (double)partialTicks));
                        offset = offset.normalize();
                        if ((double)target.func_178782_a().func_177956_o() <= player.field_70163_u + (double)player.func_70047_e()) {
                            RenderUtils.drawTextInWorldAtOffset(String.format("%s%.2f (%.2f%%)", type.getChatColor(), Float.valueOf(pwr), Float.valueOf(pct)), (double)target.func_178782_a().func_177958_n() - (player.field_70169_q - (player.field_70169_q - player.field_70165_t) * (double)partialTicks) + 0.5 - (double)offset.x, (double)((float)target.func_178782_a().func_177956_o() + yOff) - (player.field_70167_r - (player.field_70167_r - player.field_70163_u) * (double)partialTicks) + block.func_185496_a((IBlockState)player.field_70170_p.func_180495_p((BlockPos)target.func_178782_a()), (IBlockAccess)player.field_70170_p, (BlockPos)target.func_178782_a()).field_72337_e * (double)0.8f, (double)target.func_178782_a().func_177952_p() - (player.field_70166_s - (player.field_70166_s - player.field_70161_v) * (double)partialTicks) + 0.5 - (double)offset.z, 0xFFFFFF);
                            yOff += 0.12f;
                            continue;
                        }
                        RenderUtils.drawTextInWorldAtOffset(String.format("%s%.2f (%.2f%%)", type.getChatColor(), Float.valueOf(pwr), Float.valueOf(pct)), (double)target.func_178782_a().func_177958_n() - (player.field_70169_q - (player.field_70169_q - player.field_70165_t) * (double)partialTicks) + 0.5 - (double)offset.x, (double)((float)target.func_178782_a().func_177956_o() - yOff) - (player.field_70167_r - (player.field_70167_r - player.field_70163_u) * (double)partialTicks) - block.func_185496_a((IBlockState)player.field_70170_p.func_180495_p((BlockPos)target.func_178782_a()), (IBlockAccess)player.field_70170_p, (BlockPos)target.func_178782_a()).field_72337_e * (double)0.2f, (double)target.func_178782_a().func_177952_p() - (player.field_70166_s - (player.field_70166_s - player.field_70161_v) * (double)partialTicks) + 0.5 - (double)offset.z, 0xFFFFFF);
                        yOff -= 0.12f;
                    }
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179099_b();
                }
            }
        }
    }

    @Override
    public void requestPowerPathVisuals(IPowerNode<?> node, EntityPlayerMP player) {
        AMNetHandler.INSTANCE.syncPowerPaths(node, player);
    }

    @Override
    public void flashManaBar() {
        AMGuiHelper.instance.flashManaBar();
    }

    @Override
    public void receivePowerPathVisuals(HashMap<PowerTypes, ArrayList<LinkedList<Vec3d>>> paths) {
        powerPathVisuals = paths;
    }

    @Override
    public HashMap<PowerTypes, ArrayList<LinkedList<Vec3d>>> getPowerPathVisuals() {
        return powerPathVisuals;
    }

    @Override
    public EntityPlayer getLocalPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void openParticleBlockGUI(World world, EntityPlayer player, TileEntityParticleEmitter te) {
        if (world.field_72995_K) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiParticleEmitter(te));
        }
    }
}

