/*
 * Decompiled with CFR 0.152.
 */
package am2.proxy.gui;

import am2.api.affinity.Affinity;
import am2.api.event.RenderingItemEvent;
import am2.bosses.models.ModelPlantGuardianSickle;
import am2.defs.ItemDefs;
import am2.items.rendering.SpellParticleRender;
import am2.proxy.gui.ModelLibrary;
import am2.utils.ModelUtils;
import am2.utils.RenderUtils;
import com.google.common.base.Optional;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.util.vector.Quaternion;

public class ItemRenderer {
    private static final ResourceLocation sickleLocation = new ResourceLocation("arsmagica2", "textures/mobs/bosses/plant_guardian.png");
    private static final ResourceLocation arcaneBookLocation = new ResourceLocation("arsmagica2", "textures/mobs/bosses/arcane_guardian.png");
    private static final ResourceLocation winterArmLocation = new ResourceLocation("arsmagica2", "textures/mobs/bosses/ice_guardian.png");
    private static final ResourceLocation airLocation = new ResourceLocation("arsmagica2", "textures/mobs/bosses/air_guardian.png");
    private static final ResourceLocation waterLocation = new ResourceLocation("arsmagica2", "textures/mobs/bosses/water_guardian.png");
    private static final ResourceLocation fireLocation = new ResourceLocation("arsmagica2", "textures/mobs/bosses/fire_guardian.png");
    private static final ResourceLocation earthLocation = new ResourceLocation("arsmagica2", "textures/mobs/bosses/earth_guardian.png");
    private static final ResourceLocation broomLocation = new ResourceLocation("arsmagica2", "textures/mobs/broom.png");
    private static final ResourceLocation candleLocation = new ResourceLocation("arsmagica2", "textures/blocks/custom/candle.png");
    protected ModelPlantGuardianSickle modelSickle;
    public static final ItemRenderer instance = new ItemRenderer();

    private ItemRenderer() {
        Minecraft.func_71410_x();
        this.modelSickle = new ModelPlantGuardianSickle();
        this.modelSickle.setNoSpin();
    }

    @SubscribeEvent
    public void renderItemEvent(RenderingItemEvent event) {
        this.renderItem(event.getCameraTransformType(), event.getStack(), event.getEntity());
        if (event.getStack().func_77973_b() == ItemDefs.BoundShield) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("arsmagica2:textures/models/bound_shield.png"));
            GlStateManager.func_179094_E();
            IItemPropertyGetter getter = ItemDefs.BoundShield.func_185045_a(new ResourceLocation("blocking"));
            ModelUtils.renderShield(event.getStack(), getter.func_185085_a(event.getStack(), (World)Minecraft.func_71410_x().field_71441_e, event.getEntity()) == 1.0f, event.getCameraTransformType(), event.getEntity());
            GlStateManager.func_179121_F();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        }
        if (event.getStack() == null || event.getStack().func_77973_b() == null || Block.func_149634_a((Item)event.getStack().func_77973_b()) == null) {
            return;
        }
        Block block = Block.func_149634_a((Item)event.getStack().func_77973_b());
        if (!(block instanceof ITileEntityProvider)) {
            return;
        }
        TileEntity te = ((ITileEntityProvider)block).func_149915_a((World)Minecraft.func_71410_x().field_71441_e, event.getStack().func_77952_i());
        if (te == null) {
            return;
        }
        TileEntitySpecialRenderer tesr = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te);
        if (tesr == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179084_k();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        TRSRTransformation transform = (TRSRTransformation)ModelUtils.DEFAULT_BLOCK_STATE.apply(Optional.fromNullable((Object)event.getCameraTransformType())).orNull();
        if (transform != null) {
            GlStateManager.func_179109_b((float)transform.getTranslation().x, (float)transform.getTranslation().y, (float)transform.getTranslation().z);
            GlStateManager.func_179152_a((float)transform.getScale().x, (float)transform.getScale().y, (float)transform.getScale().z);
            GlStateManager.func_187444_a((Quaternion)new Quaternion(transform.getLeftRot().x, transform.getLeftRot().y, transform.getLeftRot().z, transform.getLeftRot().w));
        }
        tesr.func_180535_a(te, 0.0, 0.0, 0.0, (float)event.getStack().func_77952_i(), -10);
        GlStateManager.func_179147_l();
        GlStateManager.func_179121_F();
    }

    public void renderItem(ItemCameraTransforms.TransformType type, ItemStack item, Object ... data) {
        if (item == null) {
            return;
        }
        this.bindTextureByItem(item);
        GlStateManager.func_179094_E();
        this.setupItemRender(type, item);
        this.renderModelByItem(item);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        if (item.func_77962_s()) {
            this.setupItemRender(type, item);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179143_c((int)514);
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("textures/misc/enchanted_item_glint.png"));
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
            float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
            GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderUtils.color(-8372020);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179094_E();
            this.renderModelByItem(item);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
            float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
            GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179094_E();
            this.renderModelByItem(item);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179145_e();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179117_G();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        }
        GlStateManager.func_179121_F();
        if (item.func_77973_b() == ItemDefs.wardingCandle) {
            GlStateManager.func_179089_o();
        }
        if (item.func_77973_b() == ItemDefs.wardingCandle && (type == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND)) {
            this.renderCandleFlame(type, item, data);
        }
        GlStateManager.func_179117_G();
    }

    private void renderCandleFlame(ItemCameraTransforms.TransformType type, ItemStack item, Object ... data) {
        if (item.func_77942_o()) {
            GlStateManager.func_179124_c((float)item.func_77978_p().func_74760_g("flame_red"), (float)item.func_77978_p().func_74760_g("flame_green"), (float)item.func_77978_p().func_74760_g("flame_blue"));
        }
        GlStateManager.func_179094_E();
        if (type == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.3f);
            if (type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.17);
            }
            GlStateManager.func_179152_a((float)0.15f, (float)0.15f, (float)0.15f);
        }
        new SpellParticleRender(new ArrayList<ItemOverride>()).renderEffect(Affinity.FIRE, false, (EntityLivingBase)data[0]);
        GlStateManager.func_179121_F();
    }

    private void setupItemRender(ItemCameraTransforms.TransformType type, ItemStack stack) {
        if (stack.func_77973_b() == ItemDefs.natureScythe) {
            if (type != ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179137_b((double)0.05, (double)0.0, (double)-0.3);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)105.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)15.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179139_a((double)0.35, (double)0.35, (double)0.35);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            }
        } else if (stack.func_77973_b() == ItemDefs.winterArm) {
            if (type != ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179137_b((double)0.0, (double)-0.1, (double)-0.85);
            } else {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)-0.1, (double)-0.4);
                GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
            }
        } else if (stack.func_77973_b() == ItemDefs.airSled) {
            GlStateManager.func_179137_b((double)0.0, (double)-0.65, (double)0.0);
        } else if (stack.func_77973_b() == ItemDefs.earthArmor) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
            if (type != ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
            } else {
                GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
                GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
            }
        } else if (stack.func_77973_b() == ItemDefs.arcaneSpellbook) {
            if (type == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179139_a((double)2.2, (double)2.2, (double)2.2);
            }
        } else if (stack.func_77973_b() == ItemDefs.fireEars) {
            if (type == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else if (stack.func_77973_b() == ItemDefs.waterOrbs) {
            GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
            GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
            if (type == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179114_b((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (stack.func_77973_b() == ItemDefs.magicBroom) {
            if (type == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179137_b((double)0.25, (double)0.0, (double)0.0);
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                GlStateManager.func_179114_b((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)105.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        } else if (stack.func_77973_b() == ItemDefs.wardingCandle) {
            GlStateManager.func_179129_p();
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)-1.5, (double)0.0);
            if (type == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179114_b((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
            }
        }
    }

    private void renderModelByItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() == ItemDefs.natureScythe) {
            ModelLibrary.instance.sickle.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemDefs.magicBroom) {
            ModelLibrary.instance.magicBroom.func_78088_a((Entity)ModelLibrary.instance.dummyBroom, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemDefs.arcaneSpellbook) {
            ModelLibrary.instance.dummyArcaneSpellbook.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemDefs.winterArm) {
            ModelLibrary.instance.winterGuardianArm.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemDefs.airSled) {
            ModelLibrary.instance.airSled.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemDefs.waterOrbs) {
            ModelLibrary.instance.waterOrbs.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemDefs.fireEars) {
            ModelLibrary.instance.fireEars.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemDefs.earthArmor) {
            ModelLibrary.instance.earthArmor.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemDefs.wardingCandle) {
            ModelLibrary.instance.wardingCandle.render(0.0625f);
        }
    }

    private void bindTextureByItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() == ItemDefs.natureScythe) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(sickleLocation);
        } else if (stack.func_77973_b() == ItemDefs.magicBroom) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(broomLocation);
        } else if (stack.func_77973_b() == ItemDefs.arcaneSpellbook) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(arcaneBookLocation);
        } else if (stack.func_77973_b() == ItemDefs.winterArm) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(winterArmLocation);
        } else if (stack.func_77973_b() == ItemDefs.airSled) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(airLocation);
        } else if (stack.func_77973_b() == ItemDefs.waterOrbs) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(waterLocation);
        } else if (stack.func_77973_b() == ItemDefs.fireEars) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(fireLocation);
        } else if (stack.func_77973_b() == ItemDefs.earthArmor) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(earthLocation);
        } else if (stack.func_77973_b() == ItemDefs.wardingCandle) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(candleLocation);
        }
    }
}

