/*
 * Decompiled with CFR 0.152.
 */
package am2.proxy.tick;

import am2.ArsMagica2;
import am2.LogHelper;
import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.api.spell.SpellComponent;
import am2.armor.ArmorHelper;
import am2.bosses.BossSpawnHelper;
import am2.defs.ItemDefs;
import am2.extensions.EntityExtension;
import am2.gui.AMGuiHelper;
import am2.items.ItemSpellBase;
import am2.items.ItemSpellBook;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.particles.AMLineArc;
import am2.power.PowerNodeEntry;
import am2.power.PowerTypes;
import am2.spell.component.Telekinesis;
import am2.trackers.EntityItemWatcher;
import am2.utils.DimensionUtilities;
import am2.utils.SpellUtils;
import am2.world.MeteorSpawnHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientTickHandler {
    public static HashMap<EntityLiving, EntityLivingBase> targetsToSet = new HashMap();
    private int mouseWheelValue = 0;
    private int currentSlot = -1;
    private boolean usingItem;
    public static String worldName;
    private boolean firstTick = true;
    private boolean compendiumLoad;
    private ArrayList<AMLineArc> arcs = new ArrayList();
    private int arcSpawnCounter = 0;
    private final int arcSpawnFrequency = 95;
    private int powerWatchSyncTick = 0;
    private Vec3d powerWatch = Vec3d.field_186680_a;
    private boolean hasSynced = false;
    private PowerNodeEntry powerData = null;
    private String lastWorldName;

    private void gameTick_Start() {
        if (Minecraft.func_71410_x().func_71387_A()) {
            if (worldName == null || !worldName.equals(Minecraft.func_71410_x().func_71401_C().func_71221_J())) {
                worldName = Minecraft.func_71410_x().func_71401_C().func_71221_J();
                this.firstTick = true;
            }
        } else if (worldName != null && (this.lastWorldName == null || this.lastWorldName != worldName.replace(" ", "_"))) {
            this.lastWorldName = worldName.replace(" ", "_");
            this.firstTick = true;
        }
        if (this.firstTick) {
            this.compendiumLoad = true;
            this.firstTick = false;
        }
        if (this.compendiumLoad) {
            this.compendiumLoad = false;
        }
        ArsMagica2.proxy.itemFrameWatcher.checkWatchedFrames();
    }

    private void applyDeferredPotionEffects() {
        for (EntityLivingBase ent : ArsMagica2.proxy.getDeferredPotionEffects().keySet()) {
            ArrayList potions = (ArrayList)ArsMagica2.proxy.getDeferredPotionEffects().get((Object)ent);
            for (PotionEffect effect : potions) {
                ent.func_70690_d(effect);
            }
        }
        ArsMagica2.proxy.clearDeferredPotionEffects();
    }

    private void applyDeferredDimensionTransfers() {
        for (EntityLivingBase ent : ArsMagica2.proxy.getDeferredDimensionTransfers().keySet()) {
            DimensionUtilities.doDimensionTransfer(ent, (Integer)ArsMagica2.proxy.getDeferredDimensionTransfers().get((Object)ent));
        }
        ArsMagica2.proxy.clearDeferredDimensionTransfers();
    }

    private void gameTick_End() {
        AMGuiHelper.instance.tick();
        EntityItemWatcher.instance.tick();
        this.checkMouseDWheel();
        if (Minecraft.func_71410_x().func_71387_A()) {
            MeteorSpawnHelper.instance.tick();
            this.applyDeferredPotionEffects();
        }
        if (!this.powerWatch.equals((Object)Vec3d.field_186680_a)) {
            if (this.powerWatchSyncTick++ == 0) {
                AMNetHandler.INSTANCE.sendPowerRequestToServer(this.powerWatch);
            }
            this.powerWatchSyncTick %= 20;
        }
    }

    private void spawnPowerPathVisuals() {
        if (Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD) != null && (Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == ItemDefs.magitechGoggles || ArmorHelper.isInfusionPreset(Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD), "mg_gog"))) {
            if (this.arcSpawnCounter++ >= 95) {
                this.arcSpawnCounter = 0;
                AMVector3 playerPos = new AMVector3((Entity)Minecraft.func_71410_x().field_71439_g);
                HashMap<PowerTypes, ArrayList<LinkedList<Vec3d>>> paths = ArsMagica2.proxy.getPowerPathVisuals();
                if (paths != null) {
                    for (PowerTypes type : paths.keySet()) {
                        String texture = type == PowerTypes.LIGHT ? "textures/blocks/oreblockbluetopaz.png" : (type == PowerTypes.NEUTRAL ? "textures/blocks/oreblockvinteum.png" : (type == PowerTypes.DARK ? "textures/blocks/oreblocksunstone.png" : "textures/blocks/oreblocksunstone.png"));
                        ArrayList<LinkedList<Vec3d>> pathList = paths.get(type);
                        block1: for (LinkedList<Vec3d> individualPath : pathList) {
                            for (int i = 0; i < individualPath.size() - 1; ++i) {
                                double endZ;
                                double endY;
                                double endX;
                                double startZ;
                                double startY;
                                Vec3d start = individualPath.get(i + 1);
                                Vec3d end = individualPath.get(i);
                                if (start.func_72436_e(playerPos.toVec3D()) > 2500.0 || end.func_72436_e(playerPos.toVec3D()) > 2500.0) continue;
                                TileEntity teStart = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(start));
                                TileEntity teEnd = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(end));
                                if (teEnd == null || !(teEnd instanceof IPowerNode)) continue block1;
                                double startX = start.field_72450_a + (double)(teStart != null && teStart instanceof IPowerNode ? ((IPowerNode)teStart).particleOffset(0) : 0.5f);
                                AMLineArc arc = (AMLineArc)((Object)ArsMagica2.proxy.particleManager.spawn((World)Minecraft.func_71410_x().field_71441_e, texture, startX, startY = start.field_72448_b + (double)(teStart != null && teStart instanceof IPowerNode ? ((IPowerNode)teStart).particleOffset(1) : 0.5f), startZ = start.field_72449_c + (double)(teStart != null && teStart instanceof IPowerNode ? ((IPowerNode)teStart).particleOffset(2) : 0.5f), endX = end.field_72450_a + (double)((IPowerNode)teEnd).particleOffset(0), endY = end.field_72448_b + (double)((IPowerNode)teEnd).particleOffset(1), endZ = end.field_72449_c + (double)((IPowerNode)teEnd).particleOffset(2)));
                                if (arc == null) continue;
                                this.arcs.add(arc);
                            }
                        }
                    }
                }
            }
        } else {
            Iterator<AMLineArc> it = this.arcs.iterator();
            while (it.hasNext()) {
                AMLineArc arc = it.next();
                if (arc == null || !arc.func_187113_k()) {
                    it.remove();
                    continue;
                }
                arc.func_187112_i();
            }
            this.arcSpawnCounter = 95;
        }
    }

    private void checkMouseDWheel() {
        if (this.mouseWheelValue != 0 && this.currentSlot > -1) {
            Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c = this.currentSlot;
            ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
            if (this.checkForTKMove(stack)) {
                EntityExtension props = EntityExtension.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
                if (this.mouseWheelValue > 0 && props.getTKDistance() < 10.0f) {
                    props.addToTKDistance(0.5f);
                } else if (this.mouseWheelValue < 0 && (double)props.getTKDistance() > 0.3) {
                    props.addToTKDistance(-0.5f);
                }
                LogHelper.debug("TK Distance: %.2f", Float.valueOf(props.getTKDistance()));
                props.syncTKDistance();
            } else if (stack.func_77973_b() instanceof ItemSpellBook && Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
                ItemSpellBook isb = (ItemSpellBook)stack.func_77973_b();
                if (this.mouseWheelValue != 0) {
                    byte subID = 0;
                    if (this.mouseWheelValue < 0) {
                        isb.SetNextSlot(Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND));
                        subID = 0;
                    } else {
                        isb.SetPrevSlot(Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND));
                        subID = 1;
                    }
                    AMNetHandler.INSTANCE.sendPacketToServer((byte)14, new AMDataWriter().add(subID).add(Minecraft.func_71410_x().field_71439_g.func_145782_y()).add(Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c).generate());
                }
            }
            this.currentSlot = -1;
            this.mouseWheelValue = 0;
        }
    }

    private boolean checkForTKMove(ItemStack stack) {
        ItemStack activeStack;
        if (stack.func_77973_b() instanceof ItemSpellBook && (activeStack = ((ItemSpellBook)stack.func_77973_b()).GetActiveItemStack(stack)) != null) {
            stack = activeStack;
        }
        if (stack.func_77973_b() instanceof ItemSpellBase && stack.func_77942_o() && this.usingItem) {
            for (SpellComponent component : SpellUtils.getComponentsForStage(stack, -1)) {
                if (!(component instanceof Telekinesis)) continue;
                return true;
            }
        }
        return false;
    }

    private void renderTick_Start() {
        if (!Minecraft.func_71410_x().field_71415_G) {
            AMGuiHelper.instance.guiTick();
        }
    }

    private void renderTick_End() {
    }

    private void localServerTick_End() {
        BossSpawnHelper.instance.tick();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            GuiScreen guiscreen = Minecraft.func_71410_x().field_71462_r;
            if (guiscreen == null) {
                this.gameTick_Start();
            }
        } else if (event.phase == TickEvent.Phase.END) {
            GuiScreen guiscreen = Minecraft.func_71410_x().field_71462_r;
            if (guiscreen == null) {
                this.gameTick_End();
            }
            if (Minecraft.func_71410_x().field_71441_e != null) {
                this.spawnPowerPathVisuals();
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.renderTick_Start();
        } else if (event.phase == TickEvent.Phase.END) {
            this.renderTick_End();
        }
    }

    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        ArsMagica2.proxy.drawPowerOnBlockHighlight(event.getPlayer(), event.getTarget(), event.getPartialTicks());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.applyDeferredDimensionTransfers();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.localServerTick_End();
        }
    }

    public void setDWheel(int dWheel, int slot, boolean usingItem) {
        this.mouseWheelValue = dWheel;
        this.currentSlot = slot;
        this.usingItem = usingItem;
    }

    public Vec3d getTrackLocation() {
        return this.powerWatch;
    }

    public PowerNodeEntry getTrackData() {
        return this.powerData;
    }

    public void setTrackLocation(Vec3d location) {
        if (location.equals((Object)Vec3d.field_186680_a)) {
            this.hasSynced = false;
            this.powerWatch = location;
            return;
        }
        if (!this.powerWatch.equals((Object)location)) {
            this.powerWatch = location;
            this.powerWatchSyncTick = 0;
            this.hasSynced = false;
        }
    }

    public void setTrackData(NBTTagCompound compound) {
        this.powerData = new PowerNodeEntry();
        this.powerData.readFromNBT(compound);
        this.hasSynced = true;
    }

    public boolean getHasSynced() {
        return this.hasSynced;
    }

    public void addDeferredTarget(EntityLiving ent, EntityLivingBase target) {
        targetsToSet.put(ent, target);
    }
}

