/*
 * Decompiled with CFR 0.152.
 */
package am2.proxy.tick;

import am2.ArsMagica2;
import am2.bosses.BossSpawnHelper;
import am2.defs.ItemDefs;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.trackers.EntityItemWatcher;
import am2.utils.DimensionUtilities;
import am2.world.MeteorSpawnHelper;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ServerTickHandler {
    private boolean firstTick = true;
    public static HashMap<EntityLiving, EntityLivingBase> targetsToSet = new HashMap();
    public static String lastWorldName;

    private void gameTick_Start() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I() != lastWorldName) {
            lastWorldName = FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I();
            this.firstTick = true;
        }
        if (this.firstTick) {
            ItemDefs.crystalPhylactery.getSpawnableEntities((World)FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0]);
            this.firstTick = false;
        }
        ArsMagica2.proxy.itemFrameWatcher.checkWatchedFrames();
    }

    private void gameTick_End() {
        BossSpawnHelper.instance.tick();
        MeteorSpawnHelper.instance.tick();
        EntityItemWatcher.instance.tick();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.gameTick_Start();
        } else if (event.phase == TickEvent.Phase.END) {
            this.gameTick_End();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        this.applyDeferredPotionEffects();
        if (event.phase == TickEvent.Phase.END) {
            this.applyDeferredDimensionTransfers();
        }
    }

    private void applyDeferredPotionEffects() {
        for (EntityLivingBase ent : ArsMagica2.proxy.getDeferredPotionEffects().keySet()) {
            ArrayList potions = (ArrayList)ArsMagica2.proxy.getDeferredPotionEffects().get((Object)ent);
            for (PotionEffect effect : potions) {
                ent.func_70690_d(effect);
            }
        }
        ArsMagica2.proxy.clearDeferredPotionEffects();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent e) {
        if (!e.getModID().equals("arsmagica2")) {
            return;
        }
        ArsMagica2.config.save();
        ArsMagica2.config.init();
        ArsMagica2.disabledSkills.save();
        ArsMagica2.disabledSkills.getDisabledSkills(true);
    }

    private void applyDeferredDimensionTransfers() {
        for (EntityLivingBase ent : ArsMagica2.proxy.getDeferredDimensionTransfers().keySet()) {
            DimensionUtilities.doDimensionTransfer(ent, (Integer)ArsMagica2.proxy.getDeferredDimensionTransfers().get((Object)ent));
        }
        ArsMagica2.proxy.clearDeferredDimensionTransfers();
    }

    public void addDeferredTarget(EntityLiving ent, EntityLivingBase target) {
        targetsToSet.put(ent, target);
    }

    public void blackoutArmorPiece(EntityPlayerMP player, EntityEquipmentSlot slot, int cooldown) {
        AMNetHandler.INSTANCE.sendPacketToClientPlayer(player, (byte)9, new AMDataWriter().add(slot.func_188454_b()).add(cooldown).generate());
    }
}

