/*
 * Decompiled with CFR 0.152.
 */
package am2.spell;

import am2.api.SpellRegistry;
import am2.api.spell.AbstractSpellPart;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellShape;
import am2.spell.component.Summon;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.text.translation.I18n;

public class SpellValidator {
    public static final SpellValidator instance = new SpellValidator();

    private SpellValidator() {
    }

    public ValidationResult spellDefIsValid(ArrayList<ArrayList<AbstractSpellPart>> shapeGroups, ArrayList<ArrayList<AbstractSpellPart>> segmented) {
        ValidationResult result;
        int i;
        boolean noParts = true;
        for (i = 0; i < shapeGroups.size(); ++i) {
            if (shapeGroups.get(i).size() <= 0) continue;
            noParts = false;
        }
        for (i = 0; i < segmented.size(); ++i) {
            if (segmented.get(i).size() <= 0) continue;
            noParts = false;
        }
        if (noParts) {
            return new ValidationResult(null, "");
        }
        boolean validatedAny = false;
        for (int x = 0; x < shapeGroups.size(); ++x) {
            ValidationResult result2;
            if (shapeGroups.get(x).size() <= 0) continue;
            if (segmented.size() == 0 && (result2 = this.internalValidation(SpellValidator.splitToStages(shapeGroups.get(x)))) != null) {
                return result2;
            }
            ArrayList<AbstractSpellPart> concatenated = new ArrayList<AbstractSpellPart>();
            concatenated.addAll((Collection)shapeGroups.get(x));
            for (int i2 = 0; i2 < segmented.size(); ++i2) {
                concatenated.addAll((Collection<AbstractSpellPart>)segmented.get(i2));
            }
            ValidationResult result3 = this.internalValidation(SpellValidator.splitToStages(concatenated));
            if (result3 != null) {
                return result3;
            }
            validatedAny = true;
        }
        if (!validatedAny && (result = this.internalValidation(segmented)) != null) {
            return result;
        }
        return new ValidationResult();
    }

    private ValidationResult internalValidation(ArrayList<ArrayList<AbstractSpellPart>> segmented) {
        for (int i = 0; i < segmented.size(); ++i) {
            StageValidations result = this.validateStage(segmented.get(i), i == segmented.size() - 1);
            if (result == StageValidations.NOT_VALID) {
                return new ValidationResult(segmented.get(i).get(0), I18n.func_74838_a((String)"am2.spell.validate.compMiss"));
            }
            if (result == StageValidations.PRINCIPUM && i == segmented.size() - 1) {
                return new ValidationResult(segmented.get(i).get(0), String.format("%s %s", new Object[]{SpellRegistry.getSkillFromPart(segmented.get(i).get(0)), I18n.func_74838_a((String)"am2.spell.validate.principum")}));
            }
            if (result != StageValidations.TERMINUS || i >= segmented.size() - 1) continue;
            return new ValidationResult(segmented.get(i).get(0), String.format("%s %s", new Object[]{SpellRegistry.getSkillFromPart(segmented.get(i).get(0)), I18n.func_74838_a((String)"am2.spell.validate.terminus")}));
        }
        return null;
    }

    private StageValidations validateStage(ArrayList<AbstractSpellPart> stageDefinition, boolean isFinalStage) {
        boolean terminus = false;
        boolean principum = false;
        boolean one_component = !isFinalStage;
        boolean one_shape = false;
        for (AbstractSpellPart part : stageDefinition) {
            if (part instanceof Summon) {
                return StageValidations.TERMINUS;
            }
            if (part instanceof SpellShape) {
                one_shape = true;
                if (((SpellShape)part).isTerminusShape()) {
                    terminus = true;
                }
                if (!((SpellShape)part).isPrincipumShape()) continue;
                principum = true;
                continue;
            }
            if (!(part instanceof SpellComponent)) continue;
            one_component = true;
        }
        if (principum) {
            return StageValidations.PRINCIPUM;
        }
        if (!one_component || !one_shape) {
            return StageValidations.NOT_VALID;
        }
        if (terminus) {
            return StageValidations.TERMINUS;
        }
        return StageValidations.VALID;
    }

    public static ArrayList<ArrayList<AbstractSpellPart>> splitToStages(ArrayList<AbstractSpellPart> currentRecipe) {
        ArrayList<ArrayList<AbstractSpellPart>> segmented = new ArrayList<ArrayList<AbstractSpellPart>>();
        int idx = currentRecipe.size() > 0 && currentRecipe.get(0) instanceof SpellShape ? -1 : 0;
        for (int i = 0; i < currentRecipe.size(); ++i) {
            AbstractSpellPart part = currentRecipe.get(i);
            if (part instanceof SpellShape) {
                ++idx;
            }
            if (segmented.size() - 1 < idx) {
                segmented.add(new ArrayList());
            }
            segmented.get(idx).add(part);
        }
        return segmented;
    }

    public boolean modifierCanBeAdded(SpellModifier modifier) {
        return false;
    }

    public class ValidationResult {
        public final boolean valid;
        public final AbstractSpellPart offendingPart;
        public final String message;

        public ValidationResult(AbstractSpellPart offendingPart, String message) {
            this.valid = false;
            this.offendingPart = offendingPart;
            this.message = message;
        }

        public ValidationResult() {
            this.valid = true;
            this.offendingPart = null;
            this.message = "";
        }
    }

    private static enum StageValidations {
        VALID,
        TERMINUS,
        PRINCIPUM,
        NOT_VALID;

    }
}

