/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.blocks.BlockArsMagicaBlock;
import am2.defs.BlockDefs;
import am2.items.ItemSpellBook;
import am2.particles.AMParticle;
import am2.particles.ParticleOrbitPoint;
import am2.utils.DummyEntityPlayer;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;

public class Appropriation
extends SpellComponent {
    private static final String storageKey = "stored_data";
    private static final String storageType = "storage_type";

    @Override
    public Object[] getRecipe() {
        return new Object[]{Items.field_151079_bi, new ItemStack((Block)BlockDefs.blocks, 1, BlockArsMagicaBlock.EnumBlockType.CHIMERITE.ordinal()), Blocks.field_150486_ae};
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityPlayer) {
            return false;
        }
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        ItemStack originalSpellStack = this.getOriginalSpellStack((EntityPlayer)caster);
        if (originalSpellStack == null) {
            return false;
        }
        if (!world.field_72995_K) {
            if (originalSpellStack.func_77978_p().func_74764_b(storageKey)) {
                this.restore((EntityPlayer)caster, world, originalSpellStack, target.func_180425_c(), target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v);
            } else {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("class", target.getClass().getName());
                data.func_74778_a(storageType, "ent");
                NBTTagCompound targetData = new NBTTagCompound();
                target.func_189511_e(targetData);
                data.func_74782_a("targetNBT", (NBTBase)targetData);
                originalSpellStack.func_77978_p().func_74782_a(storageKey, (NBTBase)data);
                this.setOriginalSpellStackData((EntityPlayer)caster, originalSpellStack);
                target.func_70106_y();
            }
        }
        return true;
    }

    private void setOriginalSpellStackData(EntityPlayer caster, ItemStack modifiedStack) {
        ItemStack originalSpellStack = caster.func_184614_ca();
        if (originalSpellStack == null) {
            return;
        }
        if (originalSpellStack.func_77973_b() instanceof ItemSpellBook) {
            ((ItemSpellBook)originalSpellStack.func_77973_b()).replaceAciveItemStack(originalSpellStack, modifiedStack);
        } else {
            caster.field_71071_by.func_70299_a(caster.field_71071_by.field_70461_c, modifiedStack);
        }
    }

    private ItemStack getOriginalSpellStack(EntityPlayer caster) {
        ItemStack originalSpellStack = caster.func_184614_ca();
        if (originalSpellStack == null) {
            return null;
        }
        if (originalSpellStack.func_77973_b() instanceof ItemSpellBook) {
            originalSpellStack = ((ItemSpellBook)originalSpellStack.func_77973_b()).GetActiveItemStack(originalSpellStack);
            boolean hasAppropriation = false;
            for (int i = 0; i < SpellUtils.numStages(originalSpellStack); ++i) {
                if (!SpellUtils.componentIsPresent(originalSpellStack, Appropriation.class)) continue;
                hasAppropriation = true;
                break;
            }
            if (!hasAppropriation) {
                return null;
            }
        }
        return originalSpellStack;
    }

    private void restore(EntityPlayer player, World world, ItemStack stack, BlockPos pos, double hitX, double hitY, double hitZ) {
        if (stack.func_77978_p().func_74764_b(storageKey)) {
            NBTTagCompound storageCompound = stack.func_77978_p().func_74775_l(storageKey);
            if (storageCompound != null) {
                String type = storageCompound.func_74779_i(storageType);
                if (type.equals("ent")) {
                    String clazz = storageCompound.func_74779_i("class");
                    NBTTagCompound entData = storageCompound.func_74775_l("targetNBT");
                    try {
                        Entity ent = (Entity)Class.forName(clazz).getConstructor(World.class).newInstance(world);
                        ent.func_70020_e(entData);
                        ent.func_70107_b(hitX, hitY, hitZ);
                        world.func_72838_d(ent);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                } else if (type.equals("block")) {
                    TileEntity te;
                    int blockID = storageCompound.func_74762_e("blockID");
                    int meta = storageCompound.func_74762_e("meta");
                    Block block = Block.func_149729_e((int)blockID);
                    if (block == null) {
                        if (!player.field_70170_p.field_72995_K) {
                            player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.approError")));
                        }
                        stack.func_77978_p().func_82580_o(storageKey);
                        return;
                    }
                    world.func_180501_a(pos, block.func_176203_a(meta), 2);
                    if (storageCompound.func_74764_b("tileEntity") && (te = world.func_175625_s(pos)) != null) {
                        te.func_145839_a(storageCompound.func_74775_l("tileEntity"));
                        te.func_174878_a(pos);
                        te.func_145834_a(world);
                    }
                }
            }
            stack.func_77978_p().func_82580_o(storageKey);
            this.setOriginalSpellStackData(player, stack);
        }
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 415.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 5 + 5 * ArsMagica2.config.getGFXLevel(); ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "water_ball", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.func_187114_a(10);
            particle.setParticleScale(0.1f);
            particle.AddParticleController(new ParticleOrbitPoint(particle, x, y, z, 1, false).SetTargetDistance(world.field_73012_v.nextDouble() + (double)0.1f).SetOrbitSpeed(0.2f));
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.WATER});
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        ItemStack originalSpellStack = this.getOriginalSpellStack((EntityPlayer)caster);
        if (originalSpellStack == null) {
            return false;
        }
        if (originalSpellStack.func_77978_p() == null) {
            return false;
        }
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (!world.field_72995_K) {
            if (originalSpellStack.func_77978_p().func_74764_b(storageKey)) {
                if (world.func_180495_p(blockPos).equals(Blocks.field_150350_a.func_176223_P())) {
                    blockFace = null;
                }
                if (blockFace != null) {
                    blockPos = blockPos.func_177971_a(blockFace.func_176730_m());
                }
                if (world.func_175623_d(blockPos) || !world.func_180495_p(blockPos).func_185904_a().func_76220_a()) {
                    NBTTagCompound nbt = null;
                    if (stack.func_77978_p() != null) {
                        nbt = stack.func_77978_p().func_74737_b();
                    }
                    EntityPlayerMP casterPlayer = (EntityPlayerMP)DummyEntityPlayer.fromEntityLiving(caster);
                    world.captureBlockSnapshots = true;
                    this.restore((EntityPlayer)caster, world, originalSpellStack, blockPos, impactX, impactY, impactZ);
                    world.captureBlockSnapshots = false;
                    NBTTagCompound newNBT = null;
                    if (stack.func_77978_p() != null) {
                        newNBT = stack.func_77978_p().func_74737_b();
                    }
                    BlockEvent.MultiPlaceEvent placeEvent = null;
                    List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
                    world.capturedBlockSnapshots.clear();
                    if (nbt != null) {
                        stack.func_77982_d(nbt);
                    }
                    if (blockSnapshots.size() > 1) {
                        placeEvent = ForgeEventFactory.onPlayerMultiBlockPlace((EntityPlayer)casterPlayer, (List)blockSnapshots, (EnumFacing)blockFace);
                    } else if (blockSnapshots.size() == 1) {
                        placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)casterPlayer, (BlockSnapshot)((BlockSnapshot)blockSnapshots.get(0)), (EnumFacing)blockFace);
                    }
                    if (placeEvent != null && placeEvent.isCanceled()) {
                        for (BlockSnapshot blocksnapshot : blockSnapshots) {
                            world.restoringBlockSnapshots = true;
                            blocksnapshot.restore(true, false);
                            world.restoringBlockSnapshots = false;
                        }
                        return false;
                    }
                    if (nbt != null) {
                        stack.func_77982_d(newNBT);
                    }
                    for (BlockSnapshot blocksnapshot : blockSnapshots) {
                        BlockPos pos = blocksnapshot.getPos();
                        int updateFlag = blocksnapshot.getFlag();
                        IBlockState oldBlock = blocksnapshot.getReplacedBlock();
                        IBlockState newBlock = world.func_180495_p(pos);
                        if (newBlock != null && !newBlock.func_177230_c().hasTileEntity(newBlock)) {
                            newBlock.func_177230_c().func_176213_c(world, pos, newBlock);
                        }
                        world.markAndNotifyBlock(pos, null, oldBlock, newBlock, updateFlag);
                    }
                    world.capturedBlockSnapshots.clear();
                }
            } else {
                if (block == null || block.func_176195_g(world.func_180495_p(blockPos), world, blockPos) == -1.0f) {
                    return false;
                }
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a(storageType, "block");
                data.func_74768_a("blockID", Block.func_149682_b((Block)block));
                int meta = world.func_180495_p(blockPos).func_177230_c().func_176201_c(world.func_180495_p(blockPos));
                data.func_74768_a("meta", meta);
                EntityPlayerMP casterPlayer = (EntityPlayerMP)DummyEntityPlayer.fromEntityLiving(caster);
                if (!ForgeEventFactory.doPlayerHarvestCheck((EntityPlayer)casterPlayer, (IBlockState)world.func_180495_p(blockPos), (boolean)true)) {
                    return false;
                }
                int event = ForgeHooks.onBlockBreakEvent((World)world, (GameType)casterPlayer.field_71134_c.func_73081_b(), (EntityPlayerMP)casterPlayer, (BlockPos)blockPos);
                if (event == -1) {
                    return false;
                }
                TileEntity te = world.func_175625_s(blockPos);
                if (te != null) {
                    NBTTagCompound teData = new NBTTagCompound();
                    te.func_189515_b(teData);
                    data.func_74782_a("tileEntity", (NBTBase)teData);
                    try {
                        world.func_175713_t(blockPos);
                    }
                    catch (Throwable exception) {
                        exception.printStackTrace();
                    }
                }
                originalSpellStack.func_77978_p().func_74782_a(storageKey, (NBTBase)data);
                this.setOriginalSpellStackData((EntityPlayer)caster, originalSpellStack);
                world.func_175698_g(blockPos);
            }
        }
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }
}

