/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.extensions.EntityExtension;
import am2.particles.AMParticle;
import am2.particles.ParticleApproachPoint;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Attract
extends SpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        this.doTK_Extrapolated(stack, world, impactX, impactY, impactZ, caster);
        return true;
    }

    private boolean doTK_Extrapolated(ItemStack stack, World world, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        EntityLivingBase target;
        double range;
        RayTraceResult mop;
        if (caster instanceof EntityPlayer && (mop = ItemDefs.spell.getMovingObjectPosition(caster, world, range = (double)EntityExtension.For(caster).getTKDistance(), false, false)) == null) {
            impactX = caster.field_70165_t + Math.cos(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            impactZ = caster.field_70161_v + Math.sin(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            impactY = caster.field_70163_u + (double)caster.func_70047_e() + -Math.sin(Math.toRadians(caster.field_70125_A)) * range;
        }
        if ((target = this.getClosestEntityToPointWithin(caster, world, new Vec3i(impactX, impactY, impactZ), 16.0)) == null) {
            return false;
        }
        Vec3d movement = new Vec3d((Vec3i)target.func_180425_c().func_177973_b(new Vec3i(impactX, impactY, impactZ))).func_72432_b();
        if (!world.field_72995_K) {
            float factor = 0.75f;
            double x = -(movement.field_72450_a * (double)factor);
            double y = -(movement.field_72448_b * (double)factor);
            double z = -(movement.field_72449_c * (double)factor);
            target.func_70024_g(x, y, z);
            if (Math.abs(target.field_70159_w) > Math.abs(x * 2.0)) {
                target.field_70159_w = x * (target.field_70159_w / target.field_70159_w);
            }
            if (Math.abs(target.field_70181_x) > Math.abs(y * 2.0)) {
                target.field_70181_x = y * (target.field_70181_x / target.field_70181_x);
            }
            if (Math.abs(target.field_70179_y) > Math.abs(z * 2.0)) {
                target.field_70179_y = z * (target.field_70179_y / target.field_70179_y);
            }
        }
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    private EntityLivingBase getClosestEntityToPointWithin(EntityLivingBase caster, World world, Vec3i point, double radius) {
        AxisAlignedBB bb = new AxisAlignedBB((double)point.func_177958_n() - radius, (double)point.func_177956_o() - radius, (double)point.func_177952_p() - radius, (double)point.func_177958_n() + radius, (double)point.func_177956_o() + radius, (double)point.func_177952_p() + radius);
        List entities = world.func_72872_a(EntityLivingBase.class, bb);
        EntityLivingBase closest = null;
        for (EntityLivingBase e : entities) {
            if (e == caster || closest != null && !(point.func_177951_i((Vec3i)e.func_180425_c()) < point.func_177951_i((Vec3i)closest.func_180425_c()))) continue;
            closest = e;
        }
        return closest;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        this.doTK_Extrapolated(stack, world, target.field_70165_t, target.field_70163_u, target.field_70161_v, caster);
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 2.6f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "arcane", x, y, z));
        if (effect != null) {
            effect.addRandomOffset(1.0, 1.0, 1.0);
            effect.AddParticleController(new ParticleApproachPoint(effect, x, y, z, 0.025f, 0.025f, 1, false));
            effect.setRGBColorF(0.8f, 0.3f, 0.7f);
            if (colorModifier > -1) {
                effect.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.NONE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLACK.func_176767_b()), Items.field_151042_j};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 1.0f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

