/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.rituals.IRitualInteraction;
import am2.api.rituals.RitualShapeHelper;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BanishRain
extends SpellComponent
implements IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        boolean hasMatch = RitualShapeHelper.instance.matchesRitual(this, world, pos);
        if (hasMatch) {
            RitualShapeHelper.instance.consumeReagents(this, world, pos);
            world.func_72912_H().func_76080_g(0);
            world.func_72912_H().func_76084_b(true);
            return true;
        }
        if (!world.func_72896_J()) {
            return false;
        }
        world.func_72912_H().func_76080_g(24000);
        world.func_72912_H().func_76084_b(false);
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        boolean hasMatch = RitualShapeHelper.instance.matchesRitual(this, world, caster.func_180425_c());
        if (hasMatch) {
            RitualShapeHelper.instance.consumeReagents(this, world, target.func_180425_c());
            world.func_72912_H().func_76080_g(0);
            world.func_72912_H().func_76084_b(true);
            return true;
        }
        if (!world.func_72896_J()) {
            return false;
        }
        world.func_72912_H().func_76080_g(24000);
        world.func_72912_H().func_76084_b(false);
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 750.0f;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        int waterMeta = 0;
        for (Affinity aff : ArsMagicaAPI.getAffinityRegistry().getValues()) {
            if (aff.equals(Affinity.NONE)) continue;
            if (aff.equals(Affinity.WATER)) break;
            ++waterMeta;
        }
        return new ItemStack[]{new ItemStack((Item)ItemDefs.essence, 1, waterMeta)};
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "water_ball", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(5.0, 4.0, 5.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.5f, 1, false));
            particle.func_187114_a(25 + rand.nextInt(10));
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.WATER});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLUE.func_176767_b()), Items.field_151043_k};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.3f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.hourglass;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack(Items.field_151131_as), new ItemStack(Blocks.field_150433_aE)};
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getResult() {
        return null;
    }
}

