/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.blocks.tileentity.TileEntityAstralBarrier;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import am2.extensions.EntityExtension;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleMoveOnHeading;
import am2.utils.DimensionUtilities;
import am2.utils.KeystoneUtilities;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class Blink
extends SpellComponent {
    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (world.field_72995_K) {
            EntityExtension.For((EntityLivingBase)((EntityLivingBase)target)).astralBarrierBlocked = false;
        }
        double distance = this.GetTeleportDistance(stack, caster, target);
        double motionX = (double)(-MathHelper.func_76126_a((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
        double motionZ = (double)(MathHelper.func_76134_b((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
        double motionY = (double)(-MathHelper.func_76126_a((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
        double d = motionX;
        double d1 = motionY;
        double d2 = motionZ;
        float f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        motionX = d *= distance;
        motionY = d1 *= distance;
        motionZ = d2 *= distance;
        ArrayList<Long> keystoneKeys = KeystoneUtilities.instance.GetKeysInInvenory((EntityLivingBase)target);
        double newX = target.field_70165_t + motionX;
        double newZ = target.field_70161_v + motionZ;
        double newY = target.field_70163_u + motionY;
        boolean coordsValid = false;
        boolean astralBarrierBlocked = false;
        TileEntityAstralBarrier finalBlocker = null;
        while (!coordsValid && distance > 0.0) {
            if (caster.func_70644_a(PotionEffectsDefs.astralDistortion)) {
                coordsValid = true;
                newX = caster.field_70165_t;
                newY = caster.field_70163_u;
                newZ = caster.field_70161_v;
            }
            TileEntityAstralBarrier blocker = DimensionUtilities.GetBlockingAstralBarrier(world, new BlockPos(newX, newY, newZ), keystoneKeys);
            while (blocker != null) {
                finalBlocker = blocker;
                astralBarrierBlocked = true;
                int dx = (int)newX - blocker.func_174877_v().func_177958_n();
                int dy = (int)newY - blocker.func_174877_v().func_177956_o();
                int dz = (int)newZ - blocker.func_174877_v().func_177952_p();
                int sqDist = dx * dx + dy * dy + dz * dz;
                int delta = blocker.getRadius() - (int)Math.floor(Math.sqrt(sqDist));
                if ((distance -= (double)delta) < 0.0) break;
                motionX = (double)(-MathHelper.func_76126_a((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
                motionZ = (double)(MathHelper.func_76134_b((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
                motionY = (double)(-MathHelper.func_76126_a((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
                d = motionX;
                d1 = motionY;
                d2 = motionZ;
                f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
                d /= (double)f2;
                d1 /= (double)f2;
                d2 /= (double)f2;
                motionX = d *= distance;
                motionY = d1 *= distance;
                motionZ = d2 *= distance;
                newX = target.field_70165_t + motionX;
                newZ = target.field_70161_v + motionZ;
                newY = target.field_70163_u + motionY;
                blocker = DimensionUtilities.GetBlockingAstralBarrier(world, new BlockPos(newX, newY, newZ), keystoneKeys);
            }
            if (distance < 0.0) {
                coordsValid = false;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY - 1, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY - 1, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY - 1, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY - 1, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY + 1, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY + 1, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY + 1, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY + 1, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            motionX = (double)(-MathHelper.func_76126_a((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * (distance -= 1.0);
            motionZ = (double)(MathHelper.func_76134_b((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
            motionY = (double)(-MathHelper.func_76126_a((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
            d = motionX;
            d1 = motionY;
            d2 = motionZ;
            f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
            d /= (double)f2;
            d1 /= (double)f2;
            d2 /= (double)f2;
            motionX = d *= distance;
            motionY = d1 *= distance;
            motionZ = d2 *= distance;
            newX = target.field_70165_t + motionX;
            newZ = target.field_70161_v + motionZ;
            newY = target.field_70163_u + motionY;
        }
        if (world.field_72995_K && astralBarrierBlocked && coordsValid) {
            EntityExtension.For((EntityLivingBase)((EntityLivingBase)target)).astralBarrierBlocked = true;
            if (finalBlocker != null) {
                finalBlocker.onEntityBlocked((EntityLivingBase)target);
            }
        }
        if (!world.field_72995_K && !coordsValid && target instanceof EntityPlayer) {
            ((EntityPlayer)target).func_145747_a((ITextComponent)new TextComponentString("Can't find a place to blink forward to."));
            return false;
        }
        if (!world.field_72995_K) {
            ((EntityLivingBase)target).func_70634_a(newX, newY, newZ);
        }
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 160.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "sparkle", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 2.0, 1.0);
            particle.AddParticleController(new ParticleMoveOnHeading(particle, MathHelper.func_76142_g((float)((target instanceof EntityLivingBase ? ((EntityLivingBase)target).field_70759_as : target.field_70177_z) + 90.0f)), MathHelper.func_76142_g((float)target.field_70125_A), 0.1 + rand.nextDouble() * 0.5, 1, false));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f));
            particle.func_187114_a(20);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.ENDER});
    }

    private boolean CheckCoords(World world, int x, int y, int z) {
        if (y < 0) {
            return false;
        }
        IBlockState firstBlock = world.func_180495_p(new BlockPos(x, y, z));
        IBlockState secondBlock = world.func_180495_p(new BlockPos(x, y + 1, z));
        AxisAlignedBB firstBlockBB = null;
        AxisAlignedBB secondBlockBB = null;
        if (firstBlock != null) {
            firstBlockBB = firstBlock.func_177230_c().func_180646_a(firstBlock, world, new BlockPos(x, y, z));
        }
        if (secondBlock != null) {
            secondBlockBB = secondBlock.func_177230_c().func_180646_a(secondBlock, world, new BlockPos(x, y + 1, z));
        }
        return firstBlockBB == null && secondBlockBB == null;
    }

    protected double GetTeleportDistance(ItemStack stack, EntityLivingBase caster, Entity target) {
        return SpellUtils.getModifiedInt_Add(12, stack, caster, target, caster.func_130014_f_(), SpellModifiers.RANGE);
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.RANGE);
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.PURPLE.func_176767_b()), Items.field_151079_bi};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }
}

