/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleOrbitEntity;
import am2.particles.ParticleOrbitPoint;
import am2.utils.AffinityShiftUtils;
import am2.utils.DimensionUtilities;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class DivineIntervention
extends SpellComponent {
    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (world.field_72995_K || !(target instanceof EntityLivingBase)) {
            return true;
        }
        if (((EntityLivingBase)target).func_70644_a(PotionEffectsDefs.astralDistortion)) {
            if (target instanceof EntityPlayer) {
                ((EntityPlayer)target).func_145747_a((ITextComponent)new TextComponentString("The distortion around you prevents you from teleporting"));
            }
            return true;
        }
        if (target.field_71093_bK == 1) {
            if (target instanceof EntityPlayer) {
                ((EntityPlayer)target).func_145747_a((ITextComponent)new TextComponentString("Nothing happens..."));
            }
            return true;
        }
        if (target.field_71093_bK == 0) {
            BlockPos coords;
            BlockPos blockPos = coords = target instanceof EntityPlayer ? ((EntityPlayer)target).getBedLocation(target.field_71093_bK) : null;
            if (coords == null || coords == BlockPos.field_177992_a) {
                coords = world.func_175694_M();
            }
            while (world.func_180495_p(coords).func_177230_c() != Blocks.field_150350_a && world.func_180495_p(coords.func_177984_a()).func_177230_c() != Blocks.field_150350_a) {
                coords = coords.func_177984_a();
            }
            ((EntityLivingBase)target).func_70634_a((double)coords.func_177958_n() + 0.5, (double)coords.func_177956_o(), (double)coords.func_177952_p() + 0.5);
        } else {
            DimensionUtilities.doDimensionTransfer((EntityLivingBase)target, 0);
            ArsMagica2.proxy.addDeferredDimensionTransfer((EntityLivingBase)target, 0);
        }
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 400.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return new ItemStack[]{AffinityShiftUtils.getEssenceForAffinity(Affinity.ENDER)};
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 100; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "arcane", x, y - 1.0, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            if (rand.nextBoolean()) {
                particle.AddParticleController(new ParticleOrbitEntity(particle, target, 0.1f, 1, false).SetTargetDistance(rand.nextDouble() + 0.5));
            } else {
                particle.AddParticleController(new ParticleOrbitPoint(particle, x, y, z, 1, false).SetOrbitSpeed(0.1f).SetTargetDistance(rand.nextDouble() + 0.5));
            }
            particle.func_187114_a(25 + rand.nextInt(10));
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.ENDER});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.PURPLE.func_176767_b()), Items.field_151104_aV, Items.field_151079_bi};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.4f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }
}

