/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Drought
extends SpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof BlockFlower || block instanceof BlockTallGrass) {
            world.func_175656_a(pos, Blocks.field_150330_I.func_176223_P());
            return true;
        }
        if (block == Blocks.field_150349_c || block == Blocks.field_150391_bh || block == Blocks.field_150322_A || block == Blocks.field_150346_d) {
            world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
            return true;
        }
        if (block == Blocks.field_150348_b) {
            world.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
            return true;
        }
        if (block == Blocks.field_150417_aV) {
            world.func_175656_a(pos, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED));
            return true;
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            world.func_175698_g(pos);
            return true;
        }
        block = world.func_180495_p(pos = pos.func_177972_a(blockFace)).func_177230_c();
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 60.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "ember", x + 0.5, y + 1.0, z + 0.5));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 0.0, 1.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.1f, 1, false));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f));
            particle.setAffectedByGravity();
            particle.setRGBColorF(0.9f, 0.8f, 0.5f);
            particle.func_187114_a(40);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.FIRE, Affinity.AIR});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.ORANGE.func_176767_b()), Blocks.field_150354_m, Blocks.field_150330_I};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        if (affinity == Affinity.FIRE) {
            return 0.008f;
        }
        return 0.004f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

