/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleHoldPosition;
import am2.utils.EntityUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Forge
extends SpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        if (!this.CanApplyFurnaceToBlockAtCoords(caster, world, pos)) {
            return false;
        }
        this.ApplyFurnaceToBlockAtCoords(caster, world, pos);
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityVillager && ArsMagica2.config.forgeSmeltsVillagers()) {
            if (!world.field_72995_K && !EntityUtils.isSummon((EntityLivingBase)target)) {
                target.func_145779_a(Items.field_151166_bC, 1);
            }
            if (caster instanceof EntityPlayer) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)caster)), 5000.0f);
            } else {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)caster), 5000.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 55.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "radiant", x + 0.5, y + 0.5, z + 0.5));
        if (particle != null) {
            particle.AddParticleController(new ParticleHoldPosition(particle, 20, 1, false));
            particle.func_187114_a(20);
            particle.setParticleScale(0.3f);
            particle.setRGBColorF(0.7f, 0.4f, 0.2f);
            particle.SetParticleAlpha(0.1f);
            if (colorModifier > -1) {
                particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.FIRE});
    }

    private boolean ApplyFurnaceToBlockAtCoords(EntityLivingBase entity, World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block.equals(Blocks.field_150350_a)) {
            return false;
        }
        if (block.equals(Blocks.field_150432_aD)) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            }
            return true;
        }
        int meta = world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(block, 1, meta));
        if (smelted == null) {
            return false;
        }
        if (!world.field_72995_K) {
            if (this.ItemIsBlock(smelted.func_77973_b())) {
                world.func_175656_a(pos, ((ItemBlock)smelted.func_77973_b()).field_150939_a.func_176203_a(smelted.func_77952_i()));
            } else {
                EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)((float)pos.func_177952_p() + 0.5f), smelted.func_77946_l());
                float f3 = 0.05f;
                item.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                item.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                item.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                world.func_72838_d((Entity)item);
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }
        return true;
    }

    private boolean CanApplyFurnaceToBlockAtCoords(EntityLivingBase entity, World world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos);
        if (block.func_177230_c().equals(Blocks.field_150350_a)) {
            return false;
        }
        if (block.func_177230_c().equals(Blocks.field_150432_aD)) {
            return true;
        }
        int meta = block.func_177230_c().func_176201_c(block);
        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(block.func_177230_c(), 1, meta));
        return smelted != null;
    }

    public boolean ItemIsBlock(Item smelted) {
        return smelted instanceof ItemBlock;
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.RED.func_176767_b()), Blocks.field_150460_al};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

