/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Ignition
extends SpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        switch (blockFace) {
            case EAST: 
            case WEST: 
            case SOUTH: 
            case NORTH: {
                pos = pos.func_177972_a(blockFace);
                break;
            }
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (world.func_175623_d(pos) || block.equals(Blocks.field_150433_aE) || block instanceof BlockFlower) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
            return true;
        }
        pos = pos.func_177984_a();
        block = world.func_180495_p(pos).func_177230_c();
        if (world.func_175623_d(pos) || block.equals(Blocks.field_150433_aE) || block instanceof BlockFlower) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.DURATION);
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        int burnTime = SpellUtils.getModifiedInt_Mul(3, stack, caster, target, world, SpellModifiers.DURATION);
        if (target.func_70027_ad()) {
            return false;
        }
        target.func_70015_d(burnTime);
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 35.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 5; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "explosion_2", x + 0.5, y + 0.5, z + 0.5));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 0.5, 1.0);
            particle.addVelocity(rand.nextDouble() * 0.2 - 0.1, 0.3, rand.nextDouble() * 0.2 - 0.1);
            particle.setAffectedByGravity();
            particle.setDontRequireControllers();
            particle.func_187114_a(5);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.FIRE});
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.ORANGE.func_176767_b()), Items.field_151033_d};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }
}

