/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.rituals.IRitualInteraction;
import am2.api.rituals.RitualShapeHelper;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.extensions.EntityExtension;
import am2.particles.AMParticle;
import am2.particles.ParticleApproachEntity;
import am2.utils.AffinityShiftUtils;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LifeTap
extends SpellComponent
implements IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        boolean hasMatch;
        if (world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150474_ac) && (hasMatch = RitualShapeHelper.instance.matchesRitual(this, world, pos))) {
            if (!world.field_72995_K) {
                world.func_175698_g(pos);
                RitualShapeHelper.instance.consumeReagents(this, world, pos);
                RitualShapeHelper.instance.consumeShape(this, world, pos);
                EntityItem item = new EntityItem(world);
                item.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                item.func_92058_a(new ItemStack(BlockDefs.inertSpawner));
                world.func_72838_d((Entity)item);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (!world.field_72995_K) {
            double damage = SpellUtils.getModifiedDouble_Mul(2.0, stack, caster, target, world, SpellModifiers.DAMAGE);
            EntityExtension casterProperties = EntityExtension.For(caster);
            float manaRefunded = (float)(damage * 0.01 * (double)casterProperties.getMaxMana());
            if (caster.func_70097_a(DamageSource.field_76380_i, (float)((int)Math.floor(damage)))) {
                casterProperties.setCurrentMana(casterProperties.getCurrentMana() + manaRefunded);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.DAMAGE);
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 0.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "sparkle2", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(2.0, 2.0, 2.0);
            particle.func_187114_a(15);
            particle.setParticleScale(0.1f);
            particle.AddParticleController(new ParticleApproachEntity(particle, target, 0.1, 0.1, 1, false));
            if (rand.nextBoolean()) {
                particle.setRGBColorF(0.4f, 0.1f, 0.5f);
            } else {
                particle.setRGBColorF(0.1f, 0.5f, 0.1f);
            }
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.LIFE, Affinity.ENDER});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLACK.func_176767_b()), BlockDefs.aum};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.corruption;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack((Item)ItemDefs.mobFocus), AffinityShiftUtils.getEssenceForAffinity(Affinity.ENDER)};
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getResult() {
        return new ItemStack(BlockDefs.inertSpawner);
    }
}

