/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.DamageSources;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.enchantments.AMEnchantments;
import am2.particles.AMParticle;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MagicDamage
extends SpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        float baseDamage = 6.0f;
        double damage = SpellUtils.getModifiedDouble_Add(baseDamage, stack, caster, target, world, SpellModifiers.DAMAGE);
        float mod = 0.0f;
        if (target instanceof EntityPlayer) {
            for (ItemStack item : ((EntityPlayer)target).field_71071_by.field_70460_b) {
                if (item == null || EnchantmentHelper.func_77506_a((Enchantment)AMEnchantments.magicResist, (ItemStack)item) <= 0) continue;
                mod += 0.04f * (float)EnchantmentHelper.func_77506_a((Enchantment)AMEnchantments.magicResist, (ItemStack)item);
            }
        }
        damage -= damage * (double)mod;
        return SpellUtils.attackTargetSpecial(stack, target, DamageSources.causeMagicDamage(caster), SpellUtils.modifyDamage(caster, (float)damage));
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 80.0f;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 5; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "arcane", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 0.5, 1.0);
            particle.addVelocity(rand.nextDouble() * 0.2 - 0.1, rand.nextDouble() * 0.2, rand.nextDouble() * 0.2 - 0.1);
            particle.setAffectedByGravity();
            particle.setDontRequireControllers();
            particle.func_187114_a(5);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.DAMAGE);
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.ARCANE, Affinity.ENDER});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.PURPLE.func_176767_b()), new ItemStack(Items.field_151100_aR, 1, 4), Items.field_151122_aG, Items.field_151052_q};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        if (affinity == Affinity.ENDER) {
            return 0.005f;
        }
        return 0.01f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }
}

