/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.extensions.EntityExtension;
import am2.particles.AMParticle;
import am2.particles.ParticleConverge;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class Mark
extends SpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        EntityExtension.For(caster).setMark(impactX, impactY, impactZ, caster.field_70170_p.field_73011_w.getDimension());
        if (caster instanceof EntityPlayer && world.field_72995_K) {
            ((EntityPlayer)caster).func_145747_a((ITextComponent)new TextComponentString("Mark Set"));
        }
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (EntityExtension.For(caster).getMarkDimensionID() != -512) {
            EntityExtension.For(caster).setMarkDimensionID(-512);
            if (caster instanceof EntityPlayer && world.field_72995_K) {
                ((EntityPlayer)caster).func_145747_a((ITextComponent)new TextComponentString("Mark Cleared"));
            }
        } else {
            EntityExtension.For(caster).setMark(target.field_70165_t, target.field_70163_u, target.field_70161_v, caster.field_70170_p.field_73011_w.getDimension());
            if (caster instanceof EntityPlayer && world.field_72995_K) {
                ((EntityPlayer)caster).func_145747_a((ITextComponent)new TextComponentString("Mark Set"));
            }
        }
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 5.0f;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        boolean offset = true;
        this.SetupParticle(world, caster.field_70165_t - 0.5, caster.field_70163_u + (double)offset, caster.field_70161_v, 0.2, 0.0, colorModifier);
        this.SetupParticle(world, caster.field_70165_t + 0.5, caster.field_70163_u + (double)offset, caster.field_70161_v, -0.2, 0.0, colorModifier);
        this.SetupParticle(world, caster.field_70165_t, caster.field_70163_u + (double)offset, caster.field_70161_v - 0.5, 0.0, 0.2, colorModifier);
        this.SetupParticle(world, caster.field_70165_t, caster.field_70163_u + (double)offset, caster.field_70161_v + 0.5, 0.0, -0.2, colorModifier);
    }

    private void SetupParticle(World world, double x, double y, double z, double motionx, double motionz, int colorModifier) {
        AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "symbols", x, y, z));
        if (effect != null) {
            effect.AddParticleController(new ParticleConverge(effect, motionx, -0.1, motionz, 1, true));
            effect.func_187114_a(40);
            effect.setIgnoreMaxAge(false);
            effect.setParticleScale(0.1f);
            if (colorModifier > -1) {
                effect.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.NONE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.RED.func_176767_b()), new ItemStack((Item)Items.field_151148_bJ)};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

