/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RandomTeleport
extends SpellComponent {
    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        Vec3d rLoc = this.getRandomTeleportLocation(world, stack, caster, target);
        return this.teleportTo(rLoc.field_72450_a, rLoc.field_72448_b, rLoc.field_72449_c, target);
    }

    private Vec3d getRandomTeleportLocation(World world, ItemStack stack, EntityLivingBase caster, Entity target) {
        Vec3d origin = new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        float maxDist = 9.0f;
        maxDist = (float)SpellUtils.getModifiedDouble_Mul(maxDist, stack, caster, target, world, SpellModifiers.RANGE);
        origin = origin.func_178787_e(new Vec3d((world.field_73012_v.nextDouble() - 0.5) * (double)maxDist, (world.field_73012_v.nextDouble() - 0.5) * (double)maxDist, (world.field_73012_v.nextDouble() - 0.5) * (double)maxDist));
        return origin;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.RANGE);
    }

    protected boolean teleportTo(double par1, double par3, double par5, Entity target) {
        if (target instanceof EntityLivingBase) {
            EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)target, par1, par3, par5, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            par1 = event.getTargetX();
            par3 = event.getTargetY();
            par5 = event.getTargetZ();
        }
        double d3 = target.field_70165_t;
        double d4 = target.field_70163_u;
        double d5 = target.field_70161_v;
        target.field_70165_t = par1;
        target.field_70163_u = par3;
        target.field_70161_v = par5;
        boolean locationValid = false;
        BlockPos pos = target.func_180425_c();
        if (target.field_70170_p.func_180495_p(pos) != null) {
            boolean targetBlockIsSolid = false;
            while (!targetBlockIsSolid && pos.func_177956_o() > 0) {
                Block l = target.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c();
                if (l != Blocks.field_150350_a && l.func_176205_b((IBlockAccess)target.field_70170_p, pos)) {
                    targetBlockIsSolid = true;
                    continue;
                }
                target.field_70163_u -= 1.0;
                pos = pos.func_177977_b();
            }
            if (targetBlockIsSolid) {
                target.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                if (target.field_70170_p.func_184144_a(target, target.func_174813_aQ()).isEmpty()) {
                    locationValid = true;
                }
            }
        }
        if (!locationValid) {
            target.func_70107_b(d3, d4, d5);
            return false;
        }
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 52.5f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        world.func_175688_a(EnumParticleTypes.PORTAL, target.field_70165_t + (rand.nextDouble() - 0.5) * (double)target.field_70130_N, target.field_70163_u + rand.nextDouble() * (double)target.field_70131_O - 0.25, target.field_70161_v + (rand.nextDouble() - 0.5) * (double)target.field_70130_N, (rand.nextDouble() - 0.5) * 2.0, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 2.0, new int[0]);
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.ENDER});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLACK.func_176767_b()), Items.field_151079_bi};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }
}

