/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.math.AMVector3;
import am2.api.rituals.IRitualInteraction;
import am2.api.rituals.RitualShapeHelper;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import am2.extensions.EntityExtension;
import am2.particles.AMParticle;
import am2.particles.ParticleExpandingCollapsingRingAtPoint;
import am2.utils.DimensionUtilities;
import am2.utils.KeystoneUtilities;
import am2.utils.SelectionUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Recall
extends SpellComponent
implements IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        ItemStack[] ritualRunes;
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (caster.func_70644_a(PotionEffectsDefs.astralDistortion) || ((EntityLivingBase)target).func_70644_a(PotionEffectsDefs.astralDistortion)) {
            if (caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.cantTeleport")));
            }
            return false;
        }
        if (RitualShapeHelper.instance.matchesRitual(this, world, target.func_180425_c()) && (ritualRunes = RitualShapeHelper.instance.checkForRitual(this, world, target.func_180425_c())) != null) {
            return this.handleRitualReagents(ritualRunes, world, target.func_180425_c(), caster, target);
        }
        EntityExtension casterProperties = EntityExtension.For(caster);
        if (casterProperties.getMarkDimensionID() == -512) {
            if (caster instanceof EntityPlayer && !world.field_72995_K) {
                ((EntityPlayer)caster).func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.noMark")));
            }
            return false;
        }
        if (casterProperties.getMarkDimensionID() != caster.field_71093_bK) {
            if (caster instanceof EntityPlayer && !world.field_72995_K) {
                ((EntityPlayer)caster).func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.diffDimMark")));
            }
            return false;
        }
        if (!world.field_72995_K) {
            ((EntityLivingBase)target).func_70634_a(casterProperties.getMarkX(), casterProperties.getMarkY(), casterProperties.getMarkZ());
        }
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    private boolean handleRitualReagents(ItemStack[] ritualRunes, World world, BlockPos pos, EntityLivingBase caster, Entity target) {
        boolean hasVinteumDust = false;
        for (ItemStack stack : ritualRunes) {
            if (stack.func_77973_b() != ItemDefs.itemOre || stack.func_77952_i() != 0) continue;
            hasVinteumDust = true;
            break;
        }
        if (!hasVinteumDust && ritualRunes.length == 3) {
            long key = KeystoneUtilities.instance.getKeyFromRunes(ritualRunes);
            AMVector3 vector = ArsMagica2.proxy.blocks.getNextKeystonePortalLocation(world, pos, false, key);
            if (vector == null || vector.equals(new AMVector3(pos))) {
                if (caster instanceof EntityPlayer && !world.field_72995_K) {
                    ((EntityPlayer)caster).func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.noMatchingGate")));
                }
                return false;
            }
            RitualShapeHelper.instance.consumeAllReagents(this, world, pos);
            RitualShapeHelper.instance.consumeShape(this, world, pos);
            ((EntityLivingBase)target).func_70634_a((double)vector.x, (double)(vector.y - target.field_70131_O), (double)vector.z);
            return true;
        }
        if (hasVinteumDust) {
            ArrayList<Integer> copy = new ArrayList<Integer>();
            for (ItemStack stack : ritualRunes) {
                if (stack.func_77973_b() != ItemDefs.rune || stack.func_77952_i() > 16) continue;
                copy.add(stack.func_77952_i());
            }
            int[] newRunes = new int[copy.size()];
            for (int i = 0; i < copy.size(); ++i) {
                newRunes[i] = (Integer)copy.get(i);
            }
            EntityPlayer player = SelectionUtils.getPlayersForRuneSet(newRunes);
            if (player == null) {
                if (caster instanceof EntityPlayer && !world.field_72995_K) {
                    ((EntityPlayer)caster).func_145747_a((ITextComponent)new TextComponentString("am2.tooltip.noMatchingPlayer"));
                }
                return false;
            }
            if (player == caster) {
                if (caster instanceof EntityPlayer && !world.field_72995_K) {
                    ((EntityPlayer)caster).func_145747_a((ITextComponent)new TextComponentString("am2.tooltip.cantSummonSelf"));
                }
                return false;
            }
            RitualShapeHelper.instance.consumeAllReagents(this, world, pos);
            if (target.field_70170_p.field_73011_w.getDimension() != caster.field_70170_p.field_73011_w.getDimension()) {
                DimensionUtilities.doDimensionTransfer((EntityLivingBase)player, caster.field_70170_p.field_73011_w.getDimension());
            }
            ((EntityLivingBase)target).func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p());
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 500.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "arcane", x, y - 1.0, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 0.0, 1.0);
            particle.AddParticleController(new ParticleExpandingCollapsingRingAtPoint(particle, x, y - 1.0, z, 0.1, 3.0, 0.3, 1, false).setCollapseOnce());
            particle.func_187114_a(20);
            particle.setParticleScale(0.2f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.ARCANE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.ORANGE.func_176767_b()), Items.field_151111_aL, new ItemStack((Item)Items.field_151148_bJ), Items.field_151079_bi};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.1f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.ringedCross;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack((Item)ItemDefs.rune, 1, Short.MAX_VALUE), new ItemStack((Item)ItemDefs.rune, 1, Short.MAX_VALUE), new ItemStack((Item)ItemDefs.rune, 1, Short.MAX_VALUE)};
    }

    @Override
    public int getReagentSearchRadius() {
        return RitualShapeHelper.instance.ringedCross.getWidth();
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getResult() {
        return new ItemStack(BlockDefs.keystoneRecepticle);
    }
}

