/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleOrbitEntity;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Storm
extends SpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        this.applyEffect(caster, world);
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        this.applyEffect(caster, world);
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    private void applyEffect(EntityLivingBase caster, World world) {
        float rainStrength = world.func_72867_j(1.0f);
        if ((double)rainStrength > 0.9) {
            if (!world.field_72995_K) {
                int xzradius = 50;
                int random = world.field_73012_v.nextInt(100);
                if (random < 20) {
                    int randPosX = (int)caster.field_70165_t + world.field_73012_v.nextInt(xzradius * 2) - xzradius;
                    int randPosZ = (int)caster.field_70161_v + world.field_73012_v.nextInt(xzradius * 2) - xzradius;
                    int posY = (int)caster.field_70163_u;
                    while (!world.func_175710_j(new BlockPos(randPosX, posY, randPosZ))) {
                        ++posY;
                    }
                    while (world.func_180495_p(new BlockPos(randPosX, posY - 1, randPosZ)).func_177230_c().equals(Blocks.field_150350_a)) {
                        --posY;
                    }
                    EntityLightningBolt bolt = new EntityLightningBolt(world, (double)randPosX, (double)posY, (double)randPosZ, false);
                    world.func_72942_c((Entity)bolt);
                } else if (random < 80) {
                    List entities = world.func_175647_a(Entity.class, caster.func_174813_aQ().func_72314_b((double)xzradius, 10.0, (double)xzradius), IMob.field_82192_a);
                    if (entities.size() <= 0) {
                        return;
                    }
                    Entity target = (Entity)entities.get(world.field_73012_v.nextInt(entities.size()));
                    if (target != null && world.func_175710_j(target.func_180425_c())) {
                        if (caster instanceof EntityPlayer) {
                            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)caster)), 1.0f);
                        }
                        EntityLightningBolt bolt = new EntityLightningBolt(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, false);
                        world.func_72942_c((Entity)bolt);
                    }
                }
            }
        } else if (!world.field_72995_K) {
            world.func_72912_H().func_76084_b(true);
        }
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 15.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "symbols", x, y - 1.0, z));
        if (particle != null) {
            particle.AddParticleController(new ParticleOrbitEntity(particle, target, 0.2f, 2, false).SetTargetDistance(1.0));
            particle.func_187114_a(40);
            particle.setParticleScale(0.1f);
            if (colorModifier > -1) {
                particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.LIGHTNING, Affinity.NATURE});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.YELLOW.func_176767_b()), new ItemStack((Item)ItemDefs.itemOre, 1, 5), Items.field_151073_bk};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 1.0E-5f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

