/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.api.affinity.Affinity;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.extensions.EntityExtension;
import am2.items.ItemCrystalPhylactery;
import am2.power.PowerTypes;
import am2.utils.EntityUtils;
import am2.utils.SpellUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class Summon
extends SpellComponent {
    public EntityLiving summonCreature(ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z) {
        Class<? extends Entity> clazz = this.getSummonType(stack);
        EntityLiving entity = null;
        try {
            entity = (EntityLiving)clazz.getConstructor(World.class).newInstance(world);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntitySkeleton) {
            ((EntitySkeleton)entity).func_189768_a(SkeletonType.NORMAL);
            ((EntitySkeleton)entity).func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)Items.field_151031_f));
        } else if (entity instanceof EntityHorse && caster instanceof EntityPlayer) {
            ((EntityHorse)entity).func_110263_g((EntityPlayer)caster);
        }
        entity.func_70107_b(x, y, z);
        world.func_72838_d((Entity)entity);
        if (caster instanceof EntityPlayer) {
            EntityUtils.makeSummon_PlayerFaction((EntityCreature)entity, (EntityPlayer)caster, false);
        } else {
            EntityUtils.makeSummon_MonsterFaction((EntityCreature)entity, false);
        }
        EntityUtils.setOwner((EntityLivingBase)entity, caster);
        int duration = SpellUtils.getModifiedInt_Mul(4800, stack, caster, (Entity)target, world, SpellModifiers.DURATION);
        EntityUtils.setSummonDuration((EntityLivingBase)entity, duration);
        SpellUtils.applyStageToEntity(stack, caster, world, (Entity)entity, false);
        return entity;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.DURATION);
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.itemOre, 1, 2), new ItemStack((Item)ItemDefs.itemOre, 1, 1), BlockDefs.cerublossom, ItemDefs.mobFocus, new ItemStack((Item)ItemDefs.crystalPhylactery, 1, 3), "E:" + PowerTypes.DARK.ID(), 1500};
    }

    public void setSummonType(NBTTagCompound stack, ItemStack phylacteryStack) {
        if (phylacteryStack.func_77952_i() == 3 && phylacteryStack.func_77973_b() instanceof ItemCrystalPhylactery) {
            this.setSummonType(stack, ItemDefs.crystalPhylactery.getSpawnClass(phylacteryStack));
        }
    }

    public Class<? extends Entity> getSummonType(ItemStack stack) {
        String s = SpellUtils.getSpellMetadata(stack, "SummonType");
        if (s == null || s == "") {
            s = "Skeleton";
        }
        Class clazz = (Class)EntityList.field_75625_b.get(s);
        return clazz;
    }

    public void setSummonType(NBTTagCompound stack, String s) {
        Class clazz = (Class)EntityList.field_75625_b.get(s);
        this.setSummonType(stack, clazz);
    }

    public void setSummonType(NBTTagCompound stack, Class<? extends Entity> clazz) {
        String s = (String)EntityList.field_75626_c.get(clazz = this.checkForSpecialSpawns(stack, clazz));
        if (s == null) {
            s = "";
        }
        SpellUtils.setSpellMetadata(stack, "SpawnClassName", s);
        SpellUtils.setSpellMetadata(stack, "SummonType", s);
    }

    private Class<? extends Entity> checkForSpecialSpawns(NBTTagCompound tag, Class<? extends Entity> clazz) {
        return clazz;
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        if (!world.field_72995_K) {
            if (EntityExtension.For(caster).getCanHaveMoreSummons()) {
                if (this.summonCreature(stack, caster, caster, world, impactX, impactY, impactZ) == null) {
                    return false;
                }
            } else if (caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.noMoreSummons")));
            }
        }
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase && EntityUtils.isSummon((EntityLivingBase)target)) {
            return false;
        }
        if (!world.field_72995_K) {
            if (EntityExtension.For(caster).getCanHaveMoreSummons()) {
                if (this.summonCreature(stack, caster, caster, world, target.field_70165_t, target.field_70163_u, target.field_70161_v) == null) {
                    return false;
                }
            } else if (caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.noMoreSummons")));
            }
        }
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 400.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.ENDER, Affinity.LIFE});
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
        for (Object obj : recipe) {
            ItemStack is;
            if (!(obj instanceof ItemStack) || !(is = (ItemStack)obj).func_77973_b().equals((Object)ItemDefs.crystalPhylactery)) continue;
            this.setSummonType(tag, is);
        }
    }
}

