/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.component;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.rituals.IRitualInteraction;
import am2.api.rituals.RitualShapeHelper;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifiers;
import am2.blocks.tileentity.TileEntityOtherworldAura;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleArcToPoint;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Transplace
extends SpellComponent
implements IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, BlockPos blockPos, EnumFacing blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (!world.field_72995_K && caster instanceof EntityPlayer && block == BlockDefs.inertSpawner && RitualShapeHelper.instance.matchesRitual(this, world, blockPos)) {
            RitualShapeHelper.instance.consumeReagents(this, world, blockPos);
            RitualShapeHelper.instance.consumeShape(this, world, blockPos);
            world.func_175656_a(blockPos, BlockDefs.otherworldAura.func_176223_P());
            TileEntity te = world.func_175625_s(blockPos);
            if (te != null && te instanceof TileEntityOtherworldAura) {
                ((TileEntityOtherworldAura)te).setPlacedByUsername(((EntityPlayer)caster).func_70005_c_());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!world.field_72995_K && target != null && !target.field_70128_L) {
            double tPosX = target.field_70165_t;
            double tPosY = target.field_70163_u;
            double tPosZ = target.field_70161_v;
            double cPosX = caster.field_70165_t;
            double cPosY = caster.field_70163_u;
            double cPosZ = caster.field_70161_v;
            caster.func_70634_a(tPosX, tPosY, tPosZ);
            if (target instanceof EntityLiving) {
                ((EntityLiving)target).func_70634_a(cPosX, cPosY, cPosZ);
            } else {
                target.func_70107_b(cPosX, cPosY, cPosZ);
            }
        }
        if (target instanceof EntityLiving) {
            ((EntityLiving)target).func_70625_a((Entity)caster, 180.0f, 180.0f);
        }
        return true;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 100.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle particle;
        int i;
        for (i = 0; i < 15; ++i) {
            particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "sparkle2", caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e(), caster.field_70161_v));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.AddParticleController(new ParticleArcToPoint(particle, 1, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v, false).SetSpeed(0.05f).generateControlPoints());
            particle.func_187114_a(40);
            particle.setParticleScale(0.2f);
            particle.setRGBColorF(1.0f, 0.0f, 0.0f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
        for (i = 0; i < 15; ++i) {
            particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, "sparkle2", target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.AddParticleController(new ParticleArcToPoint(particle, 1, caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e(), caster.field_70161_v, false).SetSpeed(0.05f).generateControlPoints());
            particle.func_187114_a(40);
            particle.setParticleScale(0.2f);
            particle.setRGBColorF(0.0f, 0.0f, 1.0f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(255 - (colorModifier >> 16 & 0xFF)) / 255.0f, (float)(255 - (colorModifier >> 8 & 0xFF)) / 255.0f, (float)(255 - (colorModifier & 0xFF)) / 255.0f);
        }
    }

    @Override
    public Set<Affinity> getAffinity() {
        return Sets.newHashSet((Object[])new Affinity[]{Affinity.ENDER});
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.RED.func_176767_b()), Items.field_151111_aL, new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLUE.func_176767_b()), Items.field_151079_bi};
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.02f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.ringedCross;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack((Item)ItemDefs.itemOre, 1, 1), new ItemStack(ItemDefs.mageArmor), new ItemStack(ItemDefs.mageBoots), new ItemStack(ItemDefs.mageHood), new ItemStack(ItemDefs.mageLeggings), new ItemStack((Item)ItemDefs.playerFocus)};
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getResult() {
        return new ItemStack(BlockDefs.otherworldAura);
    }
}

