/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.modifier;

import am2.api.affinity.Affinity;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.utils.AffinityShiftUtils;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Solar
extends SpellModifier {
    @Override
    public EnumSet<SpellModifiers> getAspectsModified() {
        return EnumSet.of(SpellModifiers.RANGE, SpellModifiers.RADIUS, SpellModifiers.DAMAGE, SpellModifiers.DURATION, SpellModifiers.HEALING);
    }

    @Override
    public float getModifier(SpellModifiers type, EntityLivingBase caster, Entity target, World world, NBTTagCompound metadata) {
        switch (type) {
            case RANGE: {
                return this.modifyValueOnInverseLunarCycle(world, 3.0f);
            }
            case RADIUS: {
                return this.modifyValueOnInverseLunarCycle(world, 3.0f);
            }
            case DAMAGE: {
                return this.modifyValueOnTime(world, 2.4f);
            }
            case DURATION: {
                return this.modifyValueOnTime(world, 5.0f);
            }
            case HEALING: {
                return this.modifyValueOnTime(world, 2.0f);
            }
        }
        return 1.0f;
    }

    private float modifyValueOnTime(World world, float value) {
        long x = world.field_73011_w.getWorldTime() % 24000L;
        float multiplierFromTime = (float)(Math.cos((double)((float)x / 3800.0f * ((float)x / 24000.0f) - 13000.0f) * 57.29577951308232) * 1.5) + 1.0f;
        if (multiplierFromTime < 0.0f) {
            multiplierFromTime *= -0.5f;
        }
        return value * multiplierFromTime;
    }

    private float modifyValueOnInverseLunarCycle(World world, float value) {
        long boundedTime = world.field_73011_w.getWorldTime() % 24000L;
        int phase = 8 - (8 - world.field_73011_w.func_76559_b(world.func_72912_H().func_76073_f()));
        if (boundedTime > 23500L && boundedTime < 12500L) {
            return value + (float)(phase / 2);
        }
        return Math.abs(value - 1.0f);
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{AffinityShiftUtils.getEssenceForAffinity(Affinity.NATURE), new ItemStack((Item)ItemDefs.itemOre, 1, 4), Items.field_151113_aN};
    }

    @Override
    public float getManaCostMultiplier(ItemStack spellStack, int stage, int quantity) {
        return 4.0f * (float)quantity;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

