/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shape;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.items.ItemSpellBase;
import am2.particles.AMBeam;
import am2.particles.AMParticle;
import am2.particles.AMParticleDefs;
import am2.particles.ParticleMoveOnHeading;
import am2.power.PowerTypes;
import am2.spell.SpellCastResult;
import am2.spell.modifier.Colour;
import am2.utils.AffinityShiftUtils;
import am2.utils.MathUtilities;
import am2.utils.SpellUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Beam
extends SpellShape {
    private final HashMap<Integer, AMBeam> beams = new HashMap();

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, EnumFacing side, boolean giveXP, int useCount) {
        boolean shouldApplyEffectBlock = useCount % 5 == 0;
        boolean shouldApplyEffectEntity = useCount % 10 == 0;
        double range = SpellUtils.getModifiedDouble_Add(stack, caster, (Entity)target, world, SpellModifiers.RANGE);
        boolean targetWater = SpellUtils.modifierIsPresent(SpellModifiers.TARGET_NONSOLID_BLOCKS, stack);
        RayTraceResult mop = item.getMovingObjectPosition(caster, world, range, true, targetWater);
        SpellCastResult result = null;
        Vec3d beamHitVec = null;
        Vec3d spellVec = null;
        if (mop == null) {
            spellVec = beamHitVec = MathUtilities.extrapolateEntityLook(world, caster, range);
        } else if (mop.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (shouldApplyEffectEntity && !world.field_72995_K) {
                Entity e = mop.field_72308_g;
                if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                    e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
                }
                if ((result = SpellUtils.applyStageToEntity(stack, caster, world, e, giveXP)) != SpellCastResult.SUCCESS) {
                    return result;
                }
            }
            float rng = (float)mop.field_72307_f.func_72438_d(new Vec3d(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v));
            spellVec = beamHitVec = MathUtilities.extrapolateEntityLook(world, caster, rng);
        } else {
            if (shouldApplyEffectBlock && !world.field_72995_K && (result = SpellUtils.applyStageToGround(stack, caster, world, mop.func_178782_a(), mop.field_178784_b, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, giveXP)) != SpellCastResult.SUCCESS) {
                return result;
            }
            beamHitVec = mop.field_72307_f;
            spellVec = new Vec3d((Vec3i)mop.func_178782_a());
        }
        if (world.field_72995_K && beamHitVec != null) {
            AMBeam beam = this.beams.get(caster.func_145782_y());
            double startX = caster.field_70165_t;
            double startY = caster.field_70163_u + (double)caster.func_70047_e() - (double)0.2f;
            double startZ = caster.field_70161_v;
            Affinity affinity = AffinityShiftUtils.getMainShiftForStack(stack);
            int color = -1;
            if (SpellUtils.modifierIsPresent(SpellModifiers.COLOR, stack)) {
                ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(stack, -1);
                for (SpellModifier mod : mods) {
                    if (!(mod instanceof Colour)) continue;
                    color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, stack.func_77978_p());
                }
            }
            if (beam != null) {
                if (!beam.func_187113_k() || caster.func_70092_e(beam.getPosX(), beam.getPosY(), beam.getPosZ()) > 4.0) {
                    this.beams.remove(caster.func_145782_y());
                } else {
                    beam.setBeamLocationAndTarget(startX, startY, startZ, beamHitVec.field_72450_a, beamHitVec.field_72448_b, beamHitVec.field_72449_c);
                }
            } else if (affinity.equals(Affinity.LIGHTNING)) {
                ArsMagica2.proxy.particleManager.BoltFromEntityToPoint(world, (Entity)caster, beamHitVec.field_72450_a, beamHitVec.field_72448_b, beamHitVec.field_72449_c, 1, color == -1 ? affinity.getColor() : color);
            } else {
                beam = (AMBeam)ArsMagica2.proxy.particleManager.BeamFromEntityToPoint(world, (Entity)caster, beamHitVec.field_72450_a, beamHitVec.field_72448_b, beamHitVec.field_72449_c, color == -1 ? affinity.getColor() : color);
                if (beam != null) {
                    if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                        beam.setFirstPersonPlayerCast();
                    }
                    this.beams.put(caster.func_145782_y(), beam);
                }
            }
            for (int i = 0; i < ArsMagica2.config.getGFXLevel() + 1; ++i) {
                AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, AMParticleDefs.getParticleForAffinity(affinity), beamHitVec.field_72450_a, beamHitVec.field_72448_b, beamHitVec.field_72449_c));
                if (particle == null) continue;
                particle.func_187114_a(2);
                particle.setParticleScale(0.1f);
                particle.setIgnoreMaxAge(false);
                if (color != -1) {
                    particle.setRGBColorI(color);
                }
                particle.AddParticleController(new ParticleMoveOnHeading(particle, world.field_73012_v.nextDouble() * 360.0, world.field_73012_v.nextDouble() * 360.0, world.field_73012_v.nextDouble() * 0.2 + (double)0.02f, 1, false));
            }
        }
        if (result != null && spellVec != null && (mop.field_72313_a == RayTraceResult.Type.ENTITY ? shouldApplyEffectEntity : shouldApplyEffectBlock)) {
            return SpellUtils.applyStackStage(stack, caster, target, spellVec.field_72450_a, spellVec.field_72448_b, spellVec.field_72449_c, mop != null ? mop.field_178784_b : null, world, true, giveXP, 0);
        }
        return SpellCastResult.SUCCESS_REDUCE_MANA;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.RANGE, SpellModifiers.TARGET_NONSOLID_BLOCKS);
    }

    @Override
    public boolean isChanneled() {
        return true;
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{ItemDefs.standardFocus, new ItemStack((Item)ItemDefs.itemOre, 1, 5), new ItemStack((Item)ItemDefs.itemOre, 1, 5), new ItemStack((Item)ItemDefs.itemOre, 1, 1), BlockDefs.aum, "E:" + PowerTypes.NEUTRAL.ID(), 500};
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 0.1f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return false;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

