/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shape;

import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.defs.ItemDefs;
import am2.items.ItemSpellBase;
import am2.spell.SpellCastResult;
import am2.utils.InventoryUtilities;
import am2.utils.SpellUtils;
import java.util.EnumSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class Binding
extends SpellShape {
    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, EnumFacing side, boolean giveXP, int useCount) {
        if (!(caster instanceof EntityPlayer)) {
            return SpellCastResult.EFFECT_FAILED;
        }
        EntityPlayer player = (EntityPlayer)caster;
        ItemStack heldStack = player.func_184607_cu();
        if (heldStack == null || heldStack.func_77973_b() != ItemDefs.spell) {
            return SpellCastResult.EFFECT_FAILED;
        }
        int bindingType = this.getBindingType(SpellUtils.merge(heldStack.func_77946_l()));
        switch (bindingType) {
            case 1: {
                heldStack = InventoryUtilities.replaceItem(heldStack, (Item)ItemDefs.BoundAxe);
                break;
            }
            case 0: {
                heldStack = InventoryUtilities.replaceItem(heldStack, (Item)ItemDefs.BoundPickaxe);
                break;
            }
            case 2: {
                heldStack = InventoryUtilities.replaceItem(heldStack, (Item)ItemDefs.BoundSword);
                break;
            }
            case 3: {
                heldStack = InventoryUtilities.replaceItem(heldStack, (Item)ItemDefs.BoundShovel);
                break;
            }
            case 4: {
                heldStack = InventoryUtilities.replaceItem(heldStack, (Item)ItemDefs.BoundHoe);
                break;
            }
            case 5: {
                heldStack = InventoryUtilities.replaceItem(heldStack, (Item)ItemDefs.BoundBow);
                break;
            }
            case 6: {
                heldStack = InventoryUtilities.replaceItem(heldStack, (Item)ItemDefs.BoundShield);
            }
        }
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, heldStack);
        return SpellCastResult.SUCCESS;
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.itemOre, 1, 2), Items.field_151041_m, Items.field_151051_r, Items.field_151019_K, Items.field_151006_E, Items.field_151046_w, new ItemStack((Item)ItemDefs.bindingCatalyst, 1, Short.MAX_VALUE)};
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 1.0f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return true;
    }

    public int getBindingType(ItemStack spellStack) {
        int type = 0;
        try {
            type = Integer.parseInt(SpellUtils.getSpellMetadata(spellStack, "binding_type"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return type;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
        for (Object obj : recipe) {
            ItemStack is;
            if (!(obj instanceof ItemStack) || !(is = (ItemStack)obj).func_77973_b().equals((Object)ItemDefs.bindingCatalyst)) continue;
            tag.func_74778_a("binding_type", "" + is.func_77952_i());
        }
    }
}

