/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shape;

import am2.ArsMagica2;
import am2.api.affinity.Affinity;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.defs.ItemDefs;
import am2.items.ItemSpellBase;
import am2.spell.SpellCastResult;
import am2.spell.modifier.Colour;
import am2.utils.AffinityShiftUtils;
import am2.utils.SpellUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Chain
extends SpellShape {
    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, EnumFacing side, boolean giveXP, int useCount) {
        RayTraceResult mop = item.getMovingObjectPosition(caster, world, 8.0, true, false);
        double range = SpellUtils.getModifiedDouble_Mul(8.0, stack, caster, (Entity)target, world, SpellModifiers.RANGE);
        int num_targets = SpellUtils.getModifiedInt_Add(3, stack, caster, (Entity)target, world, SpellModifiers.PROCS);
        ArrayList<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
        if (target != null) {
            mop = new RayTraceResult((Entity)target);
        }
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.ENTITY && mop.field_72308_g != null) {
            Entity e = mop.field_72308_g;
            if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
            }
            if (e instanceof EntityLivingBase) {
                EntityLivingBase closest;
                do {
                    targets.add((EntityLivingBase)e);
                    List nearby = world.func_72872_a(EntityLivingBase.class, e.func_174813_aQ().func_72314_b(range, range, range));
                    closest = null;
                    for (EntityLivingBase near : nearby) {
                        if (targets.contains(near) || near == caster || closest != null && !(closest.func_70068_e(e) > near.func_70068_e(e))) continue;
                        closest = near;
                    }
                } while ((e = closest) != null && targets.size() < num_targets);
            }
        }
        boolean atLeastOneApplication = false;
        SpellCastResult result = SpellCastResult.SUCCESS;
        EntityLivingBase prevEntity = null;
        for (EntityLivingBase e : targets) {
            if (e == caster) continue;
            result = SpellUtils.applyStageToEntity(stack, caster, world, (Entity)e, giveXP);
            SpellUtils.applyStackStage(stack, caster, e, e.field_70165_t, e.field_70163_u, e.field_70161_v, null, world, true, giveXP, 0);
            if (world.field_72995_K) {
                if (prevEntity == null) {
                    this.spawnChainParticles(world, x, y, z, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v, stack);
                } else {
                    this.spawnChainParticles(world, prevEntity.field_70165_t, prevEntity.field_70163_u + (double)e.func_70047_e(), prevEntity.field_70161_v, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v, stack);
                }
            }
            prevEntity = e;
            if (result != SpellCastResult.SUCCESS) continue;
            atLeastOneApplication = true;
        }
        if (atLeastOneApplication) {
            return SpellCastResult.SUCCESS;
        }
        return result;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.RANGE, SpellModifiers.PROCS);
    }

    private void spawnChainParticles(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, ItemStack spellStack) {
        int color = this.getPFXColor(spellStack);
        Affinity aff = AffinityShiftUtils.getMainShiftForStack(spellStack);
        if (aff.equals(Affinity.LIGHTNING)) {
            ArsMagica2.proxy.particleManager.BoltFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, 1, color);
        } else {
            if (color == -1) {
                color = aff.getColor();
            }
            ArsMagica2.proxy.particleManager.BeamFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, color);
        }
    }

    private int getPFXColor(ItemStack stack) {
        int color = -1;
        if (SpellUtils.modifierIsPresent(SpellModifiers.COLOR, stack)) {
            ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(stack, -1);
            for (SpellModifier mod : mods) {
                if (!(mod instanceof Colour)) continue;
                color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, stack.func_77978_p());
            }
        }
        return color;
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.itemOre, 1, 4), Items.field_151058_ca, Items.field_151042_j, Blocks.field_150479_bC, Items.field_151007_F};
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 1.5f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return false;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

