/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shape;

import am2.api.affinity.Affinity;
import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.items.ItemSpellBase;
import am2.spell.SpellCastResult;
import am2.spell.component.Attract;
import am2.spell.component.Repel;
import am2.spell.component.Telekinesis;
import am2.utils.AffinityShiftUtils;
import am2.utils.SpellUtils;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class Channel
extends SpellShape {
    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, EnumFacing side, boolean giveXP, int useCount) {
        SpellCastResult result;
        boolean shouldApplyEffect;
        boolean bl = shouldApplyEffect = useCount % 10 == 0 || SpellUtils.componentIsPresent(stack, Telekinesis.class) || SpellUtils.componentIsPresent(stack, Attract.class) || SpellUtils.componentIsPresent(stack, Repel.class);
        if (shouldApplyEffect && (result = SpellUtils.applyStageToEntity(stack, caster, world, (Entity)caster, giveXP)) != SpellCastResult.SUCCESS) {
            return result;
        }
        return SpellCastResult.SUCCESS;
    }

    @Override
    public boolean isChanneled() {
        return true;
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.itemOre, 1, 6), AffinityShiftUtils.getEssenceForAffinity(Affinity.ARCANE), BlockDefs.tarmaRoot, "E:*", 500};
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 1.0f;
    }

    @Override
    public boolean isTerminusShape() {
        return true;
    }

    @Override
    public boolean isPrincipumShape() {
        return false;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.noneOf(SpellModifiers.class);
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

