/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shape;

import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.defs.ItemDefs;
import am2.entity.EntitySpellProjectile;
import am2.items.ItemSpellBase;
import am2.particles.AMParticleDefs;
import am2.spell.SpellCastResult;
import am2.utils.AffinityShiftUtils;
import am2.utils.SpellUtils;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class Projectile
extends SpellShape {
    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.itemOre, 1, 0), Items.field_151032_g, Items.field_151126_ay};
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 1.25f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return false;
    }

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, EnumFacing side, boolean giveXP, int useCount) {
        if (!world.field_72995_K) {
            double projectileSpeed = SpellUtils.getModifiedDouble_Add(stack, caster, (Entity)target, world, SpellModifiers.SPEED);
            float projectileGravity = (float)SpellUtils.getModifiedDouble_Mul(stack, caster, (Entity)target, world, SpellModifiers.GRAVITY);
            int projectileBounce = SpellUtils.getModifiedInt_Add(stack, caster, target, world, SpellModifiers.BOUNCE);
            EntitySpellProjectile projectile = new EntitySpellProjectile(world);
            projectile.func_70107_b(caster.field_70165_t, (double)caster.func_70047_e() + caster.field_70163_u, caster.field_70161_v);
            projectile.field_70159_w = caster.func_70040_Z().field_72450_a * projectileSpeed;
            projectile.field_70181_x = caster.func_70040_Z().field_72448_b * projectileSpeed;
            projectile.field_70179_y = caster.func_70040_Z().field_72449_c * projectileSpeed;
            if (SpellUtils.modifierIsPresent(SpellModifiers.TARGET_NONSOLID_BLOCKS, stack)) {
                projectile.setTargetWater();
            }
            projectile.setGravity(projectileGravity);
            projectile.setBounces(projectileBounce);
            projectile.setNumPierces(SpellUtils.countModifiers(SpellModifiers.PIERCING, stack) * 2 * 2);
            projectile.setShooter(caster);
            projectile.setHoming(SpellUtils.modifierIsPresent(SpellModifiers.HOMING, stack));
            projectile.setSpell(stack);
            projectile.setIcon(AMParticleDefs.getParticleForAffinity(AffinityShiftUtils.getMainShiftForStack(stack)));
            world.func_72838_d((Entity)projectile);
        }
        return SpellCastResult.SUCCESS;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.GRAVITY, new SpellModifiers[]{SpellModifiers.DURATION, SpellModifiers.COLOR, SpellModifiers.HOMING, SpellModifiers.TARGET_NONSOLID_BLOCKS, SpellModifiers.SPEED, SpellModifiers.BOUNCE, SpellModifiers.PIERCING});
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

