/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shape;

import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.defs.ItemDefs;
import am2.items.ItemSpellBase;
import am2.spell.SpellCastResult;
import am2.utils.SpellUtils;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Touch
extends SpellShape {
    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, EnumFacing side, boolean giveXP, int useCount) {
        if (target != null) {
            EntityLivingBase e = target;
            if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
            }
            SpellCastResult result = SpellUtils.applyStageToEntity(stack, caster, world, (Entity)e, giveXP);
            return result;
        }
        boolean targetWater = SpellUtils.modifierIsPresent(SpellModifiers.TARGET_NONSOLID_BLOCKS, stack);
        RayTraceResult mop = item.getMovingObjectPosition(caster, world, 2.5, true, targetWater);
        if (mop == null) {
            return SpellCastResult.EFFECT_FAILED;
        }
        if (mop.field_72313_a == RayTraceResult.Type.ENTITY) {
            SpellCastResult result;
            Entity e = mop.field_72308_g;
            if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
            }
            if ((result = SpellUtils.applyStageToEntity(stack, caster, world, (Entity)(target == null ? e : target), giveXP)) != SpellCastResult.SUCCESS) {
                return result;
            }
            return SpellUtils.applyStackStage(stack, caster, target, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, null, world, true, giveXP, 0);
        }
        SpellCastResult result = SpellUtils.applyStageToGround(stack, caster, world, mop.func_178782_a(), mop.field_178784_b, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, giveXP);
        if (result != SpellCastResult.SUCCESS) {
            return result;
        }
        return SpellUtils.applyStackStage(stack, caster, target, mop.func_178782_a().func_177958_n(), mop.func_178782_a().func_177956_o(), mop.func_178782_a().func_177952_p(), mop.field_178784_b, world, true, giveXP, 0);
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.TARGET_NONSOLID_BLOCKS);
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.itemOre, 1, 0), Items.field_151008_G, Items.field_151115_aP, Items.field_151119_aD};
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 1.0f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return false;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

