/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shape;

import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.entity.EntitySpellEffect;
import am2.items.ItemSpellBase;
import am2.spell.SpellCastResult;
import am2.utils.SpellUtils;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class Wave
extends SpellShape {
    @Override
    public Object[] getRecipe() {
        return new Object[]{new ItemStack((Item)ItemDefs.itemOre, 1, 0), BlockDefs.magicWall, "E:*", 25000};
    }

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, EnumFacing side, boolean giveXP, int useCount) {
        if (world.field_72995_K) {
            return SpellCastResult.SUCCESS;
        }
        double radius = SpellUtils.getModifiedDouble_Add(1.0, stack, caster, (Entity)target, world, SpellModifiers.RADIUS);
        int duration = SpellUtils.getModifiedInt_Mul(20, stack, caster, (Entity)target, world, SpellModifiers.DURATION);
        double speed = SpellUtils.getModifiedDouble_Add(1.0, stack, caster, (Entity)target, world, SpellModifiers.SPEED) * 0.5;
        int gravityModifiers = SpellUtils.countModifiers(SpellModifiers.GRAVITY, stack);
        boolean hasPiercing = SpellUtils.modifierIsPresent(SpellModifiers.PIERCING, stack);
        EntitySpellEffect wave = new EntitySpellEffect(world);
        wave.setRadius((float)radius);
        wave.setTicksToExist(duration);
        wave.SetCasterAndStack(caster, stack);
        wave.func_70107_b(x, y + 1.0, z);
        wave.setWave(caster.field_70177_z, (float)speed);
        wave.field_70145_X = hasPiercing;
        wave.setGravity((float)gravityModifiers * 0.5f);
        world.func_72838_d((Entity)wave);
        return SpellCastResult.SUCCESS;
    }

    @Override
    public EnumSet<SpellModifiers> getModifiers() {
        return EnumSet.of(SpellModifiers.RADIUS, new SpellModifiers[]{SpellModifiers.GRAVITY, SpellModifiers.DURATION, SpellModifiers.COLOR, SpellModifiers.SPEED, SpellModifiers.PIERCING, SpellModifiers.TARGET_NONSOLID_BLOCKS});
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 3.0f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return true;
    }

    @Override
    public void encodeBasicData(NBTTagCompound tag, Object[] recipe) {
    }
}

