/*
 * Decompiled with CFR 0.152.
 */
package am2.trackers;

import am2.bosses.BossSpawnHelper;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;

public class EntityItemWatcher {
    private final ArrayList<EntityItem> watchedItems = new ArrayList();
    private final ArrayList<EntityItem> toRemove = new ArrayList();
    private final ArrayList<Block> inlayBlocks = new ArrayList();
    private final ArrayList<Item> itemsToWatch = new ArrayList();
    public static EntityItemWatcher instance = new EntityItemWatcher();

    private EntityItemWatcher() {
        this.init();
    }

    public void init() {
        this.registerInlayBlock(BlockDefs.redstoneInlay);
        this.registerInlayBlock(BlockDefs.ironInlay);
        this.registerInlayBlock(BlockDefs.goldInlay);
        this.registerWatchableItem(Items.field_151124_az);
        this.registerWatchableItem(Items.field_151131_as);
        this.registerWatchableItem(ItemDefs.essence);
        this.registerWatchableItem(ItemDefs.itemOre);
        this.registerWatchableItem(Items.field_151166_bC);
        this.registerWatchableItem(Items.field_151061_bv);
    }

    public void tick() {
        this.watchedItems.removeAll(this.toRemove);
        this.toRemove.clear();
        ArrayList<EntityItem> tempItemList = new ArrayList<EntityItem>(this.watchedItems);
        for (EntityItem item : tempItemList) {
            if (item.field_70128_L) {
                this.toRemove.add(item);
                continue;
            }
            if (!item.func_70027_ad() && (Math.abs(item.field_70159_w) > 0.01 || Math.abs(item.field_70181_x) > 0.01 || Math.abs(item.field_70179_y) > 0.01)) continue;
            BlockPos pos = item.func_180425_c();
            if (item.func_70027_ad()) {
                pos = pos.func_177984_a();
            }
            boolean insideRing = true;
            Block ringType = null;
            for (int i = -1; i <= 1 && insideRing; ++i) {
                for (int j = -1; j <= 1 && insideRing; ++j) {
                    if (i == 0 && j == 0) continue;
                    Block blockID1 = item.field_70170_p.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c();
                    Block blockID2 = item.field_70170_p.func_180495_p(pos.func_177982_a(i, -1, j)).func_177230_c();
                    Block blockID3 = item.field_70170_p.func_180495_p(pos.func_177982_a(i, 1, j)).func_177230_c();
                    if (this.inlayBlocks.contains(blockID1) || this.inlayBlocks.contains(blockID2) || this.inlayBlocks.contains(blockID3)) {
                        if (ringType == null) {
                            ringType = this.inlayBlocks.contains(blockID1) ? blockID1 : (this.inlayBlocks.contains(blockID2) ? blockID2 : blockID3);
                            continue;
                        }
                        if (ringType == blockID1 || ringType == blockID2 || ringType == blockID3) continue;
                        insideRing = false;
                        continue;
                    }
                    insideRing = false;
                }
            }
            if (insideRing) {
                BossSpawnHelper.instance.onItemInRing(item, ringType);
            }
            this.removeWatchedItem(item);
        }
        tempItemList.clear();
    }

    public void addWatchedItem(EntityItem item) {
        if (this.itemsToWatch.contains(item.func_92059_d().func_77973_b())) {
            this.watchedItems.add(item);
        }
    }

    public void registerInlayBlock(Block inlayBlock) {
        if (!this.inlayBlocks.contains(inlayBlock)) {
            this.inlayBlocks.add(inlayBlock);
        }
    }

    public void registerWatchableItem(Item item) {
        if (!this.itemsToWatch.contains(item)) {
            this.itemsToWatch.add(item);
        }
    }

    private void removeWatchedItem(EntityItem item) {
        this.toRemove.add(item);
    }
}

