/*
 * Decompiled with CFR 0.152.
 */
package am2.trackers;

import am2.ArsMagica2;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleApproachEntity;
import am2.particles.ParticleColorShift;
import am2.particles.ParticleHoldPosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFrameWatcher {
    private final HashMap<EntityItemFrameComparator, Integer> watchedFrames = new HashMap();
    private final ArrayList<EntityItemFrameComparator> queuedAddFrames = new ArrayList();
    private final ArrayList<EntityItemFrameComparator> queuedRemoveFrames = new ArrayList();
    private static final int processTime = 800;

    public void checkWatchedFrames() {
        ArrayList<EntityItemFrameComparator> toRemove = new ArrayList<EntityItemFrameComparator>();
        this.updateQueuedChanges();
        for (EntityItemFrameComparator frameComp : this.watchedFrames.keySet()) {
            Integer time = this.watchedFrames.get(frameComp);
            if (time == null) {
                time = 0;
            }
            if (frameComp == null || frameComp.frame == null || ((EntityItemFrameComparator)frameComp).frame.field_70170_p == null) continue;
            if (!((EntityItemFrameComparator)frameComp).frame.field_70170_p.field_72995_K || time >= 800) {
                toRemove.add(frameComp);
            }
            if (this.frameIsValid(frameComp.frame)) {
                if (this.checkFrameRadius(frameComp)) continue;
                toRemove.remove(frameComp);
                continue;
            }
            Integer n = time;
            Integer n2 = time = Integer.valueOf(time + 1);
            this.watchedFrames.put(frameComp, time);
        }
        for (EntityItemFrameComparator frame : toRemove) {
            this.stopWatchingFrame(frame.frame);
        }
    }

    private boolean checkFrameRadius(EntityItemFrameComparator frameComp) {
        int radius = 3;
        boolean shouldRemove = true;
        EntityItemFrame frame = frameComp.frame;
        Integer time = this.watchedFrames.get(frameComp);
        for (int i = -radius; i <= radius; ++i) {
            block1: for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    if (frame.field_70170_p.func_180495_p(frame.func_180425_c().func_177982_a(i, j, k)).func_177230_c() != BlockDefs.liquid_essence.getBlock()) continue;
                    if (time == null) {
                        time = 0;
                    }
                    Integer n = time;
                    Integer n2 = time = Integer.valueOf(time + 1);
                    if (time >= 800) {
                        if (frame.field_70170_p.field_72995_K) continue;
                        frame.func_82334_a(new ItemStack(ItemDefs.arcaneCompendium));
                        shouldRemove = true;
                        continue block1;
                    }
                    shouldRemove = false;
                    if (!frame.field_70170_p.field_72995_K || time / 64 % 1 != 0) continue;
                    this.spawnCompendiumProgressParticles(frame, frame.func_180425_c().func_177982_a(i, j, k));
                }
            }
        }
        this.watchedFrames.put(frameComp, time);
        return shouldRemove;
    }

    private boolean frameIsValid(EntityItemFrame frame) {
        return frame != null && !frame.field_70128_L && frame.func_82335_i() != null && frame.func_82335_i().func_77973_b() instanceof ItemBook;
    }

    private void updateQueuedChanges() {
        EntityItemFrameComparator[] toAdd = this.queuedAddFrames.toArray(new EntityItemFrameComparator[this.queuedAddFrames.size()]);
        this.queuedAddFrames.clear();
        for (EntityItemFrameComparator comp : toAdd) {
            if (comp.frame == null || comp.frame.func_82335_i() != null && comp.frame.func_82335_i().func_77973_b() == ItemDefs.arcaneCompendium) continue;
            this.watchedFrames.put(comp, 0);
        }
        EntityItemFrameComparator[] toRemove = this.queuedRemoveFrames.toArray(new EntityItemFrameComparator[this.queuedRemoveFrames.size()]);
        this.queuedRemoveFrames.clear();
        for (EntityItemFrameComparator comp : toRemove) {
            Integer time = this.watchedFrames.get(comp);
            if (time != null && time >= 800 && comp.frame != null && !((EntityItemFrameComparator)comp).frame.field_70128_L && ((EntityItemFrameComparator)comp).frame.field_70170_p.field_72995_K && comp.frame.func_82335_i() != null && (comp.frame.func_82335_i().func_77973_b() == Items.field_151122_aG || comp.frame.func_82335_i().func_77973_b() == ItemDefs.arcaneCompendium)) {
                this.spawnCompendiumCompleteParticles(comp.frame);
            }
            this.watchedFrames.remove(comp);
        }
    }

    public void startWatchingFrame(EntityItemFrame frame) {
        this.queuedAddFrames.add(new EntityItemFrameComparator(frame));
    }

    public void stopWatchingFrame(EntityItemFrame frame) {
        this.queuedRemoveFrames.add(new EntityItemFrameComparator(frame));
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnCompendiumProgressParticles(EntityItemFrame frame, BlockPos pos) {
        Random rand = new Random();
        AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(frame.field_70170_p, "symbols", (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + rand.nextDouble(), (double)pos.func_177952_p() + rand.nextDouble()));
        if (particle != null) {
            particle.setIgnoreMaxAge(true);
            particle.AddParticleController(new ParticleApproachEntity(particle, (Entity)frame, 0.02f, 0.04f, 1, false).setKillParticleOnFinish(true));
            particle.setRandomScale(0.05f, 0.12f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnCompendiumCompleteParticles(EntityItemFrame frame) {
        AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(frame.field_70170_p, "radiant", frame.field_70165_t, frame.field_70163_u, frame.field_70161_v));
        if (particle != null) {
            particle.setIgnoreMaxAge(false);
            particle.func_187114_a(40);
            particle.setParticleScale(0.3f);
            particle.AddParticleController(new ParticleHoldPosition(particle, 40, 1, false));
            particle.AddParticleController(new ParticleColorShift(particle, 1, false).SetShiftSpeed(0.2f));
        }
    }

    private class EntityItemFrameComparator {
        private final EntityItemFrame frame;

        public EntityItemFrameComparator(EntityItemFrame frame) {
            this.frame = frame;
        }

        public boolean equals(Object obj) {
            if (this.frame == null) {
                return false;
            }
            if (obj instanceof EntityItemFrame) {
                return ((EntityItemFrame)obj).func_145782_y() == this.frame.func_145782_y() && ((EntityItemFrame)obj).field_70170_p.field_72995_K == this.frame.field_70170_p.field_72995_K;
            }
            if (obj instanceof EntityItemFrameComparator) {
                return ((EntityItemFrameComparator)obj).frame.func_145782_y() == this.frame.func_145782_y() && ((EntityItemFrameComparator)obj).frame.field_70170_p.field_72995_K == this.frame.field_70170_p.field_72995_K;
            }
            return false;
        }

        public int hashCode() {
            if (this.frame == null || this.frame.field_70170_p == null) {
                return 0;
            }
            return this.frame.func_145782_y() + (this.frame.field_70170_p.field_72995_K ? 1 : 2);
        }
    }
}

