/*
 * Decompiled with CFR 0.152.
 */
package am2.utils;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.event.AffinityChangingEvent;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellShape;
import am2.armor.ArmorHelper;
import am2.defs.ItemDefs;
import am2.defs.SkillDefs;
import am2.extensions.AffinityData;
import am2.extensions.EntityExtension;
import am2.extensions.SkillData;
import am2.utils.SpellUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class AffinityShiftUtils {
    public static void doAffinityShift(EntityLivingBase caster, SpellComponent component, SpellShape governingShape) {
        if (!(caster instanceof EntityPlayer)) {
            return;
        }
        AffinityData aff = AffinityData.For(caster);
        Set<Affinity> affList = component.getAffinity();
        for (Affinity affinity : affList) {
            float shift = component.getAffinityShift(affinity) * aff.getDiminishingReturnsFactor() * 5.0f;
            float xp = 0.05f * aff.getDiminishingReturnsFactor();
            if (governingShape.isChanneled()) {
                shift /= 4.0f;
                xp /= 4.0f;
            }
            if (caster instanceof EntityPlayer) {
                ItemStack chestArmor;
                if (SkillData.For((EntityLivingBase)((EntityPlayer)caster)).hasSkill(SkillDefs.AFFINITY_GAINS.getID())) {
                    shift *= 1.1f;
                    xp *= 0.9f;
                }
                if ((chestArmor = ((EntityPlayer)caster).func_184582_a(EntityEquipmentSlot.CHEST)) != null && ArmorHelper.isInfusionPreset(chestArmor, "mg_xp")) {
                    xp *= 1.25f;
                }
            }
            if (shift > 0.0f) {
                AffinityChangingEvent event = new AffinityChangingEvent((EntityPlayer)caster, affinity, shift);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled()) {
                    aff.incrementAffinity(affinity, event.amount);
                }
            }
            if (!(xp > 0.0f)) continue;
            xp = (float)((double)xp * caster.func_110140_aT().func_111151_a(ArsMagicaAPI.xpGainModifier).func_111126_e());
            EntityExtension.For(caster).addMagicXP(xp);
        }
        aff.addDiminishingReturns(governingShape.isChanneled());
    }

    public static Affinity getMainShiftForStack(ItemStack stack) {
        Affinity aff = Affinity.NONE;
        float maxDepth = 0.0f;
        HashMap<Affinity, Float> customDepthMap = new HashMap<Affinity, Float>();
        ArrayList<SpellComponent> components = SpellUtils.getComponentsForStage(stack, -1);
        for (SpellComponent spellComponent : components) {
            for (Affinity aff1 : spellComponent.getAffinity()) {
                if (customDepthMap.get(aff1) != null) {
                    customDepthMap.put(aff1, Float.valueOf(((Float)customDepthMap.get(aff1)).floatValue() + spellComponent.getAffinityShift(aff1)));
                    continue;
                }
                customDepthMap.put(aff1, Float.valueOf(spellComponent.getAffinityShift(aff1)));
            }
        }
        for (Map.Entry entry : customDepthMap.entrySet()) {
            if (!(((Float)entry.getValue()).floatValue() > maxDepth)) continue;
            maxDepth = ((Float)entry.getValue()).floatValue();
            aff = (Affinity)entry.getKey();
        }
        return aff;
    }

    public static ItemStack getEssenceForAffinity(Affinity affinity) {
        Affinity aff;
        int meta = 0;
        Iterator iterator = ArsMagicaAPI.getAffinityRegistry().getValues().iterator();
        while (iterator.hasNext() && !(aff = (Affinity)iterator.next()).equals(affinity)) {
            ++meta;
        }
        return new ItemStack((Item)ItemDefs.essence, 1, meta);
    }
}

