/*
 * Decompiled with CFR 0.152.
 */
package am2.utils;

import am2.entity.EntityBroomInventory;
import am2.utils.GetFirstStackStartingFromSlotResult;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;

public class InventoryUtilities {
    public static int decrementStackQuantity(IInventory inventory, int slotIndex, int quantity) {
        int deducted = 0;
        ItemStack stack = inventory.func_70301_a(slotIndex);
        if (stack != null) {
            if (stack.field_77994_a < quantity) {
                quantity = stack.field_77994_a;
            }
            stack.field_77994_a -= quantity;
            deducted = quantity;
            if (stack.field_77994_a <= 0) {
                inventory.func_70299_a(slotIndex, null);
            } else {
                inventory.func_70299_a(slotIndex, stack);
            }
        }
        return deducted;
    }

    public static boolean mergeIntoInventory(IInventory inventory, ItemStack toMerge) {
        return InventoryUtilities.mergeIntoInventory(inventory, toMerge, toMerge.field_77994_a);
    }

    public static boolean mergeIntoInventory(IInventory inventory, ItemStack toMerge, int quantity) {
        if (quantity > toMerge.field_77994_a) {
            quantity = toMerge.field_77994_a;
        }
        int qty = quantity;
        int emptySlot = -1;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_94041_b(i, toMerge)) continue;
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null) {
                if (emptySlot != -1) continue;
                emptySlot = i;
                continue;
            }
            if (!InventoryUtilities.compareItemStacks(inventoryStack, toMerge, true, false, true, true) || inventoryStack.field_77994_a == inventoryStack.func_77976_d()) continue;
            if (inventoryStack.func_77976_d() - inventoryStack.field_77994_a >= qty) {
                inventoryStack.field_77994_a += qty;
                toMerge.field_77994_a -= qty;
                return true;
            }
            qty -= inventoryStack.func_77976_d() - inventoryStack.field_77994_a;
            inventoryStack.field_77994_a = inventoryStack.func_77976_d();
        }
        if (qty > 0 && emptySlot > -1) {
            ItemStack temp = toMerge.func_77946_l();
            temp.field_77994_a = qty;
            inventory.func_70299_a(emptySlot, temp);
            toMerge.field_77994_a -= qty;
            return true;
        }
        toMerge.field_77994_a = qty;
        return false;
    }

    public static boolean mergeIntoInventory(IInventory inventory, ItemStack toMerge, int quantity, EnumFacing side) {
        if (inventory instanceof ISidedInventory) {
            ItemStack stack = toMerge.func_77979_a(Math.min(toMerge.field_77994_a, quantity));
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_180463_a(side);
            boolean flag = false;
            for (int i = 0; i < slots.length && stack != null && stack.field_77994_a > 0; ++i) {
                int max;
                ItemStack prvStack = sidedInventory.func_70301_a(slots[i]);
                if (!InventoryUtilities.canInsertItemToInventory((IInventory)sidedInventory, stack, slots[i], side)) continue;
                if (prvStack == null) {
                    max = Math.min(stack.func_77976_d(), sidedInventory.func_70297_j_());
                    if (max >= stack.field_77994_a) {
                        sidedInventory.func_70299_a(slots[i], stack.func_77946_l());
                        stack.field_77994_a = 0;
                        flag = true;
                        continue;
                    }
                    sidedInventory.func_70299_a(slots[i], stack.func_77979_a(max));
                    flag = true;
                    continue;
                }
                if (!InventoryUtilities.canStacksMerge(prvStack, stack) || (max = Math.min(stack.func_77976_d(), sidedInventory.func_70297_j_())) <= prvStack.field_77994_a) continue;
                int qty = Math.min(stack.field_77994_a, max - prvStack.field_77994_a);
                prvStack.field_77994_a += qty;
                stack.field_77994_a -= qty;
                flag = qty > 0;
            }
            toMerge.field_77994_a += stack.field_77994_a;
            return flag;
        }
        return InventoryUtilities.mergeIntoInventory(inventory, toMerge, quantity);
    }

    public static boolean deductFromInventory(IInventory inventory, ItemStack search, int quantity) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null || !InventoryUtilities.compareItemStacks(inventoryStack, search, true, false, true, true)) continue;
            if (search.field_77994_a <= 0) {
                inventory.func_70299_a(i, null);
                return true;
            }
            if ((quantity -= InventoryUtilities.decrementStackQuantity(inventory, i, quantity)) > 0) continue;
            if (inventory.func_70301_a(i) != null && inventory.func_70301_a((int)i).field_77994_a <= 0) {
                inventory.func_70299_a(i, null);
            }
            return true;
        }
        return false;
    }

    public static boolean inventoryHasItem(IInventory inventory, ItemStack search, int quantity) {
        int qtyFound = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null || !InventoryUtilities.compareItemStacks(inventoryStack, search, true, false, true, true) || (qtyFound += inventoryStack.field_77994_a) < quantity) continue;
            return true;
        }
        return false;
    }

    public static boolean inventoryHasItem(IInventory inventory, ItemStack search, int quantity, EnumFacing side) {
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int qtyFound = 0;
            int[] slots = sidedInventory.func_180463_a(side);
            for (int i = 0; i < slots.length; ++i) {
                ItemStack inventoryStack = inventory.func_70301_a(slots[i]);
                if (inventoryStack == null || !InventoryUtilities.compareItemStacks(inventoryStack, search, true, false, true, true) || (qtyFound += inventoryStack.field_77994_a) < quantity) continue;
                return true;
            }
            return false;
        }
        return InventoryUtilities.inventoryHasItem(inventory, search, quantity);
    }

    public static int getFirstBlockInInventory(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null || !(inventoryStack.func_77973_b() instanceof ItemBlock)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isInventoryFull(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack != null) continue;
            return false;
        }
        return true;
    }

    public static boolean canMergeHappen(IInventory source, IInventory dest) {
        for (int i = 0; i < source.func_70302_i_(); ++i) {
            if (source.func_70301_a(i) == null || !InventoryUtilities.inventoryHasRoomFor(dest, source.func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isInventoryEmpty(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack inventoryStack = inventory.func_70301_a(i);
            if (inventoryStack == null) continue;
            return false;
        }
        return true;
    }

    public static boolean inventoryHasRoomFor(IInventory inventory, ItemStack stack) {
        return InventoryUtilities.inventoryHasRoomFor(inventory, stack, stack.field_77994_a);
    }

    public static boolean inventoryHasRoomFor(IInventory inventory, ItemStack stack, int qty) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack invStack = inventory.func_70301_a(i);
            if (invStack == null) {
                return true;
            }
            if (!InventoryUtilities.compareItemStacks(invStack, stack, true, false, true, true) || invStack.func_77976_d() - invStack.field_77994_a < qty) continue;
            return true;
        }
        return false;
    }

    public static boolean inventoryHasRoomFor(IInventory inventory, ItemStack stack, int qty, EnumFacing side) {
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_180463_a(side);
            for (int i = 0; i < slots.length; ++i) {
                ItemStack invStack = inventory.func_70301_a(slots[i]);
                if (invStack == null) {
                    return true;
                }
                if (!InventoryUtilities.compareItemStacks(invStack, stack, true, false, true, true) || invStack.func_77976_d() - invStack.field_77994_a < qty) continue;
                return true;
            }
            return false;
        }
        return InventoryUtilities.inventoryHasRoomFor(inventory, stack, qty);
    }

    public static ItemStack getFirstStackInInventory(EntityBroomInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack invStack = inventory.func_70301_a(i);
            if (invStack == null) continue;
            return invStack;
        }
        return null;
    }

    public static int getInventorySlotIndexFor(IInventory inventory, Item item) {
        return InventoryUtilities.getInventorySlotIndexFor(inventory, item, Short.MAX_VALUE);
    }

    public static int getInventorySlotIndexFor(IInventory inventory, Item item, int metadata) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || stack.func_77952_i() != metadata && metadata != Short.MAX_VALUE) continue;
            return i;
        }
        return -1;
    }

    public static int getInventorySlotIndexFor(IInventory inventory, ItemStack search) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !InventoryUtilities.compareItemStacks(stack, search, false, false, true, true)) continue;
            return i;
        }
        return -1;
    }

    public static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return InventoryUtilities.compareItemStacks(stack1, stack2, true, false, true, true);
    }

    public static int getLikeItemCount(IInventory inventory, ItemStack stack) {
        int totalCount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack invStack = inventory.func_70301_a(i);
            if (invStack == null || !InventoryUtilities.compareItemStacks(invStack, stack, true, false, true, true)) continue;
            totalCount += invStack.field_77994_a;
        }
        return totalCount;
    }

    public static int getLikeItemCount(IInventory inventory, ItemStack stack, EnumFacing side) {
        if (inventory instanceof ISidedInventory) {
            int totalCount = 0;
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_180463_a(side);
            for (int i = 0; i < slots.length; ++i) {
                ItemStack invStack = inventory.func_70301_a(slots[i]);
                if (invStack == null || !InventoryUtilities.compareItemStacks(invStack, stack, true, false, true, true)) continue;
                totalCount += invStack.field_77994_a;
            }
            return totalCount;
        }
        return InventoryUtilities.getLikeItemCount(inventory, stack);
    }

    public static boolean canInsertItemToInventory(IInventory inventory, ItemStack itemStack, int slot, EnumFacing side) {
        return !inventory.func_94041_b(slot, itemStack) ? false : !(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_180462_a(slot, itemStack, side);
    }

    private static boolean canExtractItemFromInventory(IInventory inventory, ItemStack itemStack, int slot, EnumFacing side) {
        return !(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_180461_b(slot, itemStack, side);
    }

    public static GetFirstStackStartingFromSlotResult getFirstStackStartingFromSlot(IInventory inventory, ItemStack itemStack, int slot) {
        for (int i = slot; i < inventory.func_70302_i_(); ++i) {
            itemStack = inventory.func_70301_a(i);
            if (itemStack == null) continue;
            return new GetFirstStackStartingFromSlotResult(i, itemStack);
        }
        return new GetFirstStackStartingFromSlotResult(-1, null);
    }

    public static GetFirstStackStartingFromSlotResult getFirstStackStartingFromSlot(IInventory inventory, ItemStack itemStack, int slot, EnumFacing side) {
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidededInventory = (ISidedInventory)inventory;
            int[] slots = sidededInventory.func_180463_a(side);
            for (int i = slot; i < slots.length; ++i) {
                itemStack = inventory.func_70301_a(slots[i]);
                if (itemStack == null || !InventoryUtilities.canExtractItemFromInventory((IInventory)sidededInventory, itemStack, slots[i], side)) continue;
                return new GetFirstStackStartingFromSlotResult(i, itemStack);
            }
        } else {
            return InventoryUtilities.getFirstStackStartingFromSlot(inventory, itemStack, slot);
        }
        return new GetFirstStackStartingFromSlotResult(-1, null);
    }

    public static TileEntityChest getAdjacentChest(TileEntityChest chest) {
        TileEntityChest adjacent = null;
        if (chest.field_145991_k != null) {
            adjacent = chest.field_145991_k;
        } else if (chest.field_145990_j != null) {
            adjacent = chest.field_145990_j;
        } else if (chest.field_145988_l != null) {
            adjacent = chest.field_145988_l;
        } else if (chest.field_145992_i != null) {
            adjacent = chest.field_145992_i;
        }
        return adjacent;
    }

    public static ItemStack replaceItem(ItemStack originalStack, Item newItem) {
        ItemStack stack = new ItemStack(newItem, originalStack.field_77994_a, originalStack.func_77952_i());
        if (originalStack.func_77942_o()) {
            stack.func_77982_d(originalStack.func_77978_p());
        }
        return stack;
    }

    public static boolean compareItemStacks(ItemStack a, ItemStack b, boolean matchMeta, boolean matchStackSize, boolean matchNBT, boolean allowAnyMeta) {
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (allowAnyMeta && a.func_77952_i() != b.func_77952_i() && a.func_77952_i() != Short.MAX_VALUE && b.func_77952_i() != Short.MAX_VALUE) {
            return false;
        }
        if (matchMeta && a.func_77952_i() != b.func_77952_i()) {
            return false;
        }
        if (matchStackSize && a.field_77994_a != b.field_77994_a) {
            return false;
        }
        return !matchNBT || ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }
}

