/*
 * Decompiled with CFR 0.152.
 */
package am2.utils;

import am2.api.blocks.IKeystoneLockable;
import am2.api.items.KeystoneAccessType;
import am2.defs.ItemDefs;
import am2.extensions.EntityExtension;
import am2.items.ItemKeystone;
import am2.items.ItemRune;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;

public class KeystoneUtilities {
    public static final int MODE_NONE = 0;
    public static final int MODE_USE = 1;
    public static final int MODE_BREAK = 2;
    public static final KeystoneUtilities instance = new KeystoneUtilities();

    public static boolean HandleKeystoneRecovery(EntityPlayer player, IKeystoneLockable<?> lock) {
        if (EntityExtension.For((EntityLivingBase)player).isRecoveringKeystone) {
            if (instance.getKeyFromRunes(lock.getRunesInKey()) != 0L) {
                String combo = "";
                for (ItemStack rune : lock.getRunesInKey()) {
                    combo = rune == null ? combo + "empty " : combo + rune.func_82833_r() + " ";
                }
                player.func_145747_a((ITextComponent)new TextComponentString(combo));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.noKeyPresent")));
            }
            EntityExtension.For((EntityLivingBase)player).isRecoveringKeystone = false;
            return true;
        }
        return false;
    }

    public ArrayList<Long> GetKeysInInvenory(EntityLivingBase ent) {
        ArrayList<Long> toReturn = new ArrayList<Long>();
        toReturn.add(0L);
        if (ent instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)ent;
            for (ItemStack is : p.field_71071_by.field_70462_a) {
                ItemKeystone keystone;
                long key;
                if (is == null || !(is.func_77973_b() instanceof ItemKeystone) || toReturn.contains(key = (keystone = (ItemKeystone)is.func_77973_b()).getKey(is))) continue;
                toReturn.add(key);
            }
        }
        return toReturn;
    }

    public long getKeyFromRunes(ItemStack[] runes) {
        long key = 0L;
        int index = 0;
        for (ItemStack stack : runes) {
            if (stack == null || stack.func_77973_b() != ItemDefs.rune) continue;
            long keyIndex = ((ItemRune)stack.func_77973_b()).getKeyIndex(stack);
            key |= keyIndex << index * 16;
            ++index;
        }
        return key;
    }

    public boolean canPlayerAccess(IKeystoneLockable<?> inventory, EntityPlayer player, KeystoneAccessType accessMode) {
        ItemStack[] runes = inventory.getRunesInKey();
        long key = this.getKeyFromRunes(runes);
        if (key == 0L) {
            return true;
        }
        if (inventory.keystoneMustBeHeld()) {
            if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == ItemDefs.keystone) {
                return ((ItemKeystone)player.func_184614_ca().func_77973_b()).getKey(player.func_184614_ca()) == key;
            }
        } else if (inventory.keystoneMustBeInActionBar()) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != ItemDefs.keystone || ((ItemKeystone)stack.func_77973_b()).getKey(stack) != key) continue;
                return true;
            }
        } else {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != ItemDefs.keystone || ((ItemKeystone)stack.func_77973_b()).getKey(stack) != key) continue;
                return true;
            }
        }
        if (accessMode == KeystoneAccessType.USE && !player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.wrongKeystoneUse")));
        } else if (accessMode == KeystoneAccessType.BREAK && !player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.wrongKeystoneBreak")));
        }
        return false;
    }
}

