/*
 * Decompiled with CFR 0.152.
 */
package am2.utils;

import am2.api.math.AMVector3;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class MathUtilities {
    public static Vec3d bezier(Vec3d s, Vec3d c1, Vec3d c2, Vec3d e, float t) {
        if (t < 0.0f || t > 1.0f) {
            throw new InvalidParameterException("t is out of range, with a value of :" + t);
        }
        float one_minus_t = 1.0f - t;
        Vec3d retValue = new Vec3d(0.0, 0.0, 0.0);
        Vec3d[] terms = new Vec3d[]{MathUtilities.calcNewVector(one_minus_t * one_minus_t * one_minus_t, s), MathUtilities.calcNewVector(3.0f * one_minus_t * one_minus_t * t, c1), MathUtilities.calcNewVector(3.0f * one_minus_t * t * t, c2), MathUtilities.calcNewVector(t * t * t, e)};
        for (int i = 0; i < 4; ++i) {
            retValue.func_178787_e(terms[i]);
        }
        return retValue;
    }

    private static Vec3d calcNewVector(float scaler, Vec3d base) {
        Vec3d retValue = new Vec3d(base.field_72450_a, base.field_72448_b, base.field_72449_c);
        retValue.func_186678_a((double)scaler);
        return retValue;
    }

    public static Vec3d floorToI(Vec3d old) {
        return new Vec3d((double)((float)Math.floor(old.field_72450_a)), (double)((float)Math.floor(old.field_72448_b)), (double)((float)Math.floor(old.field_72449_c)));
    }

    public static Vec3d roundToI(Vec3d old) {
        return new Vec3d((double)Math.round(old.field_72450_a), (double)Math.round(old.field_72448_b), (double)Math.round(old.field_72449_c));
    }

    public static Vec3d[] GetHorizontalBlocksInFrontOfCharacter(EntityLivingBase entity, int numBlocks, int x, int y, int z) {
        float speed = 0.1f;
        float factor = (float)Math.PI / 180;
        float sinYawRadians = MathHelper.func_76126_a((float)(entity.field_70177_z * factor));
        float cosYawRadians = MathHelper.func_76134_b((float)(entity.field_70177_z * factor));
        double motionZ = cosYawRadians * speed;
        double motionX = -sinYawRadians * speed;
        double curX = x;
        double curY = y;
        double curZ = z;
        float minimum = 0.01f;
        if (Math.abs(motionX) < (double)minimum) {
            motionX = 0.0;
        }
        if (Math.abs(motionZ) < (double)minimum) {
            motionZ = 0.0;
        }
        int lastX = x;
        int lastY = y;
        int lastZ = z;
        Vec3d[] list = new Vec3d[numBlocks];
        list[0] = new Vec3d((double)x, (double)y, (double)z);
        int count = 1;
        while (count < numBlocks) {
            if ((int)Math.round(curX += motionX) == lastX && (int)Math.round(curY) == lastY && (int)Math.round(curZ += motionZ) == lastZ) continue;
            lastX = (int)Math.round(curX);
            lastY = (int)Math.round(curY);
            lastZ = (int)Math.round(curZ);
            list[count++] = new Vec3d((double)lastX, (double)lastY, (double)lastZ);
        }
        return list;
    }

    public static Vec3d[] GetBlocksInFrontOfCharacter(EntityLivingBase entity, int numBlocks, int x, int y, int z) {
        float speed = 0.1f;
        float factor = (float)Math.PI / 180;
        float sinYawRadians = MathHelper.func_76126_a((float)(entity.field_70177_z * factor));
        float cosYawRadians = MathHelper.func_76134_b((float)(entity.field_70177_z * factor));
        float sinPitchRadians = MathHelper.func_76126_a((float)(entity.field_70125_A * factor));
        float cosPitchRadians = MathHelper.func_76134_b((float)(entity.field_70125_A * factor));
        double motionZ = cosYawRadians * cosPitchRadians * speed;
        double motionX = -sinYawRadians * cosPitchRadians * speed;
        double motionY = -sinPitchRadians * speed;
        double curX = x;
        double curY = y;
        double curZ = z;
        float minimum = 0.01f;
        if (Math.abs(motionX) < (double)minimum) {
            motionX = 0.0;
        }
        if (Math.abs(motionY) < (double)minimum) {
            motionY = 0.0;
        }
        if (Math.abs(motionZ) < (double)minimum) {
            motionZ = 0.0;
        }
        int lastX = x;
        int lastY = y;
        int lastZ = z;
        Vec3d[] list = new Vec3d[numBlocks];
        list[0] = new Vec3d((double)x, (double)y, (double)z);
        int count = 1;
        while (count < numBlocks) {
            if ((int)Math.round(curX += motionX) == lastX && (int)Math.round(curY += motionY) == lastY && (int)Math.round(curZ += motionZ) == lastZ) continue;
            lastX = (int)Math.round(curX);
            lastY = (int)Math.round(curY);
            lastZ = (int)Math.round(curZ);
            list[count++] = new Vec3d((double)lastX, (double)lastY, (double)lastZ);
        }
        return list;
    }

    public static Entity[] GetEntitiesInAngleNearEntity(World world, EntityLivingBase source, int degrees, int radius, Class<? extends Entity> filterClass, boolean includeSource) {
        if (degrees > 360) {
            degrees = 360;
        }
        if (degrees < 5) {
            return new Entity[0];
        }
        List distanceFilter = world.func_72872_a(filterClass, new AxisAlignedBB((double)((float)source.field_70165_t - (float)radius), source.field_70163_u - (double)radius, (double)((float)source.field_70161_v - (float)radius), source.field_70165_t + (double)radius, source.field_70163_u + (double)radius, source.field_70161_v + (double)radius));
        if (!includeSource) {
            for (int x = 0; x < distanceFilter.size(); ++x) {
                if (distanceFilter.get(x) != source) continue;
                distanceFilter.remove(x);
                --x;
            }
        }
        ArrayList<Entity> angleFilter = new ArrayList<Entity>();
        float maxAngle = degrees;
        for (int i = 0; i < distanceFilter.size(); ++i) {
            Entity curEntity = (Entity)distanceFilter.get(i);
            if (!MathUtilities.isInFieldOfVision(curEntity, source, maxAngle, maxAngle) || !source.func_70685_l(curEntity)) continue;
            angleFilter.add(curEntity);
        }
        Entity[] array = new Entity[angleFilter.size()];
        for (int t = 0; t < angleFilter.size(); ++t) {
            array[t] = (Entity)angleFilter.get(t);
        }
        return array;
    }

    public static boolean isInFieldOfVision(Entity e1, EntityLivingBase e2, float angleX, float angleY) {
        boolean flag2;
        float rotationYawPrime = e2.field_70177_z;
        float rotationPitchPrime = e2.field_70125_A;
        if (e2 instanceof EntityLiving) {
            ((EntityLiving)e2).func_70625_a(e1, 360.0f, 360.0f);
        }
        float f = e2.field_70177_z;
        float f2 = e2.field_70125_A;
        e2.field_70177_z = rotationYawPrime;
        e2.field_70125_A = rotationPitchPrime;
        rotationYawPrime = f;
        rotationPitchPrime = f2;
        float X = angleX;
        float Y = angleY;
        float yawFOVMin = e2.field_70177_z - X;
        float yawFOVMax = e2.field_70177_z + X;
        float pitchFOVMin = e2.field_70125_A - Y;
        float pitchFOVMax = e2.field_70125_A + Y;
        boolean flag1 = yawFOVMin < 0.0f && (rotationYawPrime >= yawFOVMin + 360.0f || rotationYawPrime <= yawFOVMax) || yawFOVMax >= 360.0f && (rotationYawPrime <= yawFOVMax - 360.0f || rotationYawPrime >= yawFOVMin) || yawFOVMax < 360.0f && yawFOVMin >= 0.0f && rotationYawPrime <= yawFOVMax && rotationYawPrime >= yawFOVMin;
        boolean bl = flag2 = pitchFOVMin <= -180.0f && (rotationPitchPrime >= pitchFOVMin + 360.0f || rotationPitchPrime <= pitchFOVMax) || pitchFOVMax > 180.0f && (rotationPitchPrime <= pitchFOVMax - 360.0f || rotationPitchPrime >= pitchFOVMin) || pitchFOVMax < 180.0f && pitchFOVMin >= -180.0f && rotationPitchPrime <= pitchFOVMax && rotationPitchPrime >= pitchFOVMin;
        return flag1 && flag2 && e2.func_70685_l(e1);
    }

    public static double NormalizeRotation(double yawValue) {
        block3: {
            block2: {
                if (!(yawValue < 0.0)) break block2;
                while (yawValue < 0.0) {
                    yawValue += 360.0;
                }
                break block3;
            }
            if (!(yawValue > 359.0)) break block3;
            while (yawValue > 359.0) {
                yawValue -= 360.0;
            }
        }
        return yawValue;
    }

    public static Vec3d GetMovementVectorBetweenEntities(Entity from, Entity to) {
        Vec3d fromPosition = new Vec3d(from.field_70165_t, from.field_70163_u, from.field_70161_v);
        Vec3d toPosition = new Vec3d(to.field_70165_t, to.field_70163_u, to.field_70161_v);
        Vec3d delta = fromPosition.func_178788_d(toPosition);
        delta.func_72432_b();
        return delta;
    }

    public static Vec3d GetMovementVectorBetweenPoints(Vec3d from, Vec3d to) {
        Vec3d delta = from.func_178788_d(to);
        delta.func_72432_b();
        return delta;
    }

    public static Entity getPointedEntity(World world, EntityLivingBase entityplayer, double range, double collideRadius) {
        return MathUtilities.getPointedEntity(world, entityplayer, range, collideRadius, false);
    }

    public static Entity getPointedEntity(World world, EntityLivingBase entityplayer, double range, double collideRadius, boolean nonCollide) {
        Entity pointedEntity = null;
        double d = range;
        Vec3d vec3d = new Vec3d(entityplayer.field_70165_t, entityplayer.field_70163_u + (double)entityplayer.func_70047_e(), entityplayer.field_70161_v);
        Vec3d vec3d1 = entityplayer.func_70040_Z();
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d);
        double f1 = collideRadius;
        List list = world.func_72839_b((Entity)entityplayer, entityplayer.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d).func_72314_b(f1, f1, f1));
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            Entity entity = (Entity)list.get(i);
            RayTraceResult mop = world.func_72901_a(new Vec3d(entityplayer.field_70165_t, entityplayer.field_70163_u + (double)entityplayer.func_70047_e(), entityplayer.field_70161_v), new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), false);
            if (!entity.func_70067_L() && !nonCollide || mop != null) continue;
            float f2 = Math.max(0.8f, entity.func_70111_Y());
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b((double)f2, (double)f2, (double)f2);
            RayTraceResult movingobjectposition = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
            pointedEntity = entity;
            d2 = d3;
        }
        return pointedEntity;
    }

    public static Vec3d extrapolateEntityLook(World par1World, EntityLivingBase entity, double range) {
        float var4 = 1.0f;
        float var5 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * var4;
        float var6 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * var4;
        double var7 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)var4;
        double var9 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)var4 + 1.6 - entity.func_70033_W();
        double var11 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)var4;
        Vec3d var13 = new Vec3d(var7, var9, var11);
        float var14 = MathHelper.func_76134_b((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -MathHelper.func_76134_b((float)(-var5 * ((float)Math.PI / 180)));
        float var17 = MathHelper.func_76126_a((float)(-var5 * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        double var21 = range;
        Vec3d var23 = var13.func_72441_c((double)var18 * var21, (double)var17 * var21, (double)var20 * var21);
        return var23;
    }

    public static Vec3d getLook(Entity source, float f) {
        if (f == 1.0f) {
            float var2 = MathHelper.func_76134_b((float)(-source.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float var3 = MathHelper.func_76126_a((float)(-source.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float var4 = -MathHelper.func_76134_b((float)(-source.field_70125_A * ((float)Math.PI / 180)));
            float var5 = MathHelper.func_76126_a((float)(-source.field_70125_A * ((float)Math.PI / 180)));
            return new Vec3d((double)(var3 * var4), (double)var5, (double)(var2 * var4));
        }
        float var2 = source.field_70127_C + (source.field_70125_A - source.field_70127_C) * f;
        float var3 = source.field_70126_B + (source.field_70177_z - source.field_70126_B) * f;
        float var4 = MathHelper.func_76134_b((float)(-var3 * ((float)Math.PI / 180) - (float)Math.PI));
        float var5 = MathHelper.func_76126_a((float)(-var3 * ((float)Math.PI / 180) - (float)Math.PI));
        float var6 = -MathHelper.func_76134_b((float)(-var2 * ((float)Math.PI / 180)));
        float var7 = MathHelper.func_76126_a((float)(-var2 * ((float)Math.PI / 180)));
        return new Vec3d((double)(var5 * var6), (double)var7, (double)(var4 * var6));
    }

    public static int getDistanceToGround(EntityLivingBase ent, World world) {
        int yCoord = (int)ent.field_70163_u;
        int distance = 0;
        while (!(distance >= 20 || world.func_175623_d(new BlockPos((int)Math.floor(ent.field_70165_t), yCoord, (int)Math.floor(ent.field_70161_v))) || world.func_175623_d(new BlockPos((int)Math.ceil(ent.field_70165_t), yCoord, (int)Math.floor(ent.field_70161_v))) || world.func_175623_d(new BlockPos((int)Math.floor(ent.field_70165_t), yCoord, (int)Math.ceil(ent.field_70161_v))) || world.func_175623_d(new BlockPos((int)Math.ceil(ent.field_70165_t), yCoord, (int)Math.ceil(ent.field_70161_v))))) {
            ++distance;
            --yCoord;
        }
        return distance;
    }

    public static float[] colorIntToFloats(int color) {
        float[] colors = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return colors;
    }

    public static int colorFloatsToInt(float r, float g, float b) {
        return ((int)(r * 255.0f) << 16) + ((int)(g * 255.0f) << 8) + (int)(b * 255.0f);
    }

    public static int[] push(int[] original, int value) {
        int[] newArr = new int[original.length + 1];
        for (int i = 0; i < original.length; ++i) {
            newArr[i] = original[i];
        }
        newArr[newArr.length - 1] = value;
        return newArr;
    }

    public static int[] splice(int[] arr, int index) {
        if (arr.length <= 1) {
            return arr;
        }
        int[] newArr = new int[arr.length - 1];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (i == index) continue;
            newArr[count++] = arr[i];
        }
        return newArr;
    }

    public static AMVector3 GetMovementVectorBetweenPoints(AMVector3 a, AMVector3 b) {
        return new AMVector3(MathUtilities.GetMovementVectorBetweenPoints(a.toVec3D(), b.toVec3D()));
    }
}

