/*
 * Decompiled with CFR 0.152.
 */
package am2.utils;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.client.model.ModelShield;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Quaternion;

@SideOnly(value=Side.CLIENT)
public class ModelUtils {
    public static final Type mapType = new TypeToken<Map<String, String>>(){}.getType();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(mapType, (Object)ModelTextureDeserializer.INSTANCE).create();
    public static final IModelState NULL_STATE;
    public static final IModelState DEFAULT_ITEM_STATE;
    public static final IModelState DEFAULT_BLOCK_STATE;
    public static final IModelState DEFAULT_SHIELD_STATE;
    public static final IModelState BLOCKING_SHIELD_STATE;

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
    }

    public static void renderShield(ItemStack stack, boolean isBlocking, ItemCameraTransforms.TransformType type, EntityLivingBase entity) {
        GlStateManager.func_179094_E();
        ModelUtils.transform(isBlocking ? BLOCKING_SHIELD_STATE : DEFAULT_SHIELD_STATE, type, false);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        new ModelShield().func_187062_a();
        GlStateManager.func_179121_F();
    }

    public static void transform(IModelState state, ItemCameraTransforms.TransformType type, boolean leftHand) {
        TRSRTransformation transform = (TRSRTransformation)state.apply(Optional.fromNullable((Object)type)).orNull();
        if (transform != null) {
            GlStateManager.func_179109_b((float)transform.getTranslation().x, (float)transform.getTranslation().y, (float)transform.getTranslation().z);
            GlStateManager.func_179152_a((float)transform.getScale().x, (float)transform.getScale().y, (float)transform.getScale().z);
            GlStateManager.func_187444_a((Quaternion)new Quaternion(transform.getLeftRot().x, transform.getLeftRot().y, transform.getLeftRot().z, transform.getLeftRot().w));
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ModelUtils.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        builder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)ModelUtils.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ModelUtils.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ModelUtils.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ModelUtils.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ModelUtils.get(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_ITEM_STATE = new SimpleModelState(builder.build());
        ImmutableMap.Builder builderBlock = ImmutableMap.builder();
        builderBlock.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        builderBlock.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ModelUtils.get(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        builderBlock.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        builderBlock.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ModelUtils.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f));
        builderBlock.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ModelUtils.get(0.0f, 2.5f, 0.0f, 75.0f, 225.0f, 0.0f, 0.375f));
        builderBlock.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        builderBlock.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        DEFAULT_BLOCK_STATE = new SimpleModelState(builderBlock.build());
        ImmutableMap.Builder builderShield = ImmutableMap.builder();
        builderShield.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ModelUtils.get(-2.0f, -2.0f, 0.0f, 15.0f, -25.0f, -5.0f, 0.65f));
        builderShield.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        builderShield.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ModelUtils.get(-16.0f, -1.0f, 1.0f, 0.0f, 0.0f, 90.0f, 0.5f));
        builderShield.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ModelUtils.get(10.51f, 6.0f, -20.0f, 0.0f, 90.0f, 0.0f, 1.0f));
        builderShield.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ModelUtils.get(-26.51f, 6.0f, 12.0f, 0.0f, -90.0f, 0.0f, 1.0f));
        builderShield.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ModelUtils.get(-27.1f, 4.82f, -28.0f, 0.0f, 180.0f, 5.0f, 1.25f));
        builderShield.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ModelUtils.get(-28.88f, 1.0f, -28.0f, 0.0f, 180.0f, -5.0f, 1.25f));
        DEFAULT_SHIELD_STATE = new SimpleModelState(builderShield.build());
        ImmutableMap.Builder builderBlockingShield = ImmutableMap.builder();
        builderBlockingShield.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ModelUtils.get(-2.0f, -2.0f, 0.0f, 15.0f, -25.0f, -5.0f, 0.65f));
        builderBlockingShield.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        builderBlockingShield.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ModelUtils.get(-16.0f, -1.0f, 1.0f, 0.0f, 0.0f, 90.0f, 0.5f));
        builderBlockingShield.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ModelUtils.get(-7.0f, 18.0f, -12.0f, 45.0f, 135.0f, 0.0f, 1.0f));
        builderBlockingShield.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ModelUtils.get(-32.0f, 3.0f, 4.0f, 45.0f, -135.0f, 0.0f, 1.0f));
        builderBlockingShield.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ModelUtils.get(-34.0f, 5.0f, -32.0f, 0.0f, 180.0f, -5.0f, 1.25f));
        builderBlockingShield.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ModelUtils.get(-26.88f, 7.0f, -30.0f, 0.0f, 180.0f, 5.0f, 1.25f));
        BLOCKING_SHIELD_STATE = new SimpleModelState(builderBlockingShield.build());
        ImmutableMap.Builder builderNull = ImmutableMap.builder();
        builderNull.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
        builderNull.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
        builderNull.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
        builderNull.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
        builderNull.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
        builderNull.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
        builderNull.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ModelUtils.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
        NULL_STATE = new SimpleModelState(builderBlockingShield.build());
    }

    public static class ModelTextureDeserializer
    implements JsonDeserializer<Map<String, String>> {
        public static final ModelTextureDeserializer INSTANCE = new ModelTextureDeserializer();
        private static final Gson GSON = new Gson();

        public Map<String, String> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonElement texElem = obj.get("textures");
            if (texElem == null) {
                throw new JsonParseException("Missing textures entry in json");
            }
            return (Map)GSON.fromJson(texElem, mapType);
        }
    }
}

