/*
 * Decompiled with CFR 0.152.
 */
package am2.utils;

import am2.LogHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderFactory<T extends Entity>
implements IRenderFactory<T> {
    private Constructor<Render<T>> constructor;

    public RenderFactory(Class<Render<T>> clazz) {
        try {
            this.constructor = clazz.getConstructor(RenderManager.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public Render<T> createRenderFor(RenderManager manager) {
        try {
            Render<T> render = this.constructor.newInstance(manager);
            LogHelper.debug("Successfully created instance for : " + this.constructor.getDeclaringClass().getName(), new Object[0]);
            return render;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

