/*
 * Decompiled with CFR 0.152.
 */
package am2.utils;

import am2.api.math.AMVector3;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import scala.util.Random;

public class RenderUtils {
    private static Random rand = new Random();

    public static void drawBox(float minX, float minZ, float maxX, float maxZ, float zLevel, float minU, float minV, float maxU, float maxV) {
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer wr = t.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b((double)minX, (double)(minZ + maxZ), (double)zLevel).func_187315_a((double)minU, (double)maxV).func_181675_d();
        wr.func_181662_b((double)(minX + maxX), (double)(minZ + maxZ), (double)zLevel).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        wr.func_181662_b((double)(minX + maxX), (double)minZ, (double)zLevel).func_187315_a((double)maxU, (double)minV).func_181675_d();
        wr.func_181662_b((double)minX, (double)minZ, (double)zLevel).func_187315_a((double)minU, (double)minV).func_181675_d();
        t.func_78381_a();
    }

    public static float getRed(int color) {
        return (float)((color & 0xFF0000) >> 16) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)((color & 0xFF00) >> 8) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static void color(int color) {
        GL11.glColor4f((float)RenderUtils.getRed(color), (float)RenderUtils.getGreen(color), (float)RenderUtils.getBlue(color), (float)0.5f);
    }

    public static int getColor(float r, float g, float b) {
        int red = (int)(r * 255.0f) << 16;
        int green = (int)(g * 255.0f) << 8;
        int blue = (int)(b * 255.0f);
        return red + green + blue;
    }

    public static void line2d(float xStart, float yStart, float xEnd, float yEnd, float zLevel, int color) {
        GL11.glDisable((int)3553);
        GlStateManager.func_179126_j();
        GL11.glLineWidth((float)1.0f);
        GL11.glColor3d((double)((double)((color & 0xFF0000) >> 16) / 255.0), (double)((float)((color & 0xFF00) >> 8) / 255.0f), (double)((float)(color & 0xFF) / 255.0f));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)xStart, (float)yStart, (float)zLevel);
        GL11.glVertex3f((float)xEnd, (float)yEnd, (float)zLevel);
        GL11.glEnd();
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GlStateManager.func_179097_i();
        GL11.glEnable((int)3553);
    }

    public static void lineThick2d(float xStart, float yStart, float xEnd, float yEnd, float zLevel, int color) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GlStateManager.func_179126_j();
        GL11.glLineWidth((float)4.0f);
        GL11.glColor3d((double)((double)((color & 0xFF0000) >> 16) / 255.0), (double)((float)((color & 0xFF00) >> 8) / 255.0f), (double)((float)(color & 0xFF) / 255.0f));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)xStart, (float)yStart, (float)zLevel);
        GL11.glVertex3f((float)xEnd, (float)yEnd, (float)zLevel);
        GL11.glEnd();
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GlStateManager.func_179097_i();
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void fractalLine2df(float xStart, float yStart, float xEnd, float yEnd, float zLevel, int color, float displace, float fractalDetail) {
        if (displace < fractalDetail) {
            RenderUtils.line2d(xStart, yStart, xEnd, yEnd, zLevel, color);
        } else {
            int mid_x = (int)((xEnd + xStart) / 2.0f);
            int mid_y = (int)((yEnd + yStart) / 2.0f);
            mid_x = (int)((double)mid_x + ((double)rand.nextFloat() - 0.5) * (double)displace);
            mid_y = (int)((double)mid_y + ((double)rand.nextFloat() - 0.5) * (double)displace);
            RenderUtils.fractalLine2df(xStart, yStart, mid_x, mid_y, zLevel, color, displace / 2.0f, fractalDetail);
            RenderUtils.fractalLine2df(xEnd, yEnd, mid_x, mid_y, zLevel, color, displace / 2.0f, fractalDetail);
        }
    }

    public static void fractalLine2dd(double xStart, double yStart, double xEnd, double yEnd, float zLevel, int color, float displace, float fractalDetail) {
        RenderUtils.fractalLine2df((float)xStart, (float)yStart, (float)xEnd, (float)yEnd, zLevel, color, displace, fractalDetail);
    }

    public static void drawTextInWorldAtOffset(String text, double x, double y, double z, int color) {
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        int b0 = 0;
        GL11.glDisable((int)3553);
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int j = fontrenderer.func_78256_a(text) / 2;
        tessellator.func_178180_c().func_181662_b((double)(-j - 1), (double)(-1 + b0), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.75f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(-j - 1), (double)(8 + b0), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.75f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(j + 1), (double)(8 + b0), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.75f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(j + 1), (double)(-1 + b0), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.75f).func_181675_d();
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        fontrenderer.func_78276_b(text, -fontrenderer.func_78256_a(text) / 2, b0, 0x20FFFFFF);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.func_78276_b(text, -fontrenderer.func_78256_a(text) / 2, b0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void RenderRotatedModelGroup(TileEntity te, IBakedModel model, IBlockState defaultState, AMVector3 rotation) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)rotation.x, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation.y, (float)1.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation.z, (float)1.0f, (float)0.0f, (float)1.0f);
        RenderUtils.renderBlockModel(te, model, defaultState);
        GlStateManager.func_179121_F();
    }

    public static void renderBlockModel(TileEntity te, IBakedModel model, IBlockState defaultState) {
        try {
            IBlockState state;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-te.func_174877_v().func_177958_n()), (float)(-te.func_174877_v().func_177956_o()), (float)(-te.func_174877_v().func_177952_p()));
            Tessellator t = Tessellator.func_178181_a();
            VertexBuffer wr = t.func_178180_c();
            wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            World world = te.func_145831_w();
            if (world == null) {
                world = Minecraft.func_71410_x().field_71441_e;
            }
            if ((state = world.func_180495_p(te.func_174877_v())).func_177230_c() != defaultState.func_177230_c()) {
                state = defaultState;
            }
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, model, state, te.func_174877_v(), wr, true);
            t.func_78381_a();
            GlStateManager.func_179121_F();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

