/*
 * Decompiled with CFR 0.152.
 */
package am2.utils;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.SpellRegistry;
import am2.api.affinity.Affinity;
import am2.api.event.SpellCastEvent;
import am2.api.spell.AbstractSpellPart;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.armor.ArmorHelper;
import am2.armor.ArsMagicaArmorMaterial;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import am2.defs.SpellDefs;
import am2.enchantments.AMEnchantmentHelper;
import am2.entity.EntityDarkMage;
import am2.entity.EntityLightMage;
import am2.extensions.AffinityData;
import am2.extensions.EntityExtension;
import am2.gui.AMGuiHelper;
import am2.items.ItemSpellBase;
import am2.spell.SpellCastResult;
import am2.spell.modifier.Colour;
import am2.spell.shape.MissingShape;
import am2.utils.AffinityShiftUtils;
import am2.utils.EntityUtils;
import am2.utils.KeyValuePair;
import am2.utils.NBTUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SpellUtils {
    public static final String TYPE_SHAPE = "Shape";
    public static final String TYPE_COMPONENT = "Component";
    public static final String TYPE_MODIFIER = "Modifier";
    public static final String TYPE = "Type";
    public static final String ID = "ID";
    public static final String SHAPE_GROUP = "ShapeGroup";
    public static final String STAGE = "Stage_";
    public static final String SPELL_DATA = "SpellData";

    public static SpellShape getShapeForStage(ItemStack oldIs, int stage) {
        if (oldIs == null || !oldIs.func_77942_o()) {
            return SpellDefs.MISSING_SHAPE;
        }
        ItemStack stack = SpellUtils.merge(oldIs.func_77946_l());
        NBTTagCompound am2Tag = NBTUtils.getAM2Tag(stack.func_77978_p());
        NBTTagList stageTag = NBTUtils.addCompoundList(am2Tag, STAGE + stage);
        String shapeName = "null";
        for (int i = 0; i < stageTag.func_74745_c(); ++i) {
            if (!stageTag.func_150305_b(i).func_74779_i(TYPE).equals(TYPE_SHAPE)) continue;
            shapeName = stageTag.func_150305_b(i).func_74779_i(ID);
            break;
        }
        return SpellRegistry.getShapeFromName(shapeName) != null ? SpellRegistry.getShapeFromName(shapeName) : SpellDefs.MISSING_SHAPE;
    }

    public static void changeEnchantmentsForShapeGroup(ItemStack stack) {
        ItemStack constructed = SpellUtils.merge(stack);
        int looting = 0;
        int silkTouch = 0;
        for (int i = 0; i < SpellUtils.numStages(constructed); ++i) {
            looting += SpellUtils.countModifiers(SpellModifiers.FORTUNE_LEVEL, constructed);
            silkTouch += SpellUtils.countModifiers(SpellModifiers.SILKTOUCH_LEVEL, constructed);
        }
        AMEnchantmentHelper.fortuneStack(stack, looting);
        AMEnchantmentHelper.lootingStack(stack, looting);
        AMEnchantmentHelper.silkTouchStack(stack, silkTouch);
    }

    public static float modifyDamage(EntityLivingBase caster, float damage) {
        float factor = (float)(EntityExtension.For(caster).getCurrentLevel() < 20 ? 0.5 + 0.5 * (double)(EntityExtension.For(caster).getCurrentLevel() / 19) : 1.0 + 1.0 * (double)(EntityExtension.For(caster).getCurrentLevel() - 20) / 79.0);
        return damage * factor;
    }

    public static boolean modifierIsPresent(SpellModifiers mod, ItemStack stack) {
        ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(stack, -1);
        if (mods.isEmpty()) {
            return false;
        }
        for (SpellModifier m : mods) {
            if (!m.getAspectsModified().contains((Object)mod)) continue;
            return true;
        }
        return false;
    }

    public static int countModifiers(SpellModifiers mod, ItemStack stack) {
        ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(stack, -1);
        int i = 0;
        for (SpellModifier m : mods) {
            if (!m.getAspectsModified().contains((Object)mod)) continue;
            ++i;
        }
        return i;
    }

    public static boolean attackTargetSpecial(ItemStack spellStack, Entity target, DamageSource damagesource, float magnitude) {
        if (target.field_70170_p.field_72995_K) {
            return true;
        }
        EntityPlayer dmgSrcPlayer = null;
        if (damagesource.func_76346_g() != null) {
            if (damagesource.func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase source = (EntityLivingBase)damagesource.func_76346_g();
                if ((source instanceof EntityLightMage || source instanceof EntityDarkMage) && target.getClass() == EntityCreeper.class) {
                    return false;
                }
                if (source instanceof EntityLightMage && target instanceof EntityLightMage) {
                    return false;
                }
                if (source instanceof EntityDarkMage && target instanceof EntityDarkMage) {
                    return false;
                }
                if (source instanceof EntityPlayer && target instanceof EntityPlayer && !target.field_70170_p.field_72995_K && (!FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W() || ((EntityPlayer)target).field_71075_bZ.field_75098_d)) {
                    return false;
                }
                if (source.func_70644_a(PotionEffectsDefs.fury)) {
                    magnitude += 4.0f;
                }
            }
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                dmgSrcPlayer = (EntityPlayer)damagesource.func_76346_g();
                int armorSet = ArmorHelper.getFullArsMagicaArmorSet(dmgSrcPlayer);
                if (armorSet == ArsMagicaArmorMaterial.MAGE.getMaterialID()) {
                    magnitude *= 1.05f;
                } else if (armorSet == ArsMagicaArmorMaterial.BATTLEMAGE.getMaterialID()) {
                    magnitude *= 1.025f;
                } else if (armorSet == ArsMagicaArmorMaterial.ARCHMAGE.getMaterialID()) {
                    magnitude *= 1.1f;
                }
                ItemStack equipped = dmgSrcPlayer.func_184607_cu();
                if (equipped != null && equipped.func_77973_b() == ItemDefs.arcaneSpellbook) {
                    magnitude *= 1.1f;
                }
            }
        }
        if (target instanceof EntityLivingBase && EntityUtils.isSummon((EntityLivingBase)target) && damagesource.field_76373_n.equals("magic")) {
            magnitude *= 3.0f;
        }
        boolean success = false;
        success = target instanceof EntityDragon ? ((EntityDragon)target).func_70965_a(((EntityDragon)target).field_70987_i, damagesource, magnitude) : target.func_70097_a(damagesource, magnitude *= ArsMagica2.config.getDamageMultiplier());
        if (dmgSrcPlayer != null && spellStack != null && target instanceof EntityLivingBase && !target.field_70170_p.field_72995_K && ((EntityLivingBase)target).func_110143_aJ() <= 0.0f && SpellUtils.modifierIsPresent(SpellModifiers.DISMEMBERING_LEVEL, spellStack)) {
            double chance = SpellUtils.getModifiedDouble_Add(0.0, spellStack, (EntityLivingBase)dmgSrcPlayer, target, dmgSrcPlayer.field_70170_p, SpellModifiers.DISMEMBERING_LEVEL);
            if (dmgSrcPlayer.field_70170_p.field_73012_v.nextDouble() <= chance) {
                SpellUtils.dropHead(target, dmgSrcPlayer.field_70170_p);
            }
        }
        return success;
    }

    private static void dropHead(Entity target, World world) {
        if (target.getClass() == EntitySkeleton.class) {
            if (((EntitySkeleton)target).func_189771_df() == SkeletonType.WITHER) {
                SpellUtils.dropHead_do(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, 1);
            } else {
                SpellUtils.dropHead_do(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, 0);
            }
        } else if (target.getClass() == EntityZombie.class) {
            SpellUtils.dropHead_do(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, 2);
        } else if (target.getClass() == EntityCreeper.class) {
            SpellUtils.dropHead_do(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, 4);
        } else if (target instanceof EntityPlayer) {
            SpellUtils.dropHead_do(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, 3);
        }
    }

    private static void dropHead_do(World world, double x, double y, double z, int type) {
        EntityItem item = new EntityItem(world);
        ItemStack stack = new ItemStack(Items.field_151144_bL, 1, type);
        item.func_92058_a(stack);
        item.func_70107_b(x, y, z);
        world.func_72838_d((Entity)item);
    }

    public static NBTTagCompound encode(KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> toEncode) {
        NBTTagCompound group = new NBTTagCompound();
        group.func_74782_a(SPELL_DATA, (NBTBase)toEncode.value);
        int stage = 0;
        for (AbstractSpellPart part : (ArrayList)toEncode.key) {
            NBTTagList stageTag = NBTUtils.addCompoundList(group, STAGE + stage);
            NBTTagCompound tmp = new NBTTagCompound();
            String id = SpellRegistry.getSkillFromPart(part).getID();
            tmp.func_74778_a(ID, id);
            String type = "";
            if (part instanceof SpellShape) {
                type = TYPE_SHAPE;
            }
            if (part instanceof SpellModifier) {
                type = TYPE_MODIFIER;
            }
            if (part instanceof SpellComponent) {
                type = TYPE_COMPONENT;
            }
            tmp.func_74778_a(TYPE, type);
            if (part instanceof SpellShape) {
                ++stage;
            }
            stageTag.func_74742_a((NBTBase)tmp);
        }
        group.func_74768_a("StageNum", stage);
        return group;
    }

    public static KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> decode(NBTTagCompound toDecode) {
        if (toDecode == null) {
            return null;
        }
        try {
            ArrayList<AbstractSpellPart> parts = new ArrayList<AbstractSpellPart>();
            for (int j = 0; j < NBTUtils.getAM2Tag(toDecode).func_74762_e("StageNum"); ++j) {
                NBTTagList stageTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(toDecode), STAGE + j);
                for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                    NBTTagCompound tmp = stageTag.func_150305_b(i);
                    String type = tmp.func_74779_i(TYPE);
                    if (type.equalsIgnoreCase(TYPE_COMPONENT)) {
                        parts.add(SpellRegistry.getComponentFromName(tmp.func_74779_i(ID)));
                    }
                    if (type.equalsIgnoreCase(TYPE_MODIFIER)) {
                        parts.add(SpellRegistry.getModifierFromName(tmp.func_74779_i(ID)));
                    }
                    if (!type.equalsIgnoreCase(TYPE_SHAPE)) continue;
                    parts.add(SpellRegistry.getShapeFromName(tmp.func_74779_i(ID)));
                }
            }
            return new KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound>(parts, toDecode.func_74775_l(SPELL_DATA));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ItemStack createSpellStack(ArrayList<KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound>> shapeGroups, ArrayList<AbstractSpellPart> spellDef, NBTTagCompound encodedData) {
        ItemStack stack = new ItemStack((Item)ItemDefs.spell);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound am2 = NBTUtils.getAM2Tag(tag);
        am2.func_74782_a(SPELL_DATA, (NBTBase)encodedData);
        NBTTagList shapeGroupList = NBTUtils.addCompoundList(am2, "ShapeGroups");
        for (KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> shapeGroup : shapeGroups) {
            if (((ArrayList)shapeGroup.key).isEmpty()) continue;
            NBTTagCompound group = new NBTTagCompound();
            group.func_74782_a(SPELL_DATA, (NBTBase)shapeGroup.value);
            int stage = 0;
            boolean lastWasShape = false;
            for (AbstractSpellPart part : (ArrayList)shapeGroup.key) {
                NBTTagList stageTag = NBTUtils.addCompoundList(group, STAGE + stage);
                NBTTagCompound tmp = new NBTTagCompound();
                String id = part.getRegistryName().toString();
                tmp.func_74778_a(ID, id);
                String type = "";
                if (part instanceof SpellShape) {
                    type = TYPE_SHAPE;
                }
                if (part instanceof SpellModifier) {
                    type = TYPE_MODIFIER;
                }
                if (part instanceof SpellComponent) {
                    type = TYPE_COMPONENT;
                }
                tmp.func_74778_a(TYPE, type);
                if (part instanceof SpellShape) {
                    ++stage;
                    lastWasShape = true;
                } else {
                    lastWasShape = false;
                }
                stageTag.func_74742_a((NBTBase)tmp);
            }
            group.func_74768_a("StageNum", stage);
            group.func_74757_a("LastWasShape", lastWasShape);
            group.func_74768_a("CurrentGroup", 0);
            shapeGroupList.func_74742_a((NBTBase)group);
        }
        int stage = 0;
        for (AbstractSpellPart part : spellDef) {
            NBTTagList stageTag = NBTUtils.addCompoundList(am2, STAGE + stage);
            NBTTagCompound tmp = new NBTTagCompound();
            String id = SpellRegistry.getSkillFromPart(part).getID();
            tmp.func_74778_a(ID, id);
            String type = "";
            if (part instanceof SpellShape) {
                type = TYPE_SHAPE;
            }
            if (part instanceof SpellModifier) {
                type = TYPE_MODIFIER;
            }
            if (part instanceof SpellComponent) {
                type = TYPE_COMPONENT;
            }
            tmp.func_74778_a(TYPE, type);
            if (part instanceof SpellShape) {
                ++stage;
            }
            stageTag.func_74742_a((NBTBase)tmp);
        }
        am2.func_74768_a("StageNum", stage + 1);
        am2.func_74768_a("NumShapeGroups", shapeGroupList.func_74745_c());
        am2.func_74768_a("CurrentShapeGroup", shapeGroupList.func_74745_c() == 0 ? -1 : 0);
        am2.func_74768_a("CurrentGroup", 0);
        stack.func_77982_d(tag);
        return stack;
    }

    public static ItemStack merge(ItemStack spellIn) {
        if (spellIn.func_77978_p() == null) {
            return spellIn;
        }
        if (NBTUtils.getAM2Tag(spellIn.func_77978_p()).func_74762_e("CurrentShapeGroup") == -1) {
            return spellIn;
        }
        ItemStack newStack = spellIn.func_77946_l();
        if (spellIn.func_77973_b() != ItemDefs.spell) {
            newStack.func_150996_a((Item)ItemDefs.spell);
        }
        NBTTagCompound group = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(newStack.func_77978_p()), "ShapeGroups").func_150305_b(NBTUtils.getAM2Tag(newStack.func_77978_p()).func_74762_e("CurrentShapeGroup")).func_74737_b();
        int stageNum = SpellUtils.numStages(newStack);
        for (int i = 0; i < stageNum; ++i) {
            NBTTagList list = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(newStack.func_77978_p()), STAGE + i).func_74737_b();
            if (i == 0 && !group.func_74767_n("LastWasShape")) {
                NBTTagList newList = NBTUtils.addCompoundList(group, STAGE + group.func_74762_e("StageNum")).func_74737_b();
                for (int j = 0; j < list.func_74745_c(); ++j) {
                    newList.func_74742_a((NBTBase)list.func_150305_b(j));
                }
                list = newList;
            }
            group.func_74782_a(STAGE + (i + group.func_74762_e("StageNum")), (NBTBase)list);
        }
        group.func_74768_a("StageNum", group.func_74762_e("StageNum") + stageNum);
        group.func_74768_a("CurrentShapeGroup", -1);
        group.func_74775_l(SPELL_DATA).func_179237_a(NBTUtils.getAM2Tag(newStack.func_77978_p()).func_74775_l(SPELL_DATA));
        newStack.func_77982_d(NBTUtils.addTag(new NBTTagCompound(), group, "AM2"));
        return newStack;
    }

    public static ItemStack popStackStage(ItemStack is) {
        NBTUtils.getAM2Tag(is.func_77978_p()).func_74768_a("CurrentGroup", NBTUtils.getAM2Tag(is.func_77978_p()).func_74762_e("CurrentGroup") + 1);
        return is;
    }

    public static int numStages(ItemStack stack) {
        return NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("StageNum");
    }

    public static float getManaCost(ItemStack stack, Entity caster) {
        if (stack.func_77978_p() == null) {
            return 0.0f;
        }
        ItemStack mergedStack = SpellUtils.merge(stack);
        AffinityData pAffinity = null;
        Affinity[] affinities = null;
        if (caster instanceof EntityPlayer) {
            pAffinity = AffinityData.For((EntityLivingBase)caster);
            affinities = pAffinity.getHighestAffinities();
        }
        try {
            float cost = 0.0f;
            float modMultiplier = 1.0f;
            for (int j = 0; j < NBTUtils.getAM2Tag(mergedStack.func_77978_p()).func_74762_e("StageNum"); ++j) {
                NBTTagList stageTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(mergedStack.func_77978_p()), STAGE + j);
                for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                    NBTTagCompound tmp = stageTag.func_150305_b(i);
                    String type = tmp.func_74779_i(TYPE);
                    if (type.equalsIgnoreCase(TYPE_COMPONENT)) {
                        SpellComponent component = SpellRegistry.getComponentFromName(tmp.func_74779_i(ID));
                        cost += component.manaCost((EntityLivingBase)ArsMagica2.proxy.getLocalPlayer());
                        if (caster instanceof EntityPlayer) {
                            block4: for (Affinity aff : affinities) {
                                for (Affinity aff2 : component.getAffinity()) {
                                    if (aff == aff2 && pAffinity.getAffinityDepth(aff) > 0.0) {
                                        cost -= (float)((double)cost * (0.5 * AffinityData.For((EntityLivingBase)caster).getAffinityDepth(aff)));
                                        continue block4;
                                    }
                                    cost += cost * 0.1f;
                                }
                            }
                        }
                    }
                    if (type.equalsIgnoreCase(TYPE_MODIFIER)) {
                        SpellModifier mod = SpellRegistry.getModifierFromName(tmp.func_74779_i(ID));
                        modMultiplier *= mod.getManaCostMultiplier(mergedStack, j, 1);
                    }
                    if (!type.equalsIgnoreCase(TYPE_SHAPE)) continue;
                    SpellShape shape = SpellRegistry.getShapeFromName(tmp.func_74779_i(ID));
                    modMultiplier *= shape.manaCostMultiplier(mergedStack);
                }
            }
            cost *= modMultiplier;
            if (caster instanceof EntityPlayer && pAffinity.getAffinityDepth(Affinity.ARCANE) > 0.5) {
                float reduction = (float)(1.0 - 0.5 * pAffinity.getAffinityDepth(Affinity.ARCANE));
                cost *= reduction;
            }
            return cost;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static float getBurnoutCost(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return 0.0f;
        }
        ItemStack mergedStack = SpellUtils.merge(stack);
        try {
            float cost = 0.0f;
            for (int j = 0; j < NBTUtils.getAM2Tag(mergedStack.func_77978_p()).func_74762_e("StageNum"); ++j) {
                NBTTagList stageTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(mergedStack.func_77978_p()), STAGE + j);
                for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                    NBTTagCompound tmp = stageTag.func_150305_b(i);
                    String type = tmp.func_74779_i(TYPE);
                    if (!type.equalsIgnoreCase(TYPE_COMPONENT)) continue;
                    SpellComponent component = SpellRegistry.getComponentFromName(tmp.func_74779_i(ID));
                    cost += component.burnout((EntityLivingBase)ArsMagica2.proxy.getLocalPlayer());
                }
            }
            return cost;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static SpellCastResult applyStackStage(ItemStack stack, EntityLivingBase caster, EntityLivingBase target, double x, double y, double z, @Nullable EnumFacing side, World world, boolean consumeMBR, boolean giveXP, int ticksUsed) {
        SpellShape shape;
        if (caster.func_70644_a(PotionEffectsDefs.silence)) {
            return SpellCastResult.SILENCED;
        }
        EntityExtension ext = EntityExtension.For(caster);
        int group = NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("CurrentGroup");
        if (group == 0) {
            stack = SpellUtils.merge(stack.func_77946_l());
        }
        if ((shape = SpellUtils.getShapeForStage(stack, group)) instanceof MissingShape) {
            return SpellCastResult.MALFORMED_SPELL_STACK;
        }
        float manaCost = SpellUtils.getManaCost(stack, (Entity)caster);
        SpellCastEvent.Pre pre = new SpellCastEvent.Pre(caster, stack, manaCost *= 1.0f + EntityExtension.For(caster).getCurrentBurnout() / EntityExtension.For(caster).getMaxBurnout());
        MinecraftForge.EVENT_BUS.post((Event)pre);
        manaCost = pre.manaCost;
        if (consumeMBR) {
            if (!ext.hasEnoughtMana(manaCost) && caster instanceof EntityPlayer && !((EntityPlayer)caster).field_71075_bZ.field_75098_d) {
                if (world.field_72995_K) {
                    AMGuiHelper.instance.flashManaBar();
                }
                return SpellCastResult.NOT_ENOUGH_MANA;
            }
            if (!SpellUtils.casterHasAllReagents(caster, stack)) {
                if (world.field_72995_K) {
                    caster.func_145747_a((ITextComponent)new TextComponentString(SpellUtils.getMissingReagents(caster, stack)));
                }
                return SpellCastResult.REAGENTS_MISSING;
            }
        }
        SpellCastResult result = SpellCastResult.EFFECT_FAILED;
        ItemStack stack2 = stack.func_77946_l();
        NBTUtils.getAM2Tag(stack2.func_77978_p()).func_74768_a("CurrentGroup", group + 1);
        if (group == 0) {
            result = shape.beginStackStage((ItemSpellBase)stack.func_77973_b(), stack2, caster, target, world, x, y, z, side, giveXP, ticksUsed);
        } else {
            NBTUtils.getAM2Tag(stack.func_77978_p()).func_74768_a("CurrentGroup", group + 1);
            result = shape.beginStackStage((ItemSpellBase)stack.func_77973_b(), stack, caster, target, world, x, y, z, side, giveXP, ticksUsed);
        }
        if (caster instanceof EntityPlayer && consumeMBR && !((EntityPlayer)caster).field_71075_bZ.field_75098_d && (result == SpellCastResult.SUCCESS || result == SpellCastResult.SUCCESS_REDUCE_MANA || result == SpellCastResult.MALFORMED_SPELL_STACK)) {
            ext.deductMana(manaCost);
            ext.setCurrentBurnout(SpellUtils.getBurnoutCost(stack));
            SpellUtils.consumeReagents(caster, stack);
            if (ext.getCurrentBurnout() > ext.getMaxBurnout()) {
                ext.setCurrentBurnout(ext.getMaxBurnout());
            }
        }
        return SpellCastResult.SUCCESS;
    }

    public static boolean casterHasAllReagents(EntityLivingBase caster, ItemStack spellStack) {
        if (caster instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)caster;
            if (player.field_71075_bZ.field_75098_d) {
                return true;
            }
            for (SpellComponent part : SpellUtils.getComponentsForStage(spellStack, -1)) {
                if (part.reagents(caster) == null) continue;
                for (ItemStack stack : part.reagents(caster)) {
                    if (stack == null) continue;
                    boolean foundMatch = false;
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack is = player.field_71071_by.func_70301_a(i);
                        if (is == null || is.func_77973_b() != stack.func_77973_b() || stack.func_77952_i() != Short.MAX_VALUE && is.func_77952_i() != stack.func_77952_i() || is.field_77994_a < stack.field_77994_a) continue;
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static String getMissingReagents(EntityLivingBase caster, ItemStack spellStack) {
        if (caster instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)caster;
            if (player.field_71075_bZ.field_75098_d) {
                return "";
            }
            StringBuilder string = new StringBuilder(I18n.func_74838_a((String)"am2.tooltip.missingReagents"));
            boolean first = true;
            for (SpellComponent part : SpellUtils.getComponentsForStage(spellStack, -1)) {
                if (part.reagents(caster) == null) continue;
                for (ItemStack stack : part.reagents(caster)) {
                    if (stack == null) continue;
                    boolean foundMatch = false;
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack is = player.field_71071_by.func_70301_a(i);
                        if (is == null || is.func_77973_b() != stack.func_77973_b() || stack.func_77952_i() != Short.MAX_VALUE && is.func_77952_i() != stack.func_77952_i() || is.field_77994_a < stack.field_77994_a) continue;
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    if (!first) {
                        string.append(", ");
                    }
                    string.append(stack.field_77994_a).append("x ").append(stack.func_82833_r());
                    first = false;
                }
            }
            return string.toString();
        }
        return "";
    }

    public static void consumeReagents(EntityLivingBase caster, ItemStack spellStack) {
        if (caster instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)caster;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            for (SpellComponent part : SpellUtils.getComponentsForStage(spellStack, -1)) {
                if (part.reagents(caster) == null) continue;
                block1: for (ItemStack stack : part.reagents(caster)) {
                    if (stack == null) continue;
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack is = player.field_71071_by.func_70301_a(i);
                        if (is == null || is.func_77973_b() != stack.func_77973_b() || stack.func_77952_i() != Short.MAX_VALUE && is.func_77952_i() != stack.func_77952_i() || is.field_77994_a < stack.field_77994_a) continue;
                        is.field_77994_a -= stack.field_77994_a;
                        if (is.field_77994_a <= 0) {
                            player.field_71071_by.func_70299_a(i, null);
                            continue block1;
                        }
                        player.field_71071_by.func_70299_a(i, is);
                        continue block1;
                    }
                }
            }
        }
    }

    public static double getModifiedStat(double defaultValue, int operation, ItemStack stack, EntityLivingBase caster, Entity target, World world, int stage, SpellModifiers modified) {
        double val = defaultValue;
        if (stage != -1) {
            NBTTagList stageTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(stack.func_77978_p()), STAGE + stack);
            for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                String tagID;
                SpellModifier mod;
                NBTTagCompound tag = stageTag.func_150305_b(i);
                String tagType = tag.func_74779_i(TYPE);
                if (!tagType.equalsIgnoreCase(TYPE_MODIFIER) || !(mod = SpellRegistry.getModifierFromName(tagID = tag.func_74779_i(ID))).getAspectsModified().contains((Object)modified)) continue;
                val = SpellUtils.makeCalculation(operation, val, mod.getModifier(modified, caster, target, world, stack.func_77978_p()));
            }
        } else {
            for (int j = 0; j < NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("StageNum"); ++j) {
                NBTTagList stageTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(stack.func_77978_p()), STAGE + j);
                for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                    String tagID;
                    SpellModifier mod;
                    NBTTagCompound tag = stageTag.func_150305_b(i);
                    String tagType = tag.func_74779_i(TYPE);
                    if (!tagType.equalsIgnoreCase(TYPE_MODIFIER) || !(mod = SpellRegistry.getModifierFromName(tagID = tag.func_74779_i(ID))).getAspectsModified().contains((Object)modified)) continue;
                    val = SpellUtils.makeCalculation(operation, val, mod.getModifier(modified, caster, target, world, stack.func_77978_p()));
                }
            }
        }
        return val;
    }

    private static double makeCalculation(int operation, double val, double mod) {
        if (operation == 0) {
            return val + mod;
        }
        if (operation == 1) {
            return val - mod;
        }
        if (operation == 2) {
            return val * mod;
        }
        if (operation == 3) {
            return val / mod;
        }
        return 0.0;
    }

    public static double getModifiedStat(int operation, ItemStack stack, EntityLivingBase caster, Entity target, World world, int stage, SpellModifiers modified) {
        return SpellUtils.getModifiedStat(modified.defaultValue, operation, stack, caster, target, world, stage, modified);
    }

    public static ArrayList<SpellModifier> getModifiersForStage(ItemStack stack, int stage) {
        ArrayList<SpellModifier> mods = new ArrayList<SpellModifier>();
        if (stack.func_77978_p() == null) {
            return mods;
        }
        if (stage != -1) {
            NBTTagList stageTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(stack.func_77978_p()), STAGE + stage);
            for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                NBTTagCompound tag = stageTag.func_150305_b(i);
                String tagType = tag.func_74779_i(TYPE);
                if (!tagType.equalsIgnoreCase(TYPE_MODIFIER)) continue;
                mods.add(SpellRegistry.getModifierFromName(tag.func_74779_i(ID)));
            }
        } else {
            for (int j = 0; j <= NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("StageNum"); ++j) {
                NBTTagList stageTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(stack.func_77978_p()), STAGE + j);
                for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                    NBTTagCompound tag = stageTag.func_150305_b(i);
                    String tagType = tag.func_74779_i(TYPE);
                    if (!tagType.equalsIgnoreCase(TYPE_MODIFIER)) continue;
                    mods.add(SpellRegistry.getModifierFromName(tag.func_74779_i(ID)));
                }
            }
        }
        return mods;
    }

    public static ArrayList<AbstractSpellPart> getPartsForGroup(ItemStack stack, int group) {
        ArrayList<AbstractSpellPart> mods = new ArrayList<AbstractSpellPart>();
        try {
            NBTTagCompound compound = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(stack.func_77978_p()), "ShapeGroups").func_150305_b(NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("CurrentShapeGroup")).func_74737_b();
            for (int j = 0; j <= compound.func_74762_e("StageNum"); ++j) {
                NBTTagList stageTag = NBTUtils.addCompoundList(compound, STAGE + j);
                for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                    NBTTagCompound tag = stageTag.func_150305_b(i);
                    String tagType = tag.func_74779_i(TYPE);
                    if (tagType.equalsIgnoreCase(TYPE_MODIFIER)) {
                        mods.add(SpellRegistry.getModifierFromName(tag.func_74779_i(ID)));
                    }
                    if (!tagType.equalsIgnoreCase(TYPE_SHAPE)) continue;
                    mods.add(SpellRegistry.getShapeFromName(tag.func_74779_i(ID)));
                }
            }
            return mods;
        }
        catch (Exception e) {
            return new ArrayList<AbstractSpellPart>();
        }
    }

    public static ArrayList<AbstractSpellPart> getPartsForSpell(ItemStack stack) {
        try {
            ArrayList<AbstractSpellPart> mods = new ArrayList<AbstractSpellPart>();
            for (int j = 0; j <= NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("StageNum"); ++j) {
                NBTTagList stageTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(stack.func_77978_p()), STAGE + j);
                for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                    NBTTagCompound tag = stageTag.func_150305_b(i);
                    mods.add((AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getValue(new ResourceLocation(tag.func_74779_i(ID))));
                }
            }
            return mods;
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    public static ArrayList<SpellComponent> getComponentsForStage(ItemStack stack, int stage) {
        try {
            ArrayList<SpellComponent> mods = new ArrayList<SpellComponent>();
            if (stage != -1) {
                NBTTagList stageTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(stack.func_77978_p()), STAGE + stage);
                for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                    NBTTagCompound tag = stageTag.func_150305_b(i);
                    String tagType = tag.func_74779_i(TYPE);
                    if (!tagType.equalsIgnoreCase(TYPE_COMPONENT)) continue;
                    mods.add(SpellRegistry.getComponentFromName(tag.func_74779_i(ID)));
                }
            } else {
                for (int j = 0; j <= NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("StageNum"); ++j) {
                    NBTTagList stageTag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(stack.func_77978_p()), STAGE + j);
                    for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                        NBTTagCompound tag = stageTag.func_150305_b(i);
                        String tagType = tag.func_74779_i(TYPE);
                        if (!tagType.equalsIgnoreCase(TYPE_COMPONENT)) continue;
                        mods.add(SpellRegistry.getComponentFromName(tag.func_74779_i(ID)));
                    }
                }
            }
            return mods;
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    public static SpellCastResult applyStageToGround(ItemStack stack, EntityLivingBase caster, World world, BlockPos pos, EnumFacing blockFace, double impactX, double impactY, double impactZ, boolean consumeMBR) {
        SpellShape stageShape = SpellUtils.getShapeForStage(stack, 0);
        if (stageShape == null || stageShape == SpellDefs.MISSING_SHAPE) {
            return SpellCastResult.MALFORMED_SPELL_STACK;
        }
        boolean isPlayer = caster instanceof EntityPlayer;
        int group = NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("CurrentGroup");
        ArrayList<SpellComponent> components = SpellUtils.getComponentsForStage(stack, group);
        for (SpellComponent component : components) {
            if (!component.applyEffectBlock(stack, world, pos, blockFace, impactX, impactY, impactZ, caster)) continue;
            if (isPlayer && !world.field_72995_K && component.getAffinity() != null) {
                AffinityShiftUtils.doAffinityShift(caster, component, stageShape);
            }
            if (!world.field_72995_K) continue;
            int color = -1;
            if (SpellUtils.modifierIsPresent(SpellModifiers.COLOR, stack)) {
                ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(stack, -1);
                for (SpellModifier mod : mods) {
                    if (!(mod instanceof Colour)) continue;
                    color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, NBTUtils.getAM2Tag(stack.func_77978_p()));
                }
            }
            component.spawnParticles(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), caster, (Entity)caster, world.field_73012_v, color);
        }
        return SpellCastResult.SUCCESS;
    }

    public static SpellCastResult applyStageToEntity(ItemStack stack, EntityLivingBase caster, World world, Entity target, boolean shiftAffinityAndXP) {
        SpellShape stageShape = SpellUtils.getShapeForStage(stack, 0);
        if (stageShape == null) {
            return SpellCastResult.MALFORMED_SPELL_STACK;
        }
        int group = NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("CurrentGroup");
        ArrayList<SpellComponent> components = SpellUtils.getComponentsForStage(stack, group);
        boolean appliedOneComponent = false;
        boolean isPlayer = caster instanceof EntityPlayer;
        for (SpellComponent component : components) {
            if (!component.applyEffectEntity(stack, world, caster, target)) continue;
            if (isPlayer && !world.field_72995_K && component.getAffinity() != null) {
                AffinityShiftUtils.doAffinityShift(caster, component, stageShape);
            }
            appliedOneComponent = true;
            if (world.field_72995_K) {
                int color = -1;
                if (SpellUtils.modifierIsPresent(SpellModifiers.COLOR, stack)) {
                    ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(stack, -1);
                    for (SpellModifier mod : mods) {
                        if (!(mod instanceof Colour)) continue;
                        color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, NBTUtils.getAM2Tag(stack.func_77978_p()));
                    }
                }
                component.spawnParticles(world, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v, caster, target, world.field_73012_v, color);
            }
            if (!(caster instanceof EntityPlayer)) continue;
            AffinityShiftUtils.doAffinityShift(caster, component, stageShape);
        }
        if (appliedOneComponent) {
            return SpellCastResult.SUCCESS;
        }
        return SpellCastResult.EFFECT_FAILED;
    }

    public static int currentStage(ItemStack spellStack) {
        return NBTUtils.getAM2Tag(spellStack.func_77978_p()).func_74762_e("CurrentGroup");
    }

    public static boolean componentIsPresent(ItemStack stack, Class<? extends SpellComponent> clazz) {
        for (SpellComponent comp : SpellUtils.getComponentsForStage(stack, SpellUtils.currentStage(stack))) {
            if (!clazz.isInstance((Object)comp)) continue;
            return true;
        }
        return false;
    }

    public static int getModifiedInt_Mul(int defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, SpellModifiers modified) {
        return (int)SpellUtils.getModifiedStat(defaultValue, 2, stack, caster, target, world, -1, modified);
    }

    public static double getModifiedDouble_Mul(double defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, SpellModifiers modified) {
        return SpellUtils.getModifiedStat(defaultValue, 2, stack, caster, target, world, -1, modified);
    }

    public static double getModifiedDouble_Mul(ItemStack stack, EntityLivingBase caster, Entity target, World world, SpellModifiers modified) {
        return SpellUtils.getModifiedStat(modified.defaultValue, 2, stack, caster, target, world, -1, modified);
    }

    public static int getModifiedInt_Add(int defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, SpellModifiers modified) {
        return (int)SpellUtils.getModifiedDouble_Add(defaultValue, stack, caster, target, world, modified);
    }

    public static double getModifiedDouble_Add(double defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, SpellModifiers modified) {
        return SpellUtils.getModifiedStat(defaultValue, 0, stack, caster, target, world, -1, modified);
    }

    public static double getModifiedDouble_Add(ItemStack stack, EntityLivingBase caster, Entity target, World world, SpellModifiers modified) {
        return SpellUtils.getModifiedStat(modified.defaultValueInt, 0, stack, caster, target, world, -1, modified);
    }

    public static int getModifiedInt_Add(ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, SpellModifiers modified) {
        return SpellUtils.getModifiedInt_Add(modified.defaultValueInt, stack, caster, (Entity)target, world, modified);
    }

    public static String getSpellMetadata(ItemStack stack, String string) {
        return NBTUtils.addTag(NBTUtils.getAM2Tag(stack.func_77978_p()), SPELL_DATA).func_74779_i(string);
    }

    public static void setSpellMetadata(ItemStack stack, String string, String s) {
        NBTUtils.addTag(NBTUtils.getAM2Tag(stack.func_77978_p()), SPELL_DATA).func_74778_a(string, s);
    }

    public static void setSpellMetadata(NBTTagCompound stack, String string, String s) {
        NBTUtils.addTag(NBTUtils.getAM2Tag(stack), SPELL_DATA).func_74778_a(string, s);
    }

    public static int numShapeGroups(ItemStack stack) {
        return NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("NumShapeGroups");
    }

    public static ArrayList<AbstractSpellPart> getShapeGroupParts(ItemStack stack, int shapeGroup) {
        try {
            ArrayList<AbstractSpellPart> mods = new ArrayList<AbstractSpellPart>();
            NBTTagCompound tag = NBTUtils.addCompoundList(NBTUtils.getAM2Tag(stack.func_77978_p()), "ShapeGroups").func_150305_b(shapeGroup);
            for (int j = 0; j <= tag.func_74762_e("StageNum"); ++j) {
                NBTTagList stageTag = NBTUtils.addCompoundList(tag, STAGE + j);
                for (int i = 0; i < stageTag.func_74745_c(); ++i) {
                    NBTTagCompound tmp = stageTag.func_150305_b(i);
                    mods.add(SpellRegistry.getComponentFromName(tmp.func_74779_i(ID)));
                }
            }
            return mods;
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    public static ItemStack createSpellStack(ArrayList<KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound>> shapeGroupSetup, KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> curRecipeSetup) {
        return SpellUtils.createSpellStack(shapeGroupSetup, (ArrayList)curRecipeSetup.key, (NBTTagCompound)curRecipeSetup.value);
    }

    public static SpellShape getShapeForStage(ItemStack stack) {
        return SpellUtils.getShapeForStage(stack, SpellUtils.currentStage(stack));
    }

    public static HashMap<Affinity, Float> AffinityFor(ItemStack stack) {
        HashMap<Affinity, Float> customDepthMap = new HashMap<Affinity, Float>();
        ArrayList<SpellComponent> components = SpellUtils.getComponentsForStage(stack, -1);
        for (SpellComponent component : components) {
            for (Affinity aff1 : component.getAffinity()) {
                if (customDepthMap.get(aff1) != null) {
                    customDepthMap.put(aff1, Float.valueOf(customDepthMap.get(aff1).floatValue() + component.getAffinityShift(aff1)));
                    continue;
                }
                customDepthMap.put(aff1, Float.valueOf(component.getAffinityShift(aff1)));
            }
        }
        return customDepthMap;
    }

    public static SpellCastResult applyStackStageOnUsing(ItemStack stack, EntityLivingBase caster, EntityLivingBase target, double x, double y, double z, World world, boolean consumeMBR, boolean giveXP, int ticks) {
        if (SpellUtils.numStages(stack) == 0) {
            return SpellCastResult.SUCCESS;
        }
        if (!SpellUtils.getShapeForStage(stack).isChanneled()) {
            return SpellCastResult.EFFECT_FAILED;
        }
        return SpellUtils.applyStackStage(stack, caster, target, x, y, z, null, world, consumeMBR, giveXP, ticks);
    }

    public static int cycleShapeGroup(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        int current = NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("CurrentShapeGroup");
        int max = NBTUtils.getAM2Tag(stack.func_77978_p()).func_74762_e("NumShapeGroups");
        if (max == 0) {
            return 0;
        }
        return (current + 1) % max;
    }

    public static void setShapeGroup(ItemStack stack, int newShapeGroupOrdinal) {
        if (stack.func_77942_o()) {
            NBTUtils.getAM2Tag(stack.func_77978_p()).func_74768_a("CurrentShapeGroup", newShapeGroupOrdinal);
        }
    }
}

