/*
 * Decompiled with CFR 0.152.
 */
package am2.world;

import am2.ArsMagica2;
import am2.api.math.AMVector3;
import am2.blocks.tileentity.flickers.FlickerOperatorMoonstoneAttractor;
import am2.entity.EntityThrownRock;
import am2.extensions.EntityExtension;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MeteorSpawnHelper {
    private final Random rand = new Random();
    private int ticksSinceLastMeteor = 0;
    public static MeteorSpawnHelper instance = new MeteorSpawnHelper();

    public void tick() {
        if (this.ticksSinceLastMeteor == 0) {
            if (FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c.length < 1) {
                return;
            }
            WorldServer ws = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0];
            if (this.rand.nextInt(2500 + 1000 * ws.field_73011_w.func_76559_b(ws.field_73011_w.getWorldTime())) == 0) {
                this.spawnMeteor();
            }
        } else {
            --this.ticksSinceLastMeteor;
        }
    }

    public void spawnMeteor() {
        this.ticksSinceLastMeteor = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().field_73012_v.nextInt(36000) + 12000;
        if (FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c.length < 1) {
            return;
        }
        WorldServer ws = null;
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            if (world.field_73011_w.getDimension() != 0) continue;
            ws = world;
            break;
        }
        if (ws == null) {
            return;
        }
        long time = ws.func_72820_D() % 24000L;
        if (time > 14500L && time < 21500L) {
            if (ws.field_73010_i.size() < 1) {
                return;
            }
            int playerID = this.rand.nextInt(ws.field_73010_i.size());
            EntityPlayer player = (EntityPlayer)ws.field_73010_i.get(playerID);
            if (EntityExtension.For((EntityLivingBase)player).getCurrentLevel() < ArsMagica2.config.getMeteorMinSpawnLevel()) {
                return;
            }
            AMVector3 spawnCoord = new AMVector3((Entity)player);
            boolean found = false;
            int meteorOffsetRadius = 64;
            AMVector3 attractorCoord = FlickerOperatorMoonstoneAttractor.getMeteorAttractor(spawnCoord);
            if (attractorCoord != null) {
                spawnCoord = attractorCoord;
                meteorOffsetRadius = 4;
            }
            for (int i = 0; i < 10; ++i) {
                BlockPos offsetCoord = spawnCoord.add(new AMVector3(this.rand.nextInt(meteorOffsetRadius) - meteorOffsetRadius / 2, 0.0, this.rand.nextInt(meteorOffsetRadius) - meteorOffsetRadius / 2)).toBlockPos();
                if ((offsetCoord = this.correctYCoord((World)ws, offsetCoord)).func_177956_o() < 0) {
                    return;
                }
                if (!this.topBlockIsBiomeGeneric((World)ws, offsetCoord)) continue;
                spawnCoord = new AMVector3(offsetCoord);
                found = true;
                break;
            }
            if (!found) {
                return;
            }
            EntityThrownRock meteor = new EntityThrownRock((World)ws);
            meteor.func_70107_b(spawnCoord.x + (float)this.rand.nextInt(meteorOffsetRadius) - (float)(meteorOffsetRadius / 2), ws.func_72940_L(), spawnCoord.z + (float)this.rand.nextInt(meteorOffsetRadius) - (float)(meteorOffsetRadius / 2));
            meteor.setMoonstoneMeteor();
            meteor.setMoonstoneMeteorTarget(spawnCoord.toVec3D());
            ws.func_72838_d((Entity)meteor);
        }
    }

    private boolean topBlockIsBiomeGeneric(World world, BlockPos pos) {
        if (world == null) {
            return false;
        }
        if ((pos = this.correctYCoord(world, pos)).func_177956_o() < 0) {
            return false;
        }
        Biome biome = world.func_180494_b(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        return (block == Blocks.field_150343_Z || block == biome.field_76752_A.func_177230_c()) && world.func_175710_j(pos.func_177984_a());
    }

    private BlockPos correctYCoord(World world, BlockPos pos) {
        if (world == null) {
            return pos;
        }
        while (pos.func_177956_o() < world.func_72940_L() && world.func_175710_j(pos)) {
            pos = pos.func_177984_a();
        }
        while (world.func_175623_d(pos) && pos.func_177956_o() > -1) {
            pos = pos.func_177977_b();
        }
        return pos;
    }
}

