/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion;

import com.rwtema.funkylocomotion.CreativeTabFrames;
import com.rwtema.funkylocomotion.EntityMovingEventHandler;
import com.rwtema.funkylocomotion.LogHelper;
import com.rwtema.funkylocomotion.Proxy;
import com.rwtema.funkylocomotion.Recipes;
import com.rwtema.funkylocomotion.api.FunkyRegistry;
import com.rwtema.funkylocomotion.api.IMoveCheck;
import com.rwtema.funkylocomotion.asm.WrenchFactory;
import com.rwtema.funkylocomotion.blocks.BlockBooster;
import com.rwtema.funkylocomotion.blocks.BlockFrameProjector;
import com.rwtema.funkylocomotion.blocks.BlockMoving;
import com.rwtema.funkylocomotion.blocks.BlockPusher;
import com.rwtema.funkylocomotion.blocks.BlockSlider;
import com.rwtema.funkylocomotion.blocks.BlockStickyFrame;
import com.rwtema.funkylocomotion.blocks.BlockTeleport;
import com.rwtema.funkylocomotion.blocks.TileBooster;
import com.rwtema.funkylocomotion.blocks.TileFrameProjector;
import com.rwtema.funkylocomotion.blocks.TileMovingServer;
import com.rwtema.funkylocomotion.blocks.TilePusher;
import com.rwtema.funkylocomotion.blocks.TileSlider;
import com.rwtema.funkylocomotion.blocks.TileTeleport;
import com.rwtema.funkylocomotion.compat.CompatHandler;
import com.rwtema.funkylocomotion.compat.FunkyRegistryImpl;
import com.rwtema.funkylocomotion.items.ItemBlockFrame;
import com.rwtema.funkylocomotion.items.ItemBlockPusher;
import com.rwtema.funkylocomotion.items.ItemBlockTeleporter;
import com.rwtema.funkylocomotion.items.ItemWrench;
import com.rwtema.funkylocomotion.movers.MoverEventHandler;
import com.rwtema.funkylocomotion.network.FLNetwork;
import com.rwtema.funkylocomotion.proxydelegates.ProxyRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

@Mod(modid="funkylocomotion", version="1.0", dependencies="after:ThermalExpansion;after:ThermalFoundation;required-after:Forge@[10.13.1.1217,)", acceptedMinecraftVersions="[1.10.2]")
public class FunkyLocomotion {
    public static final String MODID = "funkylocomotion";
    public static final String VERSION = "1.0";
    public static final CreativeTabFrames creativeTabFrames = new CreativeTabFrames();
    public static final BlockStickyFrame[] frame = new BlockStickyFrame[4];
    @SidedProxy(serverSide="com.rwtema.funkylocomotion.Proxy", clientSide="com.rwtema.funkylocomotion.ProxyClient")
    public static Proxy proxy;
    public static ItemWrench wrench;
    public static BlockPusher pusher;
    public static BlockMoving moving;
    public static BlockSlider slider;
    public static BlockBooster booster;
    public static BlockTeleport teleporter;
    public static BlockFrameProjector frameProjector;
    public static boolean redrawChunksInstantly;
    final IMoveCheck BLACKLIST = (worldObj, pos, profile) -> EnumActionResult.FAIL;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        LogHelper.info("Let's Move!", new Object[0]);
        FLNetwork.init();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        TilePusher.maxTiles = config.get("general", "maximumBlocksPushed", 1024).getInt(1024);
        TilePusher.powerPerTile = config.get("general", "energyPerBlock", 250).getInt(250);
        Recipes.shouldAddRecipes = config.get("general", "addRecipes", true).getBoolean(true);
        Recipes.shouldAddFrameCopyResetRecipes = config.get("general", "addFrameCopyResetRecipes", true).getBoolean(true);
        redrawChunksInstantly = config.get("client", "redrawChunksInstantly", true).getBoolean(true);
        if (config.hasChanged()) {
            config.save();
        }
        EntityMovingEventHandler.init();
        MoverEventHandler.init();
        for (int i = 0; i < 4; ++i) {
            BlockStickyFrame.curLoadingIndex = i;
            FunkyLocomotion.frame[i] = new BlockStickyFrame();
            GameRegistry.register((IForgeRegistryEntry)FunkyLocomotion.frame[i]);
            GameRegistry.register((IForgeRegistryEntry)new ItemBlockFrame(frame[i]).setRegistryName(frame[i].getRegistryName()));
        }
        moving = new BlockMoving();
        GameRegistry.register((IForgeRegistryEntry)moving);
        pusher = new BlockPusher();
        pusher.func_149663_c("funkylocomotion:pusher");
        pusher.setRegistryName("funkylocomotion:pusher");
        GameRegistry.register((IForgeRegistryEntry)pusher);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockPusher(pusher).setRegistryName(pusher.getRegistryName()));
        slider = new BlockSlider();
        GameRegistry.register((IForgeRegistryEntry)slider);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)slider).setRegistryName(slider.getRegistryName()));
        teleporter = new BlockTeleport();
        GameRegistry.register((IForgeRegistryEntry)teleporter);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockTeleporter(teleporter).setRegistryName(teleporter.getRegistryName()));
        booster = new BlockBooster();
        GameRegistry.register((IForgeRegistryEntry)booster);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)booster).setRegistryName(booster.getRegistryName()));
        frameProjector = new BlockFrameProjector();
        GameRegistry.register((IForgeRegistryEntry)frameProjector);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)frameProjector).setRegistryName(frameProjector.getRegistryName()));
        wrench = WrenchFactory.makeMeAWrench();
        GameRegistry.register((IForgeRegistryEntry)wrench);
        GameRegistry.registerTileEntity(TileMovingServer.class, (String)"funkylocomotion:tileMover");
        GameRegistry.registerTileEntity(TilePusher.class, (String)"funkylocomotion:tilePusher");
        GameRegistry.registerTileEntity(TileSlider.class, (String)"funkylocomotion:tileSlider");
        GameRegistry.registerTileEntity(TileBooster.class, (String)"funkylocomotion:tileBooster");
        GameRegistry.registerTileEntity(TileTeleport.class, (String)"funkylocomotion:tileTeleporter");
        GameRegistry.registerTileEntity(TileFrameProjector.class, (String)"funkylocomotion:tileFrameProjector");
        proxy.registerRendering();
        CompatHandler.initCompat(event.getAsmData());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        try {
            Class.forName("cofh.api.block.IBlockAppearance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Recipes.addRecipes();
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            if (!"blacklist".equals(msg.key) || !msg.isStringMessage()) continue;
            String s = msg.getStringValue();
            ResourceLocation location = new ResourceLocation(s);
            Block object = (Block)Block.field_149771_c.func_82594_a((Object)location);
            if (object != Blocks.field_150350_a) {
                ProxyRegistry.register(object, IMoveCheck.class, this.BLACKLIST);
                continue;
            }
            try {
                Class<?> aClass = Class.forName(s);
                ProxyRegistry.register(aClass, IMoveCheck.class, this.BLACKLIST);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    static {
        FunkyRegistry.INSTANCE = new FunkyRegistryImpl();
    }
}

