/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.google.common.collect.ImmutableList;
import com.rwtema.funkylocomotion.FunkyLocomotion;
import com.rwtema.funkylocomotion.blocks.BlockFrame;
import com.rwtema.funkylocomotion.helper.ItemHelper;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;

public class BlockStickyFrame
extends BlockFrame {
    public static final BlockStickyFrame[] blocks = new BlockStickyFrame[4];
    public static final PropertyBool[] DIR_OPEN;
    public static final EnumMap<EnumFacing, PropertyBool> DIR_OPEN_MAP;
    public static int curLoadingIndex;
    public int index = curLoadingIndex;

    public BlockStickyFrame() {
        BlockStickyFrame.blocks[this.index] = this;
        this.func_149663_c("funkylocomotion:frame");
        this.setRegistryName("funkylocomotion:frame_" + this.index);
        if (this.index == 0) {
            this.func_149647_a(FunkyLocomotion.creativeTabFrames);
        }
        this.func_149713_g(0);
        for (IBlockState state : this.field_176227_L.func_177619_a()) {
            int metaFromState;
            IBlockState state2;
            Validate.isTrue((state == (state2 = this.func_176203_a(metaFromState = this.func_176201_c(state))) ? 1 : 0) != 0);
        }
    }

    public static boolean isRawMetaSticky(int i, EnumFacing side) {
        return (i & 1 << side.ordinal()) == 0;
    }

    public static int getRawMeta(IBlockState state) {
        int t = 0;
        for (int i = 0; i < DIR_OPEN.length; ++i) {
            if (!((Boolean)state.func_177229_b((IProperty)DIR_OPEN[i])).booleanValue()) continue;
            t |= 1 << i;
        }
        return t;
    }

    public static boolean isStickySide(IBlockState state, EnumFacing side) {
        return BlockStickyFrame.isRawMetaSticky(BlockStickyFrame.getRawMeta(state), side);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int getRawIndex() {
        return this.index * 16;
    }

    @Override
    public boolean isStickySide(World world, BlockPos pos, EnumFacing side) {
        return BlockStickyFrame.isRawMetaSticky(BlockStickyFrame.getRawMeta(world.func_180495_p(pos)), side);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int i = this.getRawIndex() + meta;
        IBlockState state = this.func_176223_P();
        for (int k = 0; k < DIR_OPEN.length; ++k) {
            state = state.func_177226_a((IProperty)DIR_OPEN[k], (Comparable)Boolean.valueOf((i & 1 << k) != 0));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return BlockStickyFrame.getRawMeta(state) & 0xF;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack item = playerIn.func_184586_b(hand);
        if (!ItemHelper.isWrench(item)) {
            return false;
        }
        int i = BlockStickyFrame.getRawMeta(state) ^ 1 << side.ordinal();
        if (i > 63 || i < 0) {
            i = 0;
        }
        int meta = i % 16;
        BlockStickyFrame block = blocks[(i - meta) / 16];
        worldIn.func_180501_a(pos, block.func_176203_a(meta), 2);
        return true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        this.index = curLoadingIndex;
        return new BlockStateContainer(this, new IProperty[]{DIR_OPEN[0], DIR_OPEN[1], DIR_OPEN[2], DIR_OPEN[3], DIR_OPEN[4], DIR_OPEN[5]}){
            final ImmutableList<IBlockState> myValidStates;
            {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (IBlockState state : super.func_177619_a()) {
                    int rawMeta = BlockStickyFrame.getRawMeta(state);
                    if (rawMeta < BlockStickyFrame.this.getRawIndex() || rawMeta >= 16 + BlockStickyFrame.this.getRawIndex()) continue;
                    builder.add((Object)state);
                }
                this.myValidStates = builder.build();
            }

            @Nonnull
            public ImmutableList<IBlockState> func_177619_a() {
                return this.myValidStates;
            }
        };
    }

    public void func_149666_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (this.index == 0) {
            list.add(new ItemStack(itemIn));
        }
    }

    static {
        curLoadingIndex = -1;
        DIR_OPEN_MAP = new EnumMap(EnumFacing.class);
        DIR_OPEN = new PropertyBool[6];
        for (int i = 0; i < EnumFacing.values().length; ++i) {
            EnumFacing facing = EnumFacing.values()[i];
            BlockStickyFrame.DIR_OPEN[i] = PropertyBool.func_177716_a((String)("open_" + facing.func_176610_l().toLowerCase()));
            DIR_OPEN_MAP.put(facing, DIR_OPEN[i]);
        }
    }
}

