/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.mojang.authlib.GameProfile;
import com.rwtema.funkylocomotion.FunkyLocomotion;
import com.rwtema.funkylocomotion.api.FunkyCapabilities;
import com.rwtema.funkylocomotion.api.IAdvStickyBlock;
import com.rwtema.funkylocomotion.api.IStickyBlock;
import com.rwtema.funkylocomotion.blocks.TileBooster;
import com.rwtema.funkylocomotion.blocks.TilePowered;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import com.rwtema.funkylocomotion.movers.IMover;
import com.rwtema.funkylocomotion.movers.MoveManager;
import com.rwtema.funkylocomotion.movers.MoverEventHandler;
import com.rwtema.funkylocomotion.particles.ObstructionHelper;
import com.rwtema.funkylocomotion.proxydelegates.ProxyRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import org.apache.commons.lang3.StringUtils;

public class TilePusher
extends TilePowered
implements IMover,
ITickable {
    public static final int[] moveTime = new int[]{20, 10, 7, 5, 4, 3};
    public static final int COOLDOWN_TIMER = 2;
    public static int maxTiles = 1024;
    public static int powerPerTile = 250;
    public boolean powered;
    @Nullable
    protected GameProfile profile;
    int cooldown = -1;

    public TilePusher() {
        super(maxTiles * powerPerTile);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.cooldown = tag.func_74762_e("cooldown");
        this.powered = tag.func_74767_n("Powered");
        String name = tag.func_74779_i("Name");
        if (tag.func_74764_b("UUIDL")) {
            UUID uuid = new UUID(tag.func_74763_f("UUIDU"), tag.func_74763_f("UUIDL"));
            this.profile = new GameProfile(uuid, name);
        } else {
            this.profile = StringUtils.isBlank((CharSequence)name) ? null : new GameProfile(null, name);
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74757_a("powered", this.powered);
        NBTTagCompound profileTag = new NBTTagCompound();
        if (this.profile != null) {
            profileTag.func_74778_a("Name", this.profile.getName());
            UUID id = this.profile.getId();
            if (id != null) {
                profileTag.func_74772_a("UUIDL", id.getLeastSignificantBits());
                profileTag.func_74772_a("UUIDU", id.getMostSignificantBits());
            }
            tag.func_74782_a("profile", (NBTBase)profileTag);
        }
        return tag;
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public List<BlockPos> getBlocks(World world, BlockPos home, EnumFacing dir, boolean push) {
        if (push) {
            BlockPos advance = home.func_177972_a(dir);
            if (BlockHelper.canStick(world, advance, dir.func_176734_d(), this.profile)) {
                return this.getBlocks(world, home, advance, dir);
            }
        } else {
            BlockPos advance = home.func_177972_a(dir = dir.func_176734_d());
            if (!world.func_175623_d(advance)) {
                return null;
            }
            BlockPos advance2 = advance.func_177972_a(dir);
            if (BlockHelper.canStick(world, advance2, dir.func_176734_d(), this.profile)) {
                return this.getBlocks(world, home, advance2, dir.func_176734_d());
            }
        }
        return null;
    }

    public List<BlockPos> getBlocks(World world, BlockPos home, BlockPos start, EnumFacing moveDir) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        this.getBlockPosIterate(world, home, start, posList, posSet);
        return this.checkPositions(world, moveDir, posList, posSet);
    }

    public List<BlockPos> checkPositions(World world, EnumFacing moveDir, ArrayList<BlockPos> posList, HashSet<BlockPos> posSet) {
        boolean fail = false;
        for (BlockPos pos : posList) {
            BlockPos adv = pos.func_177972_a(moveDir);
            if (posSet.contains(adv) || BlockHelper.canReplace(world, adv)) continue;
            if (!ObstructionHelper.sendObstructionPacket(world, pos, moveDir)) {
                return null;
            }
            fail = true;
        }
        return fail ? null : posList;
    }

    private void getBlockPosIterate(World world, BlockPos home, BlockPos start, ArrayList<BlockPos> posList, HashSet<BlockPos> posSet) {
        LinkedList<BlockPos> toIterate = new LinkedList<BlockPos>();
        HashSet<BlockPos> toIterateSet = new HashSet<BlockPos>();
        toIterate.add(start);
        toIterateSet.add(start);
        while (!toIterate.isEmpty()) {
            BlockPos pos = (BlockPos)toIterate.poll();
            posList.add(pos);
            posSet.add(pos);
            IBlockState state = world.func_180495_p(pos);
            Block b = state.func_177230_c();
            TileEntity tile = world.func_175625_s(pos);
            IAdvStickyBlock advStickyBlock = ProxyRegistry.getInterface(b, IAdvStickyBlock.class, FunkyCapabilities.ADV_STICKY_BLOCK);
            if (tile != null && advStickyBlock == null) {
                advStickyBlock = ProxyRegistry.getInterface(tile, IAdvStickyBlock.class, FunkyCapabilities.ADV_STICKY_BLOCK);
            }
            if (advStickyBlock != null) {
                for (BlockPos blockPos : advStickyBlock.getBlocksToMove(world, pos)) {
                    if (home.equals((Object)blockPos) || toIterateSet.contains(blockPos) || !BlockHelper.isValid(world, blockPos) || !BlockHelper.canMoveBlock(world, blockPos, this.profile)) continue;
                    BlockPos immutableBlockPos = blockPos.func_185334_h();
                    toIterate.add(immutableBlockPos);
                    toIterateSet.add(immutableBlockPos);
                }
                continue;
            }
            IStickyBlock stickyBlock = ProxyRegistry.getInterface(b, IStickyBlock.class, FunkyCapabilities.STICKY_BLOCK);
            if (tile != null && stickyBlock == null) {
                stickyBlock = ProxyRegistry.getInterface(tile, IStickyBlock.class, FunkyCapabilities.STICKY_BLOCK);
            }
            if (stickyBlock == null) continue;
            for (EnumFacing side : EnumFacing.values()) {
                BlockPos newPos;
                if (!stickyBlock.isStickySide(world, pos, side) || home.equals((Object)(newPos = pos.func_177972_a(side))) || toIterateSet.contains(newPos) || !BlockHelper.canStick(world, newPos, side.func_176734_d(), this.profile)) continue;
                toIterate.add(newPos);
                toIterateSet.add(newPos);
            }
        }
    }

    @Override
    public void startMoving() {
        boolean push;
        this.cooldown = -1;
        int meta = this.func_145832_p();
        EnumFacing dir1 = EnumFacing.values()[meta % 6].func_176734_d();
        boolean push1 = meta < 6;
        EnumFacing d2 = push1 ? dir1 : dir1.func_176734_d();
        EnumFacing dir = d2.func_176734_d();
        List<BlockPos> posList = this.getBlocks(this.field_145850_b, this.field_174879_c, dir, push = meta < 6);
        if (posList != null) {
            int energy = posList.size() * powerPerTile;
            if (this.energy.extractEnergy(energy, true) != energy) {
                return;
            }
            ArrayList<TileBooster> boosters = new ArrayList<TileBooster>(6);
            for (EnumFacing d : EnumFacing.values()) {
                TileEntity tile;
                BlockPos p;
                IBlockState state;
                if (d == dir || (state = this.field_145850_b.func_180495_p(p = this.field_174879_c.func_177972_a(d))).func_177230_c() != FunkyLocomotion.booster || state.func_177229_b((IProperty)BlockDirectional.field_176387_N) != d.func_176734_d() || !((tile = BlockHelper.getTile(this.field_145850_b, p)) instanceof TileBooster)) continue;
                TileBooster booster = (TileBooster)tile;
                if (booster.energy.extractEnergy(energy, true) != energy) continue;
                boosters.add(booster);
            }
            if (!boosters.isEmpty()) {
                for (TileBooster booster : boosters) {
                    booster.energy.extractEnergy(energy, false);
                }
            }
            this.energy.extractEnergy(energy, false);
            MoveManager.startMoving(this.field_145850_b, posList, this.getDirection(), moveTime[boosters.size()]);
        }
    }

    @Override
    public boolean stillExists() {
        return !this.field_145846_f && this.field_145850_b != null && this.field_145850_b.func_175667_e(this.field_174879_c) && this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    public void onChunkUnload() {
        this.field_145846_f = true;
    }

    public EnumFacing getDirection() {
        int meta = this.func_145832_p();
        EnumFacing dir = EnumFacing.values()[meta % 6].func_176734_d();
        boolean push = meta < 6;
        return push ? dir.func_176734_d() : dir;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        return super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
            if (this.cooldown == 0) {
                MoverEventHandler.registerMover(this);
            }
        }
    }

    public void startCooldown() {
        if (this.cooldown == -1) {
            this.cooldown = 2;
        }
    }
}

