/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.compound;

import hellfirepvp.astralsorcery.client.effect.compound.CompoundObjectEffect;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class CompoundEffectSphere
extends CompoundObjectEffect {
    private double alphaFadeMaxDist = -1.0;
    private boolean removeIfInvisible = false;
    private List<SolidColorTriangleFace> sphereFaces = new LinkedList<SolidColorTriangleFace>();
    private Vector3 offset;
    private Vector3 axis;

    public CompoundEffectSphere(Vector3 centralPoint, Vector3 southNorthAxis, double sphereRadius, int fractionsSplit, int fractionsCircle) {
        this.offset = centralPoint;
        this.axis = southNorthAxis.clone().normalize().multiply(sphereRadius);
        fractionsSplit = MathHelper.func_76125_a((int)fractionsSplit, (int)2, (int)Integer.MAX_VALUE);
        fractionsCircle = MathHelper.func_76125_a((int)fractionsCircle, (int)3, (int)Integer.MAX_VALUE);
        this.buildFaces(fractionsSplit, fractionsCircle);
    }

    public CompoundEffectSphere setAlphaFadeDistance(double fadeDistance) {
        this.alphaFadeMaxDist = fadeDistance;
        return this;
    }

    public CompoundEffectSphere setRemoveIfInvisible(boolean removeIfInvisible) {
        this.removeIfInvisible = removeIfInvisible;
        return this;
    }

    private void buildFaces(int fractionsSplit, int fractionsCircle) {
        Vector3 centerPerp = this.axis.clone().perpendicular();
        double degSplit = 180.0 / (double)fractionsSplit;
        double degCircleSplit = 360.0 / (double)fractionsCircle;
        double degCircleOffsetShifted = degCircleSplit / 2.0;
        boolean shift = false;
        Object[] prevArray = new Vector3[fractionsCircle];
        Vector3 prev = this.axis.clone();
        Arrays.fill(prevArray, prev.clone());
        for (int i = 1; i <= fractionsSplit; ++i) {
            Vector3 splitVec = this.axis.clone().rotate(Math.toRadians(degSplit * (double)i), centerPerp);
            Vector3[] circlePositions = new Vector3[fractionsCircle];
            for (int j = 0; j < fractionsCircle; ++j) {
                double deg = shift ? degCircleOffsetShifted : 0.0;
                circlePositions[j] = splitVec.clone().rotate(Math.toRadians(deg += degCircleSplit * (double)j), this.axis);
            }
            for (int k = 0; k < fractionsCircle; ++k) {
                int nextIndex;
                int prevIndex;
                int n = prevIndex = shift ? k : k - 1;
                if (prevIndex < 0) {
                    prevIndex = fractionsCircle - 1;
                }
                int n2 = nextIndex = shift ? k + 1 : k;
                if (nextIndex >= fractionsCircle) {
                    nextIndex = 0;
                }
                this.sphereFaces.add(new SolidColorTriangleFace((Vector3)prevArray[prevIndex], (Vector3)prevArray[nextIndex], circlePositions[k]));
                int nextCircle = k + 1;
                if (nextCircle >= fractionsCircle) {
                    nextCircle = 0;
                }
                this.sphereFaces.add(new SolidColorTriangleFace(circlePositions[k], (Vector3)prevArray[nextIndex], circlePositions[nextCircle]));
            }
            prevArray = circlePositions;
            shift = !shift;
        }
    }

    public Vector3 getPosition() {
        return this.offset;
    }

    @Override
    public void render(VertexBuffer vb, float pTicks) {
        RenderingUtils.removeStandartTranslationFromTESRMatrix(pTicks);
        GL11.glTranslated((double)this.offset.getX(), (double)this.offset.getY(), (double)this.offset.getZ());
        float alpha = 1.0f;
        if (this.alphaFadeMaxDist != -1.0 && Minecraft.func_71410_x().field_71439_g != null) {
            Vector3 plVec = new Vector3((Entity)Minecraft.func_71410_x().field_71439_g);
            double dst = plVec.distance(this.getPosition()) - 1.2;
            alpha = (float)((double)alpha * (1.0 - dst / this.alphaFadeMaxDist));
            if (this.removeIfInvisible && alpha <= 0.0f) {
                this.requestRemoval();
            }
            alpha = MathHelper.func_76131_a((float)alpha, (float)0.0f, (float)1.0f);
        }
        for (SolidColorTriangleFace face : this.sphereFaces) {
            vb.func_181662_b(face.v1.getX(), face.v1.getY(), face.v1.getZ()).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            vb.func_181662_b(face.v2.getX(), face.v2.getY(), face.v2.getZ()).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
            vb.func_181662_b(face.v3.getX(), face.v3.getY(), face.v3.getZ()).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181675_d();
        }
    }

    @Override
    public CompoundObjectEffect.ObjectGroup getGroup() {
        return CompoundObjectEffect.ObjectGroup.SOLID_COLOR_SPHERE;
    }

    @Override
    public void tick() {
        if (this.alphaFadeMaxDist == -1.0 || !this.removeIfInvisible) {
            super.tick();
        }
    }

    public static class SolidColorTriangleFace {
        private Vector3 v1;
        private Vector3 v2;
        private Vector3 v3;

        public SolidColorTriangleFace(Vector3 v1, Vector3 v2, Vector3 v3) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
        }
    }
}

