/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.light;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class EffectLightning
extends EntityComplexFX {
    private static final BindableResource connection = AssetLibrary.loadTexture(AssetLoader.TextureLocation.EFFECT, "connectionPerks");
    private static Random rand = new Random();
    private static final float optimalLightningLength = 7.0f;
    private static final float growSpeed = 0.09f;
    private static final float fadeTime = 0.03f;
    private static final float defaultMinJitterDst = 0.2f;
    private static final float defaultMaxJitterDst = 0.7f;
    private static final float defaultForkChance = 1.0f;
    private static final float defaultMinForkAngleDeg = 15.0f;
    private static final float defaultMaxForkAngleDeg = 35.0f;
    private final LightningVertex root;
    private float buildSpeed = 0.2f;
    private float buildWaitTime = 0.01f;
    private float bufRenderDepth = -1.0f;
    private float ovR = 0.6509804f;
    private float ovG = 0.6509804f;
    private float ovB = 0.8039216f;

    private EffectLightning(LightningVertex rootVertex) {
        this.root = rootVertex;
    }

    public EffectLightning setBuildSpeed(float buildSpeed) {
        this.buildSpeed = buildSpeed;
        return this;
    }

    public EffectLightning setBuildWaitTime(float buildWaitTime) {
        this.buildWaitTime = buildWaitTime;
        return this;
    }

    public EffectLightning setOverlayColor(Color color) {
        this.ovR = (float)color.getRed() / 255.0f;
        this.ovG = (float)color.getGreen() / 255.0f;
        this.ovB = (float)color.getBlue() / 255.0f;
        return this;
    }

    public EffectLightning finalizeAndRegister() {
        this.root.calcDepthRec();
        EffectHandler.getInstance().registerFX(this);
        return this;
    }

    public static EffectLightning buildAndRegisterLightning(Vector3 source, Vector3 destination) {
        double dstLength = destination.clone().subtract(source).length();
        float perc = 1.0f;
        if (dstLength > 7.0) {
            perc = MathHelper.func_76133_a((double)(dstLength / 7.0));
        } else if (dstLength < 7.0) {
            perc = (float)Math.pow(dstLength / 7.0, 2.0);
        }
        EffectLightning lightning = EffectLightning.buildLightning(rand.nextLong(), source, destination, 0.2f * perc, 0.7f * perc, 1.0f, 15.0f, 35.0f);
        lightning.setBuildSpeed(Math.max(0.01f, 0.09f * perc));
        lightning.setBuildWaitTime(Math.max(0.0067f, 0.03f * perc));
        lightning.finalizeAndRegister();
        return lightning;
    }

    public static EffectLightning buildLightning(long seed, Vector3 source, Vector3 destination, float minJitterDistance, float maxJitterDistance, float forkChance, float minForkAngle, float maxForkAngle) {
        Vector3 directionVector = destination.clone().subtract(source);
        Random lightningSeed = new Random(seed);
        LinkedList<LightningVertex> rootVertices = Lists.newLinkedList();
        LightningVertex root = new LightningVertex(source);
        root.next.add(new LightningVertex(destination));
        rootVertices.add(root);
        double l = directionVector.length();
        int iterations = MathHelper.func_76141_d((float)Math.round(Math.sqrt(l)));
        for (int i = 0; i < iterations; ++i) {
            LinkedList<LightningVertex> newRootVertices = new LinkedList<LightningVertex>();
            for (LightningVertex sourceVertex : rootVertices) {
                LinkedList<LightningVertex> newNext = new LinkedList<LightningVertex>();
                for (LightningVertex nextVertex : Lists.newArrayList((Iterable)sourceVertex.next)) {
                    Vector3 direction = nextVertex.offset.clone().subtract(sourceVertex.offset);
                    Vector3 split = direction.clone().multiply(0.5f).add(sourceVertex.offset);
                    float jitDst = (minJitterDistance + (maxJitterDistance - minJitterDistance) * lightningSeed.nextFloat()) * ((float)(iterations - i) / (float)iterations);
                    Vector3 axPerp = direction.clone().perpendicular().rotate((double)(lightningSeed.nextFloat() * 2.0f) * Math.PI, direction).normalize().multiply(jitDst);
                    split.add(axPerp);
                    LightningVertex newVertex = new LightningVertex(split);
                    newVertex.next.add(nextVertex);
                    newNext.add(newVertex);
                    if (lightningSeed.nextFloat() < forkChance) {
                        Vector3 dirFork = split.clone().subtract(sourceVertex.offset);
                        float forkAngle = minForkAngle + (maxForkAngle - minForkAngle) * lightningSeed.nextFloat();
                        forkAngle = (float)Math.toRadians(forkAngle);
                        Vector3 perpAxis = dirFork.clone().perpendicular().rotate((double)(lightningSeed.nextFloat() * 2.0f) * Math.PI, dirFork);
                        Vector3 dirPos = dirFork.clone().rotate(forkAngle, perpAxis).normalize().multiply(dirFork.length() * 3.0 / 4.0).add(split);
                        LightningVertex forkVertex = new LightningVertex(dirPos);
                        newVertex.next.add(forkVertex);
                    }
                    newRootVertices.add(newVertex);
                }
                sourceVertex.next = newNext;
                newRootVertices.add(sourceVertex);
            }
            rootVertices = newRootVertices;
        }
        return new EffectLightning(root);
    }

    public static void renderFast(float pTicks, List<EffectLightning> toBeRendered) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        RenderingUtils.removeStandartTranslationFromTESRMatrix(pTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3008);
        Blending.ADDITIVE_ALPHA.apply();
        connection.bind();
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer buf = tes.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (EffectLightning fl : new ArrayList<EffectLightning>(toBeRendered)) {
            fl.renderF(pTicks, buf);
        }
        buf.func_181674_a((float)TileEntityRendererDispatcher.field_147554_b, (float)TileEntityRendererDispatcher.field_147555_c, (float)TileEntityRendererDispatcher.field_147552_d);
        tes.func_78381_a();
        TextureHelper.refreshTextureBindState();
        Blending.DEFAULT.apply();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderF(float partialTicks, VertexBuffer vb) {
        this.bufRenderDepth = Math.min(1.0f, ((float)this.age + partialTicks) / (this.buildSpeed * 20.0f));
        this.renderRec(this.root, vb);
    }

    private void renderRec(LightningVertex root, VertexBuffer vb) {
        int allDepth = this.root.followingDepth;
        boolean mayRenderNext = 1.0f - (float)root.followingDepth / (float)allDepth <= this.bufRenderDepth;
        for (LightningVertex next : root.next) {
            this.drawLine(root.offset, next.offset, vb);
            if (!mayRenderNext) continue;
            this.renderRec(next, vb);
        }
    }

    private void drawLine(Vector3 from, Vector3 to, VertexBuffer vb) {
        this.renderCurrentTextureAroundAxis(from, to, Math.toRadians(0.0), 0.05f, vb);
        this.renderCurrentTextureAroundAxis(from, to, Math.toRadians(90.0), 0.05f, vb);
    }

    private void renderCurrentTextureAroundAxis(Vector3 from, Vector3 to, double angle, double size, VertexBuffer buf) {
        Vector3 aim = to.clone().subtract(from).normalize();
        Vector3 aimPerp = aim.clone().perpendicular().normalize();
        Vector3 perp = aimPerp.clone().rotate(angle, aim).normalize();
        Vector3 perpFrom = perp.clone().multiply(size);
        Vector3 perpTo = perp.multiply(size);
        Vector3 vec = from.clone().add(perpFrom.clone().multiply(-1));
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(1.0, 1.0).func_181666_a(this.ovR, this.ovG, this.ovB, 1.0f).func_181675_d();
        vec = from.clone().add(perpFrom);
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(1.0, 0.0).func_181666_a(this.ovR, this.ovG, this.ovB, 1.0f).func_181675_d();
        vec = to.clone().add(perpTo);
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(0.0, 0.0).func_181666_a(this.ovR, this.ovG, this.ovB, 1.0f).func_181675_d();
        vec = to.clone().add(perpTo.clone().multiply(-1));
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(0.0, 1.0).func_181666_a(this.ovR, this.ovG, this.ovB, 1.0f).func_181675_d();
    }

    @Override
    public boolean canRemove() {
        return Math.max((this.buildSpeed + this.buildWaitTime) * 20.0f, 1.0f) < (float)this.age;
    }

    @Override
    public void render(float pTicks) {
    }

    @Override
    public void tick() {
        super.tick();
    }

    private static class LightningVertex {
        private Vector3 offset;
        private List<LightningVertex> next = new LinkedList<LightningVertex>();
        private int followingDepth = -1;

        private LightningVertex(Vector3 offset) {
            this.offset = offset;
        }

        public void calcDepthRec() {
            if (this.next.isEmpty()) {
                this.followingDepth = 0;
            } else {
                for (LightningVertex vertex : this.next) {
                    vertex.calcDepthRec();
                }
                this.followingDepth = MiscUtils.getMaxEntry(this.next, v -> v.followingDepth) + 1;
            }
        }
    }
}

