/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.GuiJournalConstellationDetails;
import hellfirepvp.astralsorcery.client.gui.GuiJournalPerkMap;
import hellfirepvp.astralsorcery.client.gui.GuiJournalProgression;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiJournalConstellationCluster
extends GuiScreenJournal {
    private static final BindableResource texArrow = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiJArrow");
    private static final int width = 80;
    private static final int height = 110;
    private static final Map<Integer, Point> offsetMap = new HashMap<Integer, Point>();
    private List<IConstellation> constellations;
    private String unlocTitle;
    private int pageId = 0;
    private Map<Rectangle, IConstellation> rectCRenderMap = new HashMap<Rectangle, IConstellation>();
    private Rectangle rectBack;
    private Rectangle rectPrev;
    private Rectangle rectNext;

    public GuiJournalConstellationCluster(int bookmark, int pageId, String unlocTitle, List<IConstellation> constellations) {
        this(bookmark, unlocTitle, constellations);
        this.pageId = pageId;
    }

    public GuiJournalConstellationCluster(int bookmark, String unlocTitle, List<IConstellation> constellations) {
        super(bookmark);
        this.unlocTitle = unlocTitle;
        this.constellations = constellations;
    }

    public static GuiScreenJournal getConstellationScreen() {
        PlayerProgress client = ResearchManager.clientProgress;
        List<IConstellation> constellations = ConstellationRegistry.resolve(client.getSeenConstellations());
        return new GuiJournalConstellationCluster(1, "no.title", constellations);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        this.drawDefault(textureResBlank);
        this.field_73735_i += 250.0f;
        this.drawNavArrows(partialTicks);
        this.drawTitle();
        this.rectCRenderMap.clear();
        this.drawConstellations();
        this.field_73735_i -= 250.0f;
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void drawConstellations() {
        Point mouse = this.getCurrentMousePoint();
        List<IConstellation> cs = this.constellations.subList(this.pageId * 6, Math.min((this.pageId + 1) * 6, this.constellations.size()));
        for (int i = 0; i < cs.size(); ++i) {
            IConstellation c = cs.get(i);
            Point p = offsetMap.get(i);
            this.rectCRenderMap.put(GuiJournalConstellationCluster.drawConstellationRect(c, this.guiLeft + p.x, this.guiTop + p.y, this.field_73735_i, mouse, null), c);
        }
    }

    private void drawTitle() {
        if (this.unlocTitle != null) {
            // empty if block
        }
    }

    private void drawNavArrows(float partialTicks) {
        float sin;
        double t;
        float uFrom;
        int width;
        Point mouse = this.getCurrentMousePoint();
        int cIndex = this.pageId * 6;
        this.rectBack = null;
        this.rectNext = null;
        this.rectPrev = null;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (cIndex > 0) {
            int width2 = 30;
            int height = 15;
            this.rectPrev = new Rectangle(this.guiLeft + 15, this.guiTop + 127, width2, height);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.rectPrev.getX() + (double)(width2 / 2)), (double)(this.rectPrev.getY() + (double)(height / 2)), (double)0.0);
            float uFrom2 = 0.0f;
            float vFrom = 0.5f;
            if (this.rectPrev.contains(mouse)) {
                uFrom2 = 0.5f;
                GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
            } else {
                double t2 = (float)ClientScheduler.getClientTick() + partialTicks;
                float sin2 = (float)Math.sin(t2 / 4.0) / 32.0f + 1.0f;
                GL11.glScaled((double)sin2, (double)sin2, (double)sin2);
            }
            GL11.glTranslated((double)(-(width2 / 2)), (double)(-(height / 2)), (double)0.0);
            texArrow.bind();
            this.drawTexturedRectAtCurrentPos(width2, height, uFrom2, vFrom, 0.5f, 0.5f);
            GL11.glPopMatrix();
            TextureHelper.refreshTextureBindState();
        }
        int nextIndex = cIndex + 6;
        if (this.constellations.size() >= nextIndex + 1) {
            width = 30;
            int height = 15;
            this.rectNext = new Rectangle(this.guiLeft + 367, this.guiTop + 125, width, height);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.rectNext.getX() + (double)(width / 2)), (double)(this.rectNext.getY() + (double)(height / 2)), (double)0.0);
            uFrom = 0.0f;
            float vFrom = 0.0f;
            if (this.rectNext.contains(mouse)) {
                uFrom = 0.5f;
                GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
            } else {
                t = (float)ClientScheduler.getClientTick() + partialTicks;
                sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
                GL11.glScaled((double)sin, (double)sin, (double)sin);
            }
            GL11.glTranslated((double)(-(width / 2)), (double)(-(height / 2)), (double)0.0);
            texArrow.bind();
            this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
            GL11.glPopMatrix();
            TextureHelper.refreshTextureBindState();
        }
        if (this.bookmarkIndex != 1) {
            width = 30;
            int height = 15;
            this.rectBack = new Rectangle(this.guiLeft + 197, this.guiTop + 230, width, height);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.rectBack.getX() + (double)(width / 2)), (double)(this.rectBack.getY() + (double)(height / 2)), (double)0.0);
            uFrom = 0.0f;
            float vFrom = 0.5f;
            if (this.rectBack.contains(mouse)) {
                uFrom = 0.5f;
                GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
            } else {
                t = (float)ClientScheduler.getClientTick() + partialTicks;
                sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
                GL11.glScaled((double)sin, (double)sin, (double)sin);
            }
            GL11.glTranslated((double)(-(width / 2)), (double)(-(height / 2)), (double)0.0);
            texArrow.bind();
            this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
            GL11.glPopMatrix();
            TextureHelper.refreshTextureBindState();
        }
    }

    protected static Rectangle drawConstellationRect(IConstellation display, double offsetX, double offsetY, float zLevel, Point mouse, @Nullable String specTitle) {
        Rectangle rect = new Rectangle(MathHelper.func_76128_c((double)offsetX), MathHelper.func_76128_c((double)offsetY), 80, 110);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glTranslated((double)(offsetX + 40.0), (double)(offsetY + 40.0), (double)zLevel);
        if (rect.contains(mouse)) {
            GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
        }
        GL11.glTranslated((double)-40.0, (double)-40.0, (double)zLevel);
        Color c = new Color(0xDDDDDD);
        float r = 0.8666667f;
        float g = 0.8666667f;
        float b = 0.8666667f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        RenderConstellation.renderConstellationIntoGUI(c, display, 0, 0, 0.0f, 80, 80, 2.5, new RenderConstellation.BrightnessFunction(){

            @Override
            public float getBrightness() {
                return 0.15f;
            }
        }, true, false);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        TextureHelper.refreshTextureBindState();
        String trName = specTitle == null ? I18n.func_135052_a((String)display.getUnlocalizedName(), (Object[])new Object[0]).toUpperCase() : I18n.func_135052_a((String)specTitle, (Object[])new Object[0]).toUpperCase();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        float fullLength = 40.0f - (float)fr.func_78256_a(trName) / 2.0f;
        fr.func_175065_a(trName, fullLength, 75.0f, -1143087651, true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        return rect;
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        Point p = new Point(mouseX, mouseY);
        if (this.rectResearchBookmark != null && this.rectResearchBookmark.contains(p)) {
            GuiJournalProgression.resetJournal();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalProgression.getJournalInstance());
            return;
        }
        if (this.rectPerkMapBookmark != null && this.rectPerkMapBookmark.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalPerkMap());
            return;
        }
        if (this.bookmarkIndex == -1 && this.rectConstellationBookmark != null && this.rectConstellationBookmark.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalConstellationCluster.getConstellationScreen());
            return;
        }
        for (Rectangle r : this.rectCRenderMap.keySet()) {
            if (!r.contains(p)) continue;
            IConstellation c = this.rectCRenderMap.get(r);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalConstellationDetails(this, c));
        }
        if (this.rectBack != null && this.rectBack.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalConstellationCluster.getConstellationScreen());
            return;
        }
        if (this.rectPrev != null && this.rectPrev.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalConstellationCluster(this.bookmarkIndex, this.pageId - 1, this.unlocTitle, this.constellations));
            return;
        }
        if (this.rectNext != null && this.rectNext.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalConstellationCluster(this.bookmarkIndex, this.pageId + 1, this.unlocTitle, this.constellations));
        }
    }

    static {
        offsetMap.put(0, new Point(30, 20));
        offsetMap.put(1, new Point(30, 140));
        offsetMap.put(2, new Point(120, 80));
        offsetMap.put(3, new Point(310, 20));
        offsetMap.put(4, new Point(220, 100));
        offsetMap.put(5, new Point(310, 140));
    }
}

