/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.GuiJournalConstellationCluster;
import hellfirepvp.astralsorcery.client.gui.GuiJournalPerkMap;
import hellfirepvp.astralsorcery.client.gui.GuiJournalProgression;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.MoonPhaseRenderHelper;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellationSpecialShowup;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.MoonPhase;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class GuiJournalConstellationDetails
extends GuiScreenJournal {
    private static final BindableResource texArrow = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiJArrow");
    private IConstellation constellation;
    private GuiJournalConstellationCluster origin;
    private boolean detailed;
    private Rectangle rectBack;
    private List<MoonPhase> phases = new LinkedList<MoonPhase>();
    private List<String> locText = new LinkedList<String>();

    public GuiJournalConstellationDetails(GuiJournalConstellationCluster origin, IConstellation c) {
        super(-1);
        this.origin = origin;
        this.constellation = c;
        boolean has = false;
        for (String strConstellation : ResearchManager.clientProgress.getKnownConstellations()) {
            IConstellation ce = ConstellationRegistry.getConstellationByName(strConstellation);
            if (ce == null || !ce.equals(c)) continue;
            has = true;
            break;
        }
        this.detailed = has;
        this.testPhases();
        this.buildLines();
    }

    private void buildLines() {
        String text;
        String unloc = this.constellation.getUnlocalizedName() + ".effect";
        if (unloc.equals(text = I18n.func_135052_a((String)unloc, (Object[])new Object[0]))) {
            return;
        }
        LinkedList<String> lines = new LinkedList<String>();
        for (String segment : text.split("<NL>")) {
            lines.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(segment, 180));
            lines.add("");
        }
        this.locText.addAll(lines);
    }

    private void testPhases() {
        if (this.constellation instanceof IWeakConstellation) {
            Collections.addAll(this.phases, MoonPhase.values());
        } else if (this.constellation instanceof IMinorConstellation) {
            for (MoonPhase ph : MoonPhase.values()) {
                if (!((IMinorConstellation)this.constellation).getShowupMoonPhases().contains((Object)ph)) continue;
                this.phases.add(ph);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        this.drawDefault(textureResBlank);
        this.field_73735_i += 150.0f;
        this.drawBackArrow(partialTicks);
        this.drawConstellation();
        this.drawPhaseInformation();
        this.drawExtendedInformation();
        this.field_73735_i -= 150.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void drawExtendedInformation() {
        float br = 0.8666f;
        GL11.glColor4f((float)br, (float)br, (float)br, (float)0.8f);
        String info = I18n.func_135052_a((String)this.constellation.getUnlocalizedInfo(), (Object[])new Object[0]).toUpperCase();
        info = this.detailed ? info : "???";
        TextureHelper.refreshTextureBindState();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        double width = fr.func_78256_a(info);
        double chX = 305.0 - width * 1.8 / 2.0;
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glTranslated((double)((double)this.guiLeft + chX), (double)(this.guiTop + 26), (double)0.0);
        GL11.glScaled((double)1.8, (double)1.8, (double)1.8);
        fr.func_175065_a(info, 0.0f, 0.0f, -857874979, true);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)br, (float)br, (float)br, (float)0.8f);
        TextureHelper.refreshTextureBindState();
        if (this.detailed && !this.locText.isEmpty()) {
            int offsetX = 220;
            int offsetY = 70;
            for (String s : this.locText) {
                GL11.glPushMatrix();
                GL11.glDisable((int)2929);
                GL11.glTranslated((double)(this.guiLeft + offsetX), (double)(this.guiTop + offsetY), (double)0.0);
                fr.func_175065_a(s, 0.0f, 0.0f, -857874979, true);
                GL11.glEnable((int)2929);
                GL11.glPopMatrix();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glColor4f((float)br, (float)br, (float)br, (float)0.8f);
                TextureHelper.refreshTextureBindState();
                offsetY += 13;
            }
        }
    }

    private void drawPhaseInformation() {
        if (this.constellation instanceof IConstellationSpecialShowup) {
            GL11.glDisable((int)2929);
            double scale = 1.8;
            TextureHelper.refreshTextureBindState();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            double length = (double)fr.func_78256_a("? ? ?") * scale;
            double offsetLeft = (double)(this.guiLeft + 296) - length / 2.0;
            int offsetTop = this.guiTop + 199;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(offsetLeft + 10.0), (double)offsetTop, (double)0.0);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            fr.func_175063_a("? ? ?", 0.0f, 0.0f, -857874979);
            GL11.glPopMatrix();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureHelper.refreshTextureBindState();
            GL11.glEnable((int)2929);
        } else {
            GL11.glEnable((int)3042);
            Blending.DEFAULT.apply();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int size = 19;
            int offsetX = 95 + this.field_146294_l / 2 - this.phases.size() * (size + 2) / 2;
            int offsetY = 199 + this.guiTop;
            for (int i = 0; i < this.phases.size(); ++i) {
                MoonPhase ph = this.phases.get(i);
                MoonPhaseRenderHelper.getMoonPhaseTexture(ph).bind();
                this.drawRect(offsetX + i * (size + 2), offsetY, size, size);
            }
        }
    }

    private void drawConstellation() {
        float br = 0.866f;
        GL11.glColor4f((float)br, (float)br, (float)br, (float)0.8f);
        String name = I18n.func_135052_a((String)this.constellation.getUnlocalizedName(), (Object[])new Object[0]).toUpperCase();
        TextureHelper.refreshTextureBindState();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        double width = fr.func_78256_a(name);
        double offsetX = 110.0 - width * 1.8 / 2.0;
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glTranslated((double)((double)this.guiLeft + offsetX), (double)(this.guiTop + 26), (double)0.0);
        GL11.glScaled((double)1.8, (double)1.8, (double)1.8);
        fr.func_175065_a(name, 0.0f, 0.0f, -857874979, true);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)br, (float)br, (float)br, (float)0.8f);
        TextureHelper.refreshTextureBindState();
        String dstInfo = "astralsorcery.journal.constellation.dst.";
        dstInfo = this.constellation instanceof IMajorConstellation ? dstInfo + "major" : (this.constellation instanceof IWeakConstellation ? dstInfo + "weak" : dstInfo + "minor");
        dstInfo = I18n.func_135052_a((String)dstInfo, (Object[])new Object[0]);
        if (!this.detailed) {
            dstInfo = "???";
        }
        width = fr.func_78256_a(dstInfo);
        offsetX = 110.0 - width * 1.25 / 2.0;
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glTranslated((double)((double)this.guiLeft + offsetX), (double)(this.guiTop + 46), (double)0.0);
        GL11.glScaled((double)1.25, (double)1.25, (double)1.25);
        fr.func_175065_a(dstInfo, 0.0f, 0.0f, -857874979, true);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)br, (float)br, (float)br, (float)0.8f);
        TextureHelper.refreshTextureBindState();
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        RenderConstellation.renderConstellationIntoGUI(new Color(0xDDDDDD), this.constellation, this.guiLeft + 25, this.guiTop + 60, this.field_73735_i, 170, 170, 2.0, new RenderConstellation.BrightnessFunction(){

            @Override
            public float getBrightness() {
                return 0.5f;
            }
        }, true, false);
    }

    private void drawBackArrow(float partialTicks) {
        Point mouse = this.getCurrentMousePoint();
        int width = 30;
        int height = 15;
        this.rectBack = new Rectangle(this.guiLeft + 197, this.guiTop + 230, width, height);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.rectBack.getX() + (double)(width / 2)), (double)(this.rectBack.getY() + (double)(height / 2)), (double)0.0);
        float uFrom = 0.0f;
        float vFrom = 0.5f;
        if (this.rectBack.contains(mouse)) {
            uFrom = 0.5f;
            GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
        } else {
            double t = (float)ClientScheduler.getClientTick() + partialTicks;
            float sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
            GL11.glScaled((double)sin, (double)sin, (double)sin);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GL11.glTranslated((double)(-(width / 2)), (double)(-(height / 2)), (double)0.0);
        texArrow.bind();
        this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
        GL11.glPopMatrix();
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        Point p = new Point(mouseX, mouseY);
        if (this.rectResearchBookmark != null && this.rectResearchBookmark.contains(p)) {
            GuiJournalProgression.resetJournal();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalProgression.getJournalInstance());
            return;
        }
        if (this.rectConstellationBookmark != null && this.rectConstellationBookmark.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalConstellationCluster.getConstellationScreen());
            return;
        }
        if (this.rectPerkMapBookmark != null && this.rectPerkMapBookmark.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalPerkMap());
            return;
        }
        if (this.rectBack != null && this.rectBack.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this.origin);
        }
    }
}

