/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.base.GuiTileBase;
import hellfirepvp.astralsorcery.client.sky.RenderAstralSkybox;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktDiscoverConstellation;
import hellfirepvp.astralsorcery.common.network.packet.client.PktRotateTelescope;
import hellfirepvp.astralsorcery.common.tile.TileTelescope;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiTelescope
extends GuiTileBase<TileTelescope> {
    private static final BindableResource texArrow = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiJArrow");
    private static final BindableResource textureGrid = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "gridTelescope");
    private static final BindableResource textureConnection = AssetLibrary.loadTexture(AssetLoader.TextureLocation.EFFECT, "connectionPerks");
    private final EntityPlayer owningPlayer;
    private final TileTelescope guiOwner;
    private TileTelescope.TelescopeRotation rotation;
    private Rectangle rectArrowCW = null;
    private Rectangle rectArrowCCW = null;
    private SkyConstellationDistribution currentInformation = null;
    private static final float THRESHOLD_TO_START = 0.8f;
    private static final float THRESHOLD_TO_SHIFT_BLUEGRAD = 0.5f;
    private static final float THRESHOLD_TO_MAX_BLUEGRAD = 0.2f;
    private static final float THRESHOLD_FROM_START = 1.0f;
    private static final float THRESHOLD_FROM_SHIFT_BLUEGRAD = 0.6f;
    private static final float THRESHOLD_FROM_MAX_BLUEGRAD = 0.3f;
    private LinkedList<Line> drawnLines = new LinkedList();
    private Point start;
    private Point end;

    public GuiTelescope(EntityPlayer player, TileTelescope e) {
        super(e, 280, 280);
        this.owningPlayer = player;
        this.guiOwner = e;
        this.rotation = e.getRotation();
        this.setupConstellations();
    }

    private void setupConstellations() {
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(this.guiOwner.func_145831_w());
        int lastTracked = handle == null ? 5 : handle.lastRecordedDay;
        Random r = new Random(this.guiOwner.func_145831_w().func_72905_C() * 31L + (long)(lastTracked * 31));
        this.currentInformation = new SkyConstellationDistribution();
        for (TileTelescope.TelescopeRotation rot : TileTelescope.TelescopeRotation.values()) {
            this.currentInformation.informationMap.put(rot, new RotationConstellationInformation());
        }
        if (handle != null) {
            List<IConstellation> constellations = handle.getActiveConstellations();
            LinkedList<IWeakConstellation> weakConstellations = new LinkedList<IWeakConstellation>();
            for (IConstellation c : constellations) {
                if (!(c instanceof IWeakConstellation) || !c.canDiscover(ResearchManager.clientProgress)) continue;
                weakConstellations.add((IWeakConstellation)c);
            }
            for (IWeakConstellation cst : weakConstellations) {
                Tuple<Point, TileTelescope.TelescopeRotation> foundPoint;
                while ((foundPoint = this.findEmptyPlace(r)) == null) {
                }
                ((RotationConstellationInformation)this.currentInformation.informationMap.get(foundPoint.value)).constellations.put(foundPoint.key, cst);
            }
        }
    }

    private Tuple<Point, TileTelescope.TelescopeRotation> findEmptyPlace(Random rand) {
        TileTelescope.TelescopeRotation rot = TileTelescope.TelescopeRotation.values()[rand.nextInt(TileTelescope.TelescopeRotation.values().length)];
        RotationConstellationInformation info = (RotationConstellationInformation)this.currentInformation.informationMap.get((Object)rot);
        int wh = 150;
        int wdh = this.guiWidth - 6 - wh;
        int hgt = this.guiHeight - 6 - wh;
        int rX = 6 + rand.nextInt(wdh);
        int rY = 6 + rand.nextInt(hgt);
        Rectangle constellationRect = new Rectangle(rX, rY, wh, wh);
        for (Point p : info.constellations.keySet()) {
            Rectangle otherRect = new Rectangle(p.x, p.y, wh, wh);
            if (!otherRect.intersects(constellationRect)) continue;
            return null;
        }
        return new Tuple<Point, TileTelescope.TelescopeRotation>(new Point(rX, rY), rot);
    }

    public void handleRotationChange(boolean isClockwise) {
        this.rotation = isClockwise ? this.rotation.nextClockWise() : this.rotation.nextCounterClockWise();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        this.drawWHRect(textureGrid);
        TextureHelper.refreshTextureBindState();
        this.field_73735_i -= 5.0f;
        this.drawCellsWithEffects(partialTicks);
        this.field_73735_i += 5.0f;
        this.drawRotationArrows(partialTicks);
        TextureHelper.refreshTextureBindState();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void drawRotationArrows(float partialTicks) {
        float sin;
        double t;
        GL11.glDisable((int)2929);
        Point mouse = this.getCurrentMousePoint();
        this.rectArrowCW = null;
        this.rectArrowCCW = null;
        int width = 30;
        int height = 15;
        this.rectArrowCCW = new Rectangle(this.guiLeft - 40, this.guiTop + this.guiHeight / 2, width, height);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.rectArrowCCW.getX() + (double)(width / 2)), (double)(this.rectArrowCCW.getY() + (double)(height / 2)), (double)0.0);
        float uFrom = 0.0f;
        float vFrom = 0.5f;
        if (this.rectArrowCCW.contains(mouse)) {
            uFrom = 0.5f;
            GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
        } else {
            t = (float)ClientScheduler.getClientTick() + partialTicks;
            sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
            GL11.glScaled((double)sin, (double)sin, (double)sin);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GL11.glTranslated((double)(-(width / 2)), (double)(-(height / 2)), (double)0.0);
        texArrow.bind();
        this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
        GL11.glPopMatrix();
        this.rectArrowCW = new Rectangle(this.guiLeft + this.guiWidth + 10, this.guiTop + this.guiHeight / 2, width, height);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.rectArrowCW.getX() + (double)(width / 2)), (double)(this.rectArrowCW.getY() + (double)(height / 2)), (double)0.0);
        uFrom = 0.0f;
        vFrom = 0.0f;
        if (this.rectArrowCW.contains(mouse)) {
            uFrom = 0.5f;
            GL11.glScaled((double)1.1, (double)1.1, (double)1.1);
        } else {
            t = (float)ClientScheduler.getClientTick() + partialTicks;
            sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
            GL11.glScaled((double)sin, (double)sin, (double)sin);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GL11.glTranslated((double)(-(width / 2)), (double)(-(height / 2)), (double)0.0);
        texArrow.bind();
        this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
    }

    private void drawCellsWithEffects(final float partialTicks) {
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(this.guiOwner.func_145831_w());
        int lastTracked = handle == null ? 5 : handle.lastRecordedDay;
        final Random r = new Random(this.guiOwner.func_145831_w().func_72905_C() * 31L + (long)(lastTracked * 31) + (long)this.rotation.ordinal());
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        boolean canSeeSky = this.canTelescopeSeeSky((World)world);
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        this.drawGridBackground(partialTicks, canSeeSky);
        if (handle != null && canSeeSky) {
            this.field_73735_i += 1.0f;
            GL11.glPushAttrib((int)1048575);
            GL11.glEnable((int)3042);
            Blending.DEFAULT.apply();
            RenderAstralSkybox.TEX_STAR_1.bind();
            float starSize = 2.5f;
            for (int i = 0; i < 72 + r.nextInt(144); ++i) {
                float innerOffsetX = starSize + (float)r.nextInt(MathHelper.func_76141_d((float)((float)this.guiWidth - starSize)));
                float innerOffsetY = starSize + (float)r.nextInt(MathHelper.func_76141_d((float)((float)this.guiHeight - starSize)));
                float brightness = 0.3f + RenderConstellation.stdFlicker(ClientScheduler.getClientTick(), partialTicks, 10 + r.nextInt(20)) * 0.6f;
                GL11.glColor4f((float)(brightness *= Minecraft.func_71410_x().field_71441_e.func_72880_h(1.0f) * 2.0f), (float)brightness, (float)brightness, (float)brightness);
                this.drawRectDetailed((float)this.guiLeft + innerOffsetX - starSize, (float)this.guiTop + innerOffsetY - starSize, starSize * 2.0f, starSize * 2.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.field_73735_i -= 1.0f;
            RotationConstellationInformation info = (RotationConstellationInformation)this.currentInformation.informationMap.get((Object)this.rotation);
            if (info != null) {
                ((RotationConstellationInformation)this.currentInformation.informationMap.get((Object)this.rotation)).informations.clear();
                for (Map.Entry entry : info.constellations.entrySet()) {
                    float widthHeight = 150.0f;
                    Point offset = (Point)entry.getKey();
                    Map<StarLocation, Rectangle> rectangles = RenderConstellation.renderConstellationIntoGUI((IConstellation)entry.getValue(), offset.x + this.guiLeft, offset.y + this.guiTop, this.field_73735_i, (int)widthHeight, (int)widthHeight, 2.5, new RenderConstellation.BrightnessFunction(){

                        @Override
                        public float getBrightness() {
                            return RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), partialTicks, 5 + r.nextInt(15));
                        }
                    }, ResearchManager.clientProgress.hasConstellationDiscovered(((IConstellation)entry.getValue()).getUnlocalizedName()), true);
                    ((RotationConstellationInformation)this.currentInformation.informationMap.get((Object)this.rotation)).informations.add(new ConstellationInformation(rectangles, (IConstellation)entry.getValue()));
                }
            }
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
            GL11.glPopAttrib();
        }
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        this.field_73735_i += 2.0f;
        this.drawDrawnLines(r, partialTicks);
        this.field_73735_i -= 2.0f;
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glPopAttrib();
    }

    private void drawDrawnLines(final Random r, final float pTicks) {
        if (!this.canStartDrawing()) {
            this.clearLines();
            this.abortDrawing();
            return;
        }
        float linebreadth = 2.0f;
        RenderConstellation.BrightnessFunction func = new RenderConstellation.BrightnessFunction(){

            @Override
            public float getBrightness() {
                return RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), pTicks, 5 + r.nextInt(15));
            }
        };
        textureConnection.bind();
        for (int j = 0; j < 2; ++j) {
            for (Line l : this.drawnLines) {
                this.drawLine(l.start, l.end, func, linebreadth, true);
            }
            if (this.start == null || this.end == null) continue;
            Point adjStart = new Point(this.start.x - this.guiLeft, this.start.y - this.guiTop);
            Point adjEnd = new Point(this.end.x - this.guiLeft, this.end.y - this.guiTop);
            this.drawLine(adjStart, adjEnd, func, linebreadth, false);
        }
    }

    private void drawLine(Point start, Point end, RenderConstellation.BrightnessFunction func, float linebreadth, boolean applyFunc) {
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        float brightness = applyFunc ? func.getBrightness() : 1.0f;
        float starBr = Minecraft.func_71410_x().field_71441_e.func_72880_h(1.0f);
        if (starBr <= 0.0f) {
            return;
        }
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)(brightness < 0.0f ? 0.0f : (brightness *= starBr * 2.0f)));
        Vector3 fromStar = new Vector3((double)this.guiLeft + start.getX(), (double)this.guiTop + start.getY(), (double)this.field_73735_i);
        Vector3 toStar = new Vector3((double)this.guiLeft + end.getX(), (double)this.guiTop + end.getY(), (double)this.field_73735_i);
        Vector3 dir = toStar.clone().subtract(fromStar);
        Vector3 degLot = dir.clone().crossProduct(new Vector3(0, 0, 1)).normalize().multiply(linebreadth);
        Vector3 vec00 = fromStar.clone().add(degLot);
        Vector3 vecV = degLot.clone().multiply(-2);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = vec00.clone().add(dir.clone().multiply(u)).add(vecV.clone().multiply(v));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)u, (double)v).func_181675_d();
        }
        tes.func_78381_a();
    }

    private void drawGridBackground(float partialTicks, boolean canSeeSky) {
        int rgbTo;
        int rgbFrom;
        GL11.glPushAttrib((int)1048575);
        Blending.PREALPHA.apply();
        WorldClient renderWorld = Minecraft.func_71410_x().field_71441_e;
        if (canSeeSky) {
            float starBr = renderWorld.func_72880_h(partialTicks) * 2.0f;
            float rain = renderWorld.func_72867_j(partialTicks);
            rgbFrom = RenderingUtils.clampToColorWithMultiplier(this.calcRGBFromWithRain(starBr, rain), 1.0f).getRGB();
            rgbTo = RenderingUtils.clampToColorWithMultiplier(this.calcRGBToWithRain(starBr, rain), 1.0f).getRGB();
        } else {
            rgbFrom = 0;
            rgbTo = 0;
        }
        int alphaMask = -16777216;
        RenderingUtils.drawGradientRect(this.guiLeft + 4, this.guiTop + 4, this.field_73735_i, this.guiLeft + this.guiWidth - 4, this.guiTop + this.guiHeight - 4, new Color(alphaMask | rgbFrom), new Color(alphaMask | rgbTo));
        Blending.DEFAULT.apply();
        GL11.glPopAttrib();
    }

    private boolean canTelescopeSeeSky(World renderWorld) {
        BlockPos pos = this.guiOwner.func_174877_v();
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                BlockPos other = pos.func_177982_a(xx, 0, zz);
                if (renderWorld.func_175678_i(other)) continue;
                return false;
            }
        }
        return renderWorld.func_175678_i(pos.func_177984_a());
    }

    private int calcRGBToWithRain(float starBr, float rain) {
        int to = this.calcRGBTo(starBr);
        if (starBr <= 0.8f) {
            float starMul = 1.0f;
            if (starBr > 0.5f) {
                starMul = 1.0f - (starBr - 0.5f) / 0.3f;
            }
            float interpDeg = starMul * rain;
            Color safeTo = RenderingUtils.clampToColor(to);
            Vector3 vTo = new Vector3(safeTo.getRed(), safeTo.getGreen(), safeTo.getBlue()).divide(255.0);
            Vector3 rainC = new Vector3(102, 114, 137).divide(255.0);
            Vector3 interpVec = vTo.copyInterpolateWith(rainC, interpDeg);
            Color newColor = RenderingUtils.clampToColor((int)(interpVec.getX() * 255.0), (int)(interpVec.getY() * 255.0), (int)(interpVec.getZ() * 255.0));
            to = newColor.getRGB();
        }
        return RenderingUtils.clampToColor(to).getRGB();
    }

    private int calcRGBTo(float starBr) {
        if (starBr >= 0.8f) {
            return 0;
        }
        if (starBr >= 0.5f) {
            float partSize = 0.3f;
            float perc = 1.0f - (starBr - 0.5f) / partSize;
            return (int)(perc * 170.0f);
        }
        if (starBr >= 0.2f) {
            float partSize = 0.3f;
            float perc = 1.0f - (starBr - 0.2f) / partSize;
            int green = (int)(perc * 85.0f);
            int blue = green + 170;
            return green << 8 | blue;
        }
        float partSize = 0.2f;
        float perc = 1.0f - (starBr - 0.0f) / partSize;
        int green = 85 + (int)(perc * 90.0f);
        int red = (int)(perc * 140.0f);
        return red << 16 | green << 8 | 0xFF;
    }

    private int calcRGBFromWithRain(float starBr, float rain) {
        int to = this.calcRGBFrom(starBr);
        if (starBr <= 1.0f) {
            float starMul = 1.0f;
            if (starBr > 0.6f) {
                starMul = 1.0f - (starBr - 0.6f) / 0.39999998f;
            }
            float interpDeg = starMul * rain;
            Color safeTo = RenderingUtils.clampToColor(to);
            Vector3 vTo = new Vector3(safeTo.getRed(), safeTo.getGreen(), safeTo.getBlue()).divide(255.0);
            Vector3 rainC = new Vector3(102, 114, 137).divide(255.0);
            Vector3 interpVec = vTo.copyInterpolateWith(rainC, interpDeg);
            Color newColor = RenderingUtils.clampToColor((int)(interpVec.getX() * 255.0), (int)(interpVec.getY() * 255.0), (int)(interpVec.getZ() * 255.0));
            to = newColor.getRGB();
        }
        return RenderingUtils.clampToColor(to).getRGB();
    }

    private int calcRGBFrom(float starBr) {
        if (starBr >= 1.0f) {
            return 0;
        }
        if (starBr >= 0.6f) {
            float partSize = 0.39999998f;
            float perc = 1.0f - (starBr - 0.6f) / partSize;
            return (int)(perc * 170.0f);
        }
        if (starBr >= 0.3f) {
            float partSize = 0.3f;
            float perc = 1.0f - (starBr - 0.3f) / partSize;
            int green = (int)(perc * 85.0f);
            int blue = green + 170;
            return green << 8 | blue;
        }
        float partSize = 0.3f;
        float perc = 1.0f - (starBr - 0.0f) / partSize;
        int green = 85 + (int)(perc * 90.0f);
        int red = (int)(perc * 140.0f);
        return red << 16 | green << 8 | 0xFF;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            this.tryStartDrawing(mouseX, mouseY);
        }
        if (mouseX <= this.guiLeft || mouseX >= this.guiLeft + this.guiWidth || mouseY <= this.guiTop || mouseY >= this.guiTop + this.guiHeight) {
            this.clearLines();
            this.abortDrawing();
        }
        Point p = new Point(mouseX, mouseY);
        if (this.rectArrowCW != null && this.rectArrowCW.contains(p)) {
            PktRotateTelescope pkt = new PktRotateTelescope(true, this.guiOwner.func_145831_w().field_73011_w.getDimension(), this.guiOwner.func_174877_v());
            PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
            return;
        }
        if (this.rectArrowCCW != null && this.rectArrowCCW.contains(p)) {
            PktRotateTelescope pkt = new PktRotateTelescope(false, this.guiOwner.func_145831_w().field_73011_w.getDimension(), this.guiOwner.func_174877_v());
            PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (clickedMouseButton == 0) {
            this.informMovement(mouseX, mouseY);
        }
        if (mouseX <= this.guiLeft || mouseX >= this.guiLeft + this.guiWidth || mouseY <= this.guiTop || mouseY >= this.guiTop + this.guiHeight) {
            this.clearLines();
            this.abortDrawing();
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.informRelease(mouseX, mouseY);
        }
        if (mouseX <= this.guiLeft || mouseX >= this.guiLeft + this.guiWidth || mouseY <= this.guiTop || mouseY >= this.guiTop + this.guiHeight) {
            this.clearLines();
            this.abortDrawing();
        }
    }

    private void tryStartDrawing(int mouseX, int mouseY) {
        if (!this.canStartDrawing()) {
            return;
        }
        this.start = new Point(mouseX, mouseY);
        this.end = new Point(mouseX, mouseY);
    }

    private boolean canStartDrawing() {
        return Minecraft.func_71410_x().field_71441_e.func_72880_h(1.0f) >= 0.35f;
    }

    private void clearLines() {
        this.drawnLines.clear();
    }

    private void informMovement(int mouseX, int mouseY) {
        if (!this.canStartDrawing()) {
            return;
        }
        this.end = new Point(mouseX, mouseY);
    }

    private void informRelease(int mouseX, int mouseY) {
        if (!this.canStartDrawing()) {
            return;
        }
        if (this.start == null) {
            return;
        }
        this.end = new Point(mouseX, mouseY);
        this.pushDrawnLine(this.start, this.end);
        this.abortDrawing();
        this.checkConstellation(this.drawnLines);
    }

    private void checkConstellation(List<Line> drawnLines) {
        RotationConstellationInformation infos = (RotationConstellationInformation)this.currentInformation.informationMap.get((Object)this.rotation);
        if (infos == null) {
            return;
        }
        List renderInfos = infos.informations;
        if (renderInfos.isEmpty()) {
            return;
        }
        block0: for (ConstellationInformation info : renderInfos) {
            List<StarConnection> sc;
            IConstellation c = info.constellation;
            if (c == null || ResearchManager.clientProgress.hasConstellationDiscovered(c.getUnlocalizedName())) continue;
            PlayerProgress client = ResearchManager.clientProgress;
            if (client == null) {
                return;
            }
            boolean has = false;
            for (String strConstellation : client.getSeenConstellations()) {
                IConstellation ce = ConstellationRegistry.getConstellationByName(strConstellation);
                if (ce == null || !ce.equals(c)) continue;
                has = true;
                break;
            }
            if (!has || (sc = c.getStarConnections()).size() != drawnLines.size() || !c.canDiscover(ResearchManager.clientProgress)) continue;
            Map stars = info.starRectangles;
            for (StarConnection connection : sc) {
                Rectangle fromRect = (Rectangle)stars.get(connection.from);
                if (fromRect == null) {
                    AstralSorcery.log.info("Could not check constellation of telescope drawing - starLocation is missing?");
                    continue block0;
                }
                Rectangle toRect = (Rectangle)stars.get(connection.to);
                if (toRect == null) {
                    AstralSorcery.log.info("Could not check constellation of telescope drawing - starLocation is missing?");
                    continue block0;
                }
                if (this.containsMatch(drawnLines, fromRect, toRect)) continue;
                continue block0;
            }
            PacketChannel.CHANNEL.sendToServer((IMessage)new PktDiscoverConstellation(c.getUnlocalizedName()));
            this.clearLines();
            this.abortDrawing();
            return;
        }
    }

    private boolean containsMatch(List<Line> drawnLines, Rectangle r1, Rectangle r2) {
        for (Line l : drawnLines) {
            Point start = l.start;
            Point end = l.end;
            start = new Point(start.x + this.guiLeft, start.y + this.guiTop);
            end = new Point(end.x + this.guiLeft, end.y + this.guiTop);
            if ((!r1.contains(start) || !r2.contains(end)) && (!r2.contains(start) || !r1.contains(end))) continue;
            return true;
        }
        return false;
    }

    private void pushDrawnLine(Point start, Point end) {
        if (Math.abs(start.getX() - end.getX()) <= 2.0 && Math.abs(start.getY() - end.getY()) <= 2.0) {
            return;
        }
        Point adjStart = new Point(start.x - this.guiLeft, start.y - this.guiTop);
        Point adjEnd = new Point(end.x - this.guiLeft, end.y - this.guiTop);
        Line l = new Line(adjStart, adjEnd);
        this.drawnLines.addLast(l);
    }

    private void abortDrawing() {
        this.start = null;
        this.end = null;
    }

    public boolean func_73868_f() {
        return false;
    }

    public static class Line {
        public final Point start;
        public final Point end;

        public Line(Point start, Point end) {
            this.start = start;
            this.end = end;
        }
    }

    public static class ConstellationInformation {
        private final Map<StarLocation, Rectangle> starRectangles;
        private final IConstellation constellation;

        public ConstellationInformation(Map<StarLocation, Rectangle> starRectangles, IConstellation c) {
            this.starRectangles = starRectangles;
            this.constellation = c;
        }
    }

    public static class RotationConstellationInformation {
        private final List<ConstellationInformation> informations = new LinkedList<ConstellationInformation>();
        private final Map<Point, IConstellation> constellations = new HashMap<Point, IConstellation>();
    }

    public static class SkyConstellationDistribution {
        private static final float constellationWH = 150.0f;
        private final Map<TileTelescope.TelescopeRotation, RotationConstellationInformation> informationMap = new HashMap<TileTelescope.TelescopeRotation, RotationConstellationInformation>();
    }
}

