/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal.page;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public interface IGuiRenderablePage {
    public static final IGuiRenderablePage GUI_INTERFACE = (offsetX, offsetY, pTicks, zLevel, mouseX, mouseY) -> {};
    public static final BindableResource resStar = AssetLibrary.loadTexture(AssetLoader.TextureLocation.ENVIRONMENT, "star1");

    public void render(float var1, float var2, float var3, float var4, float var5, float var6);

    default public void postRender(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
    }

    default public boolean propagateMouseClick(int mouseX, int mouseZ) {
        return false;
    }

    default public Rectangle drawItemStack(ItemStack stack, int offsetX, int offsetY, float zLevel) {
        return this.drawItemStack(stack, offsetX, offsetY, zLevel, this.getStandardFontRenderer(), this.getRenderItem());
    }

    default public Rectangle drawItemStack(ItemStack stack, int offsetX, int offsetY, float zLevel, FontRenderer fontRenderer, RenderItem ri) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        float zIR = ri.field_77023_b;
        ri.field_77023_b = zLevel;
        RenderHelper.func_74520_c();
        ri.func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, stack, offsetX, offsetY);
        ri.func_180453_a(fontRenderer, stack, offsetX, offsetY, null);
        RenderHelper.func_74518_a();
        GlStateManager.func_179141_d();
        ri.field_77023_b = zIR;
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        return new Rectangle(offsetX, offsetY, 16, 16);
    }

    default public Rectangle drawInfoStar(float offsetX, float offsetY, float zLevel, float widthHeightBase, float pTicks) {
        float tick = (float)ClientScheduler.getClientTick() + pTicks;
        float deg = tick * 2.0f % 360.0f;
        float wh = widthHeightBase - widthHeightBase / 6.0f * (MathHelper.func_76126_a((float)((float)Math.toRadians(tick * 4.0f % 360.0f))) + 1.0f);
        this.drawInfoStarSingle(offsetX, offsetY, zLevel, wh, Math.toRadians(deg));
        deg = (tick + 22.5f) * 2.0f % 360.0f;
        wh = widthHeightBase - widthHeightBase / 6.0f * (MathHelper.func_76126_a((float)((float)Math.toRadians((tick + 45.0f) * 4.0f % 360.0f))) + 1.0f);
        this.drawInfoStarSingle(offsetX, offsetY, zLevel, wh, Math.toRadians(deg));
        return new Rectangle(MathHelper.func_76141_d((float)(offsetX - widthHeightBase / 2.0f)), MathHelper.func_76141_d((float)(offsetY - widthHeightBase / 2.0f)), MathHelper.func_76141_d((float)widthHeightBase), MathHelper.func_76141_d((float)widthHeightBase));
    }

    default public void drawInfoStarSingle(float offsetX, float offsetY, float zLevel, float widthHeight, double deg) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        resStar.bind();
        Vector3 offset = new Vector3((double)(-widthHeight) / 2.0, (double)(-widthHeight) / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Vector3 uv01 = new Vector3((double)(-widthHeight) / 2.0, (double)widthHeight / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Vector3 uv11 = new Vector3((double)widthHeight / 2.0, (double)widthHeight / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Vector3 uv10 = new Vector3((double)widthHeight / 2.0, (double)(-widthHeight) / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)offsetX + uv01.getX(), (double)offsetY + uv01.getY(), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b((double)offsetX + uv11.getX(), (double)offsetY + uv11.getY(), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)offsetX + uv10.getX(), (double)offsetY + uv10.getY(), (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b((double)offsetX + offset.getX(), (double)offsetY + offset.getY(), (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_78381_a();
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    default public void drawRect(double offsetX, double offsetY, double width, double height, double zLevel) {
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(offsetX, offsetY + height, zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b(offsetX + width, offsetY + height, zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b(offsetX + width, offsetY, zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b(offsetX, offsetY, zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_78381_a();
    }

    default public void drawRectPart(double offsetX, double offsetY, double width, double height, double zLevel, double u, double v, double uLength, double vLength) {
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(offsetX, offsetY + height, zLevel).func_187315_a(u, v + vLength).func_181675_d();
        vb.func_181662_b(offsetX + width, offsetY + height, zLevel).func_187315_a(u + uLength, v + vLength).func_181675_d();
        vb.func_181662_b(offsetX + width, offsetY, zLevel).func_187315_a(u + uLength, v).func_181675_d();
        vb.func_181662_b(offsetX, offsetY, zLevel).func_187315_a(u, v).func_181675_d();
        tes.func_78381_a();
    }

    default public RenderItem getRenderItem() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    default public FontRenderer getStandardFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    default public FontRenderer getStandardGalFontRenderer() {
        return Minecraft.func_71410_x().field_71464_q;
    }

    default public String getDescriptionFromStarlightAmount(String locTierTitle, int amtRequired, int maxAmount) {
        String base = "astralsorcery.journal.recipe.amt.";
        float perc = (float)amtRequired / (float)maxAmount;
        String ext = (double)perc <= 0.1 ? "lowest" : ((double)perc <= 0.25 ? "low" : ((double)perc <= 0.5 ? "avg" : ((double)perc <= 0.75 ? "more" : ((double)perc <= 0.9 ? "high" : (perc > 1.0f ? "toomuch" : "highest")))));
        return String.format("%s: %s", locTierTitle, I18n.func_135052_a((String)String.format("%s%s", base, ext), (Object[])new Object[0]));
    }
}

