/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal.page;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.journal.page.IGuiRenderablePage;
import hellfirepvp.astralsorcery.client.gui.journal.page.IJournalPage;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.crafting.IAccessibleRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.registry.RegistryBookLookups;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class JournalPageLightProximityRecipe
implements IJournalPage {
    private final ShapedRecipe shapedLightProxRecipe;

    public JournalPageLightProximityRecipe(ShapedRecipe shapedLightProxRecipe) {
        this.shapedLightProxRecipe = shapedLightProxRecipe;
    }

    @Override
    public IGuiRenderablePage buildRenderPage() {
        return new Render(this.shapedLightProxRecipe);
    }

    public static class Render
    implements IGuiRenderablePage {
        private static final BindableResource texGrid = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "gridDisc");
        private final ShapedRecipe recipe;
        private Map<Rectangle, ItemStack> thisFrameStackFrames = new HashMap<Rectangle, ItemStack>();

        public Render(ShapedRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        public boolean propagateMouseClick(int mouseX, int mouseZ) {
            for (Rectangle r : this.thisFrameStackFrames.keySet()) {
                ItemStack stack;
                RegistryBookLookups.LookupInfo lookup;
                if (!r.contains(mouseX, mouseZ) || (lookup = RegistryBookLookups.tryGetPage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT, stack = this.thisFrameStackFrames.get(r))) == null) continue;
                RegistryBookLookups.openLookupJournalPage(lookup);
            }
            return false;
        }

        protected void renderStandartRecipeGrid(float offsetX, float offsetY, float zLevel, BindableResource grid) {
            GL11.glEnable((int)3042);
            Blending.DEFAULT.apply();
            grid.bind();
            this.drawRect(offsetX + 25.0f, offsetY, 129.0, 202.0, zLevel);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureHelper.refreshTextureBindState();
        }

        protected void renderOutputOnGrid(float offsetX, float offsetY, float zLevel) {
            RenderHelper.func_74520_c();
            ItemStack out = this.recipe.getOutput();
            GL11.glPushMatrix();
            GL11.glTranslated((double)(offsetX + 78.0f), (double)(offsetY + 25.0f), (double)(zLevel + 60.0f));
            GL11.glScaled((double)1.4, (double)1.4, (double)1.4);
            Rectangle r = this.drawItemStack(out, 0, 0, 0.0f);
            r = new Rectangle((int)offsetX + 78, (int)offsetY + 25, (int)(r.getWidth() * 1.4), (int)(r.getHeight() * 1.4));
            this.thisFrameStackFrames.put(r, out);
            GL11.glPopMatrix();
            TextureHelper.refreshTextureBindState();
            RenderHelper.func_74518_a();
        }

        protected void renderDefaultExpectedItems(float offsetX, float offsetY, float zLevel, IAccessibleRecipe recipe) {
            RenderHelper.func_74520_c();
            double offX = offsetX + 55.0f;
            double offY = offsetY + 103.0f;
            for (ShapedRecipeSlot srs : ShapedRecipeSlot.values()) {
                List<ItemStack> expected = recipe.getExpectedStackForRender(srs);
                if (expected == null || expected.isEmpty()) {
                    expected = recipe.getExpectedStackForRender(srs.rowMultipler, srs.columnMultiplier);
                }
                if (expected == null || expected.isEmpty()) continue;
                long select = (ClientScheduler.getClientTick() + (long)(srs.rowMultipler * 40) + (long)(srs.columnMultiplier * 40)) / 20L;
                ItemStack draw = expected.get((int)(select %= (long)expected.size()));
                TextureHelper.refreshTextureBindState();
                GL11.glPushMatrix();
                GL11.glTranslated((double)(offX + (double)(srs.columnMultiplier * 25)), (double)(offY + (double)(srs.rowMultipler * 25)), (double)(zLevel + 60.0f));
                GL11.glScaled((double)1.13, (double)1.13, (double)1.13);
                Rectangle r = this.drawItemStack(draw, 0, 0, 0.0f);
                r = new Rectangle((int)offX + srs.columnMultiplier * 25, (int)offY + srs.rowMultipler * 25, (int)(r.getWidth() * 1.13), (int)(r.getHeight() * 1.13));
                this.thisFrameStackFrames.put(r, draw);
                GL11.glPopMatrix();
            }
            RenderHelper.func_74518_a();
        }

        @Override
        public void render(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
            this.thisFrameStackFrames.clear();
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            this.renderStandartRecipeGrid(offsetX, offsetY, zLevel, texGrid);
            this.renderOutputOnGrid(offsetX, offsetY, zLevel);
            this.renderDefaultExpectedItems(offsetX, offsetY, zLevel, this.recipe.make());
            TextureHelper.refreshTextureBindState();
            TextureHelper.setActiveTextureToAtlasSprite();
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }

        public void addStackTooltip(float mouseX, float mouseY, List<String> tooltip) {
            for (Rectangle rect : this.thisFrameStackFrames.keySet()) {
                RegistryBookLookups.LookupInfo lookup;
                if (!rect.contains(mouseX, mouseY)) continue;
                ItemStack stack = this.thisFrameStackFrames.get(rect);
                try {
                    tooltip.addAll(stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x));
                }
                catch (Throwable tr) {
                    tooltip.add(TextFormatting.RED + "<Error upon trying to get this item's tooltip>");
                }
                if ((lookup = RegistryBookLookups.tryGetPage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT, stack)) == null) continue;
                tooltip.add("");
                tooltip.add(I18n.func_135052_a((String)"misc.craftInformation", (Object[])new Object[0]));
            }
        }

        @Override
        public void postRender(float offsetX, float offsetY, float pTicks, float zLevel, float mouseX, float mouseY) {
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2929);
            float widthHeightStar = 15.0f;
            Rectangle r = this.drawInfoStar(offsetX + 140.0f, offsetY + 20.0f, zLevel, widthHeightStar, pTicks);
            if (r.contains(mouseX, mouseY)) {
                RenderingUtils.renderBlueTooltip((int)offsetX, (int)offsetY, Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"astralsorcery.journal.recipe.starlight", (Object[])new Object[0])}), Minecraft.func_71410_x().field_71466_p);
            }
            LinkedList out = Lists.newLinkedList();
            this.addStackTooltip(mouseX, mouseY, out);
            if (!out.isEmpty()) {
                RenderingUtils.renderBlueTooltip((int)mouseX, (int)mouseY, out, this.getStandardFontRenderer());
            }
            GL11.glDisable((int)3042);
            GL11.glPopAttrib();
        }
    }
}

